/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.ReservedCharacters;

public class WordsUtil {
    private static Character[] DEFAULT_PUNCTUACTION = new Character[]{Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('\\'), Character.valueOf('='), Character.valueOf('&')};
    private static char[] PUNCTUATION = null;

    static {
        HashSet<Character> combined = new HashSet<Character>();
        combined.addAll(Arrays.asList(DEFAULT_PUNCTUACTION));
        combined.addAll(ReservedCharacters.getChars());
        combined.remove(Character.valueOf('\''));
        PUNCTUATION = new char[combined.size()];
        int index = 0;
        for (Character character : combined) {
            WordsUtil.PUNCTUATION[index] = character.charValue();
            ++index;
        }
        Arrays.sort(PUNCTUATION);
    }

    public static String[] splitOnPunctuation(String original) {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (index < original.length()) {
            char c = original.charAt(index);
            int pos = Arrays.binarySearch(PUNCTUATION, c);
            if (pos < 0) {
                buffer.append(c);
            } else {
                WordsUtil.addToList(buffer.toString(), toReturn);
                buffer.setLength(0);
            }
            ++index;
        }
        WordsUtil.addToList(buffer.toString(), toReturn);
        buffer.setLength(0);
        return toReturn.toArray(new String[toReturn.size()]);
    }

    private static void addToList(String toAdd, List<String> list) {
        if ((toAdd = toAdd.trim()).length() > 0 && (toAdd = WordsUtil.removeSingleQuotesFromBeginningAndEnd(toAdd)).length() > 0) {
            list.add(toAdd);
        }
    }

    public static boolean isPunctuationOrApostrophe(char character) {
        return Arrays.binarySearch(PUNCTUATION, character) > 0 || character == '\'';
    }

    public static int countPuntuation(String original) {
        int toReturn = 0;
        int index = 0;
        while (index < original.length()) {
            int pos = Arrays.binarySearch(PUNCTUATION, original.charAt(index));
            if (pos > 0) {
                ++toReturn;
            }
            ++index;
        }
        return toReturn;
    }

    public static boolean endsWithPunctuation(String original) {
        char c;
        int pos;
        boolean toReturn = false;
        int size = original.length();
        if (size > 0 && (pos = Arrays.binarySearch(PUNCTUATION, c = original.charAt(size - 1))) > 0) {
            toReturn = true;
        }
        return toReturn;
    }

    public static String removeSingleQuotesFromBeginningAndEnd(String original) {
        int startAt = 0;
        int stopAt = original.length();
        boolean process = false;
        if (original.startsWith("'")) {
            startAt = 1;
            process = true;
        }
        if (original.endsWith("'")) {
            stopAt = original.length() - 1;
            process = true;
        }
        if (process) {
            original = startAt > stopAt ? "" : original.substring(startAt, stopAt);
        }
        return original;
    }

    public static char[] removeExtraSpacesAndSpecialCharacters(String toSearch, boolean setAllToLowerCase) {
        boolean lastCharacterAddedWasWhiteSpace = false;
        StringBuilder searchString = new StringBuilder();
        int index = 0;
        while (index < toSearch.length()) {
            char currChar = toSearch.charAt(index);
            if (setAllToLowerCase) {
                currChar = Character.toLowerCase(currChar);
            }
            if (currChar != '\r' && currChar != '\n') {
                if (WordsUtil.isPunctuationOrApostrophe(currChar)) {
                    currChar = ' ';
                }
                if (Character.isWhitespace(currChar)) {
                    if (!lastCharacterAddedWasWhiteSpace) {
                        searchString.append(currChar);
                        lastCharacterAddedWasWhiteSpace = true;
                    }
                } else {
                    searchString.append(currChar);
                    lastCharacterAddedWasWhiteSpace = false;
                }
            }
            ++index;
        }
        return searchString.toString().trim().toCharArray();
    }
}

