/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.db.internal.callable.FetchDatastoreInfoCallable;
import org.eclipse.osee.orcs.db.internal.callable.MigrateDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;
import org.eclipse.osee.orcs.db.internal.util.DynamicSchemaResourceProvider;

public class DataStoreAdminImpl
implements DataStoreAdmin {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SystemProperties properties;

    public DataStoreAdminImpl(Log logger, JdbcClient jdbcClient, SystemProperties properties) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.properties = properties;
    }

    public void createDataStore() {
        DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(this.logger);
        JdbcMigrationOptions options = new JdbcMigrationOptions(true, true);
        Conditions.checkExpressionFailOnTrue((boolean)this.jdbcClient.getConfig().isProduction(), (String)"Error - attempting to initialize a production datastore.", (Object[])new Object[0]);
        this.jdbcClient.createDataStore(options, (Iterable)schemaProvider.get());
        String attributeDataPath = ResourceConstants.getAttributeDataPath(this.properties);
        this.logger.info("Deleting application server binary data [%s]...", new Object[]{attributeDataPath});
        Lib.deleteDir((File)new File(attributeDataPath));
        this.properties.putValue("osee.db.guid", GUID.create());
        this.addDefaultPermissions();
        this.jdbcClient.invalidateSequences();
    }

    private void addDefaultPermissions() {
        LinkedList<Object[]> data = new LinkedList<Object[]>();
        PermissionEnum[] permissionEnumArray = PermissionEnum.values();
        int n = permissionEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PermissionEnum permission = permissionEnumArray[n2];
            data.add(new Object[]{permission.getPermId(), permission.getName()});
            ++n2;
        }
        this.jdbcClient.runBatchUpdate("INSERT INTO OSEE_PERMISSION (PERMISSION_ID, PERMISSION_NAME) VALUES (?,?)", data);
    }

    public Callable<DataStoreInfo> migrateDataStore(OrcsSession session) {
        DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(this.logger);
        JdbcMigrationOptions options = new JdbcMigrationOptions(false, false);
        return new MigrateDatastoreCallable(session, this.logger, this.jdbcClient, this.properties, schemaProvider, options);
    }

    public Callable<DataStoreInfo> getDataStoreInfo(OrcsSession session) {
        DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(this.logger);
        return new FetchDatastoreInfoCallable(this.logger, this.jdbcClient, schemaProvider, this.properties);
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public void updateBootstrapUser(UserId accountId) {
        this.jdbcClient.runPreparedUpdate("UPDATE osee_tx_details SET author = ? where author <= 0", new Object[]{accountId});
    }
}

