/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io.xml;

import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSheetWriter;

public class WordMlTableWriter
extends AbstractSheetWriter {
    private static final String TABLE_START = "<w:tbl><w:tblPr><w:tblBorders><w:top w:val=\"single\" w:sz=\"1\" /><w:left w:val=\"single\" w:sz=\"1\" /><w:bottom w:val=\"single\" w:sz=\"1\" /><w:right w:val=\"single\" w:sz=\"1\" /><w:insideH w:val=\"single\" w:sz=\"1\" /><w:insideV w:val=\"single\" w:sz=\"1\" /></w:tblBorders></w:tblPr>";
    private static final String TABLE_END = "</w:tbl>";
    private static final String START_TABLE_GRID = "<w:tblGrid>";
    private static final String END_TABLE_GRID = "</w:tblGrid>";
    private static final String TABLE_GRID = "<w:gridCol w:w=\"1024\" />";
    private static final String CELL_STRART = "<w:tc><w:tcPr><w:tcW w:w=\"1024\" /></w:tcPr><w:p><w:r><w:t>";
    private static final String CELL_END = "</w:t></w:r></w:p></w:tc>";
    private static final String ROW_START = "<w:tr>";
    private static final String ROW_END = "</w:tr>";
    private final Appendable str;
    private int columnSize;
    private boolean startTable;

    public WordMlTableWriter(Appendable str) {
        this.str = str;
    }

    @Override
    public void startSheet(String worksheetName, int columnCount) throws IOException {
        this.str.append(TABLE_START);
        this.columnSize = columnCount;
        this.startTable = true;
    }

    @Override
    public void endSheet() throws IOException {
        this.str.append(TABLE_END);
    }

    @Override
    protected void startRow() throws IOException {
        if (this.startTable) {
            this.writeTableGridData();
        }
        this.str.append(ROW_START);
    }

    @Override
    public void writeEndRow() throws IOException {
        this.str.append(ROW_END);
    }

    private void writeTableGridData() throws IOException {
        this.str.append(START_TABLE_GRID);
        int i = 0;
        while (i < this.columnSize) {
            this.str.append(TABLE_GRID);
            ++i;
        }
        this.str.append(END_TABLE_GRID);
    }

    @Override
    public void writeCellText(Object cellData, int cellIndex) throws IOException {
        if (cellData instanceof String) {
            String cellDataStr = (String)cellData;
            this.str.append(CELL_STRART);
            this.str.append(cellDataStr);
            this.str.append(CELL_END);
        }
    }

    @Override
    public void endWorkbook() {
    }

    @Override
    public void setActiveSheet(int sheetNum) {
    }

    @Override
    public void endWorkbook(boolean closeFile) {
    }
}

