/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.result;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.result.IResultDataListener;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTable;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class XResultData {
    public static XResultData EMPTY_RD = new XResultData();
    public static final Pattern ErrorPattern = Pattern.compile("Error: ");
    public static final Pattern WarningPattern = Pattern.compile("Warning: ");
    @JsonIgnore
    public List<IResultDataListener> listeners;
    public String title;
    private List<String> results = new LinkedList<String>();
    private List<String> ids = new LinkedList<String>();
    private int errorCount;
    private int warningCount;
    private int infoCount;
    @JsonIgnore
    private boolean logToSysErr;
    public List<XResultTable> tables = new ArrayList<XResultTable>();
    private String txId = "";

    public XResultData() {
        this(false);
    }

    public XResultData(boolean enableOseeLog) {
        this.logToSysErr = enableOseeLog;
        this.clear();
    }

    public XResultData(boolean logToSysErr, IResultDataListener ... listeners) {
        this.logToSysErr = logToSysErr;
        this.clear();
        if (listeners != null && listeners.length > 0) {
            this.listeners = Arrays.asList(listeners);
        }
    }

    public void clear() {
        this.results.clear();
        this.errorCount = 0;
        this.warningCount = 0;
        this.infoCount = 0;
    }

    public void combine(XResultData other) {
        if (this.equals(other)) {
            return;
        }
        this.errorCount += other.errorCount;
        this.warningCount += other.warningCount;
        this.infoCount += other.infoCount;
        this.results.addAll(other.results);
        this.ids.addAll(other.ids);
        if (other.listeners != null) {
            this.listeners.addAll(other.listeners);
        }
    }

    public void addRaw(String str) {
        this.results.add(str);
    }

    public void log(String str) {
        this.logStr(Type.Info, String.valueOf(str) + "\n", new Object[0]);
    }

    public void logf(String formatStr, Object ... objs) {
        this.logStr(Type.Info, String.format(formatStr, objs), new Object[0]);
    }

    public void success(String formatStr, Object ... objs) {
        this.logStr(Type.Success, String.format(formatStr, objs), new Object[0]);
    }

    public void error(String str) {
        this.logStr(Type.Severe, String.valueOf(str) + "\n", new Object[0]);
    }

    public void errorf(String formatStr, Object ... objs) {
        this.logStr(Type.Severe, String.format(formatStr, objs), new Object[0]);
    }

    public void warning(String str) {
        this.logStr(Type.Warning, String.valueOf(str) + "\n", new Object[0]);
    }

    public void warningf(String formatStr, Object ... objs) {
        this.logStr(Type.Warning, String.format(formatStr, objs), new Object[0]);
    }

    public boolean isEmpty() {
        return this.toString().equals("");
    }

    public void bumpCount(Type type, int byAmt) {
        if (type == Type.Severe) {
            ++this.errorCount;
        } else if (type == Type.Warning) {
            ++this.warningCount;
        } else {
            ++this.infoCount;
        }
    }

    public void logStr(Type type, String format, Object ... data) {
        this.bumpCount(type, 1);
        String resultStr = "";
        resultStr = type == Type.Warning ? (data.length == 0 ? "Warning: " + format : "Warning: " + String.format(format, data)) : (type == Type.Severe ? (data.length == 0 ? "Error: " + format : "Error: " + String.format(format, data)) : (type == Type.Success ? (data.length == 0 ? "Success: " + format : "Success: " + String.format(format, data)) : (data.length == 0 ? format : String.format(format, data))));
        this.addRaw(resultStr);
        if (this.listeners != null) {
            for (IResultDataListener listener : this.listeners) {
                listener.log(type, resultStr);
            }
        }
        if (this.isLogToSysErr()) {
            if (type == Type.Severe || type == Type.ConsoleErr) {
                System.err.print(resultStr);
            } else {
                System.out.print(resultStr);
            }
        }
    }

    public void dispose() {
    }

    public String toString() {
        return Collections.toString("", this.results);
    }

    private int getCount(Type type) {
        if (type == Type.Severe) {
            return this.errorCount;
        }
        if (type == Type.Warning) {
            return this.warningCount;
        }
        return this.infoCount;
    }

    public int getNumErrors() {
        return this.getCount(Type.Severe);
    }

    public int getNumErrorsViaSearch() {
        return Lib.getMatcherCount(ErrorPattern, this.toString());
    }

    public int getNumWarningsViaSearch() {
        return Lib.getMatcherCount(WarningPattern, this.toString());
    }

    public int getNumWarnings() {
        return this.getCount(Type.Warning);
    }

    public boolean isErrors() {
        return this.getNumErrors() > 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setResults(List<String> results) {
        this.results = results;
    }

    public List<String> getResults() {
        return this.results;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public int getInfoCount() {
        return this.infoCount;
    }

    public void setInfoCount(int infoCount) {
        this.infoCount = infoCount;
    }

    public void validateNotNullOrEmpty(String value, String message, Object ... data) {
        if (!Strings.isValid(value)) {
            this.errorf(String.valueOf(message) + " can not be null or emtpy", data);
        }
    }

    public void validateTrue(boolean value, String message, Object ... data) {
        if (!value) {
            this.errorf(message, data);
        }
    }

    public void validateNotNull(Date date, String message, Object ... data) {
        if (date == null) {
            this.errorf(message, data);
        }
    }

    public void validateNotNull(String str, String message, Object ... data) {
        if (str == null) {
            this.errorf(message, data);
        }
    }

    public void validateNotNull(Integer value, String message, Object ... data) {
        if (value == null) {
            this.errorf(message, data);
        }
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public boolean isSuccess() {
        return !this.isErrors();
    }

    public boolean isLogToSysErr() {
        return this.logToSysErr;
    }

    public void setLogToSysErr(boolean logToSysErr) {
        this.logToSysErr = logToSysErr;
    }

    public boolean isFailed() {
        return !this.isSuccess();
    }

    public List<XResultTable> getTables() {
        return this.tables;
    }

    public void setTables(List<XResultTable> tables) {
        this.tables = tables;
    }

    public void addResultsTag() {
        this.log("PUT_RESULTS_HERE");
    }

    @JsonIgnore
    public String getHtml() {
        String html = this.toString();
        html = AHTML.textToHtml(html);
        html = html.replaceFirst("PUT_RESULTS_HERE", this.getResultsString());
        html = html.replaceAll("Error:", Matcher.quoteReplacement(AHTML.color("RED", "Error:")));
        html = html.replaceAll("Warning:", Matcher.quoteReplacement(AHTML.color("BLUE", "Warning:")));
        html = html.replaceAll("\n", "<br/>");
        return html;
    }

    private String getResultsString() {
        return String.format("Error: %s, Warning: %s", this.getErrorCount(), this.getWarningCount());
    }

    public void merge(XResultData rd) {
        this.errorCount += rd.getErrorCount();
        this.warningCount += rd.getWarningCount();
        this.infoCount += rd.getInfoCount();
        this.addRaw(rd.toString());
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public static enum Type {
        Severe,
        Warning,
        Info,
        Success,
        ConsoleErr,
        ConsoleOut;

    }
}

