/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.account.admin.AccountAdmin;
import org.eclipse.osee.account.admin.SubscriptionAdmin;
import org.eclipse.osee.account.rest.internal.AccountConfiguration;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.internal.AccountsResource;
import org.eclipse.osee.account.rest.internal.SubscriptionsResource;
import org.eclipse.osee.account.rest.internal.UnsubscribeResource;

@ApplicationPath(value="/")
public class AccountApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private AccountAdmin accountAdmin;
    private SubscriptionAdmin subscriptionAdmin;
    private volatile AccountConfiguration config;

    public void setConfig(AccountConfiguration config) {
        this.config = config;
    }

    public void setAccountAdmin(AccountAdmin accountAdmin) {
        this.accountAdmin = accountAdmin;
    }

    public void setSubscriptionAdmin(SubscriptionAdmin subscriptionAdmin) {
        this.subscriptionAdmin = subscriptionAdmin;
    }

    public void start(Map<String, Object> props) {
        this.update(props);
        AccountOps ops = new AccountOps(this.accountAdmin);
        this.singletons.add(new AccountsResource(ops, this.config));
        this.singletons.add(new SubscriptionsResource(this.subscriptionAdmin));
        this.singletons.add(new UnsubscribeResource(this.subscriptionAdmin));
    }

    public void stop() {
        this.singletons.clear();
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void update(Map<String, Object> props) {
        this.setConfig(AccountConfiguration.newConfig(props));
    }
}

