/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import flexjson.JSONSerializer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="Releases")
public class ReleasesResource
extends AbstractConfigResource {
    public ReleasesResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.Version, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getSprintByUuid")
    public String getSprintByUuid(String sprintUuid) {
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(sprintUuid, TransferableArtifact.class);
            if (artifact.getUuid() != null) {
                ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andUuid(Long.valueOf(artifact.getUuid()).longValue()).getResults();
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                Iterator iterator = list.iterator();
                if (iterator.hasNext()) {
                    ArtifactReadable artifactReadable = (ArtifactReadable)iterator.next();
                    TransferableArtifact ar = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    ar.putAttributes(AtsAttributeTypes.Released.getName(), Arrays.asList(artifactReadable.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Released)));
                    listTras.add(ar);
                    TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                    container.addAll(listTras);
                    String returnJson = gson.toJson((Object)container);
                    return returnJson;
                }
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="CreateReleaseWeb")
    public String createReleaseWeb(String json) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            boolean status = true;
            boolean isMileStone = false;
            ArtifactToken childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            ArtifactReadable artifactReadable1 = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
            UserId userId = UserId.valueOf((Long)artifactReadable1.getId());
            TransactionBuilder tx = txFactory.createTransaction(CommonUtil.getCommonBranch(orcsApi), userId, "Add New Release");
            String parentGuid = artifact.getParentGuid();
            ArtifactReadable parentRelease = null;
            ResultSet projectReadable = null;
            if (parentGuid != null) {
                parentRelease = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch(CommonUtil.getCommonBranch()).andUuid(Long.valueOf(parentGuid).longValue()).getResults().getOneOrNull();
                List sprintList = parentRelease.getChildren();
                for (ArtifactReadable sprint : sprintList) {
                    if (!sprint.getName().equalsIgnoreCase(artifact.getName())) continue;
                    status = false;
                    isMileStone = false;
                    break;
                }
            } else {
                String uuid = AtsRelationTypes.ProjectToVersion_Project.getGuid().toString();
                String type1 = AtsRelationTypes.ProjectToVersion_Project.getRelationType().toString();
                String side = AtsRelationTypes.ProjectToVersion_Project.getSide().toString();
                String key = "RelationTypeSide - uuid=[" + uuid + "] type=[" + type1 + "] side=[" + side + "]";
                ITransferableArtifact project = (ITransferableArtifact)artifact.getRelatedArtifacts(key).get(0);
                if (project != null) {
                    projectReadable = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(project.getUuid()).longValue()).getResults();
                    ResultSet mileStoneList = ((ArtifactReadable)projectReadable.getExactlyOne()).getRelated(AtsRelationTypes.ProjectToVersion_Version);
                    for (ArtifactReadable mileStone : mileStoneList) {
                        if (!mileStone.getName().equalsIgnoreCase(artifact.getName())) continue;
                        isMileStone = true;
                        status = false;
                        break;
                    }
                }
            }
            if (status) {
                List description;
                List baselineBranchGuid;
                childArtifact = tx.createArtifact(AtsArtifactTypes.Version, artifact.getName());
                List attributes = artifact.getAttributes(AtsAttributeTypes.ReleaseDate.toString());
                if (attributes != null && attributes.size() > 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
                    Date date = null;
                    try {
                        date = formatter.parse((String)attributes.get(0));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    tx.setSoleAttributeValue((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.ReleaseDate, (Object)date);
                }
                if ((baselineBranchGuid = artifact.getAttributes(AtsAttributeTypes.BaselineBranchGuid.toString())) != null && baselineBranchGuid.size() > 0) {
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchGuid, (String)baselineBranchGuid.get(0));
                }
                if ((description = artifact.getAttributes(AtsAttributeTypes.Description.toString())) != null && description.size() > 0) {
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.Description, (String)description.get(0));
                }
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.Released, "false");
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.AllowCreateBranch, "true");
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.AllowCommitBranch, "true");
                if (parentGuid != null) {
                    tx.relate((ArtifactId)parentRelease, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)childArtifact);
                } else {
                    if (projectReadable != null && projectReadable.size() == 1) {
                        tx.relate((ArtifactId)projectReadable.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.ProjectToVersion_Project, (ArtifactId)childArtifact);
                    }
                    String uuid = AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition.getGuid().toString();
                    String type1 = AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition.getRelationType().toString();
                    String side = AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition.getSide().toString();
                    String key = "RelationTypeSide - uuid=[" + uuid + "] type=[" + type1 + "] side=[" + side + "]";
                    List relatedArtifacts = artifact.getRelatedArtifacts(key);
                    for (ITransferableArtifact transferableArtifact : relatedArtifacts) {
                        ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(transferableArtifact.getUuid()).longValue()).getResults();
                        if (result == null || result.size() != 1) continue;
                        tx.relate((ArtifactId)result.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition, (ArtifactId)childArtifact);
                    }
                }
                tx.commit();
            }
            TransferableArtifact ar = new TransferableArtifact();
            if (status) {
                ar.putAttributes("Status", Arrays.asList("Success"));
                ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
                ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
                ar.setName(readableArtifact.getName());
                TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(readableArtifact, (ITransferableArtifact)ar);
            }
            if (!status) {
                ar.putAttributes("Status", Arrays.asList("Failure"));
                if (isMileStone) {
                    ar.putAttributes("Message", Arrays.asList("Milestone name already exists!!!!"));
                } else {
                    ar.putAttributes("Message", Arrays.asList("Sprint name already exists in this Milestone!!!!"));
                }
            }
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            container.addAll(Arrays.asList(ar));
            String json1 = gson.toJson((Object)container);
            return json1;
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="updateReleaseWeb")
    public String updateReleaseWeb(String json) {
        block11: {
            try {
                OrcsApi orcsApi = OseeCoreData.getOrcsApi();
                String serialize = null;
                Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
                TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
                TransactionFactory txFactory = orcsApi.getTransactionFactory();
                ArtifactReadable artifactReadable1 = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
                UserId userId = UserId.valueOf((Long)artifactReadable1.getId());
                TransactionBuilder tx = txFactory.createTransaction(CommonUtil.getCommonBranch(orcsApi), userId, "Update Release Artifact");
                String attribute = artifact.getUuid();
                if (attribute == null) break block11;
                ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).getResults();
                for (ArtifactReadable artifactReadable : list) {
                    List released;
                    List name;
                    List description;
                    List baselineBranchGuid;
                    if (!artifactReadable.getIdString().equals(attribute)) continue;
                    List attributes = artifact.getAttributes(AtsAttributeTypes.ReleaseDate.toString());
                    if (attributes != null && attributes.size() > 0) {
                        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
                        Date date = null;
                        try {
                            date = formatter.parse((String)attributes.get(0));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        tx.setSoleAttributeValue((ArtifactId)artifactReadable, (AttributeTypeToken)AtsAttributeTypes.ReleaseDate, (Object)date);
                    }
                    if ((baselineBranchGuid = artifact.getAttributes(AtsAttributeTypes.BaselineBranchGuid.toString())) != null && baselineBranchGuid.size() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchGuid, (String)baselineBranchGuid.get(0));
                    }
                    if ((description = artifact.getAttributes(AtsAttributeTypes.Description.toString())) != null && description.size() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)AtsAttributeTypes.Description, (String)description.get(0));
                    }
                    if ((name = artifact.getAttributes(CoreAttributeTypes.Name.toString())) != null && name.size() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)CoreAttributeTypes.Name, (String)name.get(0));
                    }
                    if ((released = artifact.getAttributes(AtsAttributeTypes.Released.toString())) != null && released.size() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)artifactReadable, (AttributeTypeToken)AtsAttributeTypes.Released, (String)released.get(0));
                    }
                    tx.commit();
                    ArrayList<TransferableArtifact> trans = new ArrayList<TransferableArtifact>();
                    TransferableArtifact ar = new TransferableArtifact();
                    ar.setName(artifactReadable.getName());
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    trans.add(ar);
                    TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                    container.addAll(trans);
                    JSONSerializer serializer = new JSONSerializer();
                    serialize = serializer.deepSerialize((Object)container);
                    break;
                }
                return serialize;
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
            catch (OseeCoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="releaseReleaseWeb")
    public String releaseReleaseWeb(String json) {
        Gson gson;
        String CanRelease;
        block5: {
            CanRelease = "true";
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String attributes = artifact.getUuid();
            if (attributes != null) {
                try {
                    ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andUuid(Long.valueOf(attributes).longValue()).getResults();
                    ArtifactReadable version = (ArtifactReadable)list.getOneOrNull();
                    if (version == null) break block5;
                    orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andRelatedTo(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, (ArtifactId)version).getResults();
                    ResultSet relatedTeamWF = version.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow);
                    if (relatedTeamWF == null || relatedTeamWF.size() <= 0) break block5;
                    for (ArtifactReadable teamWorkFlow : relatedTeamWF) {
                        String state = teamWorkFlow.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentState);
                        if (state.contains("Cancelled") || state.contains("Completed")) continue;
                        CanRelease = "false";
                        break;
                    }
                }
                catch (OseeCoreException e) {
                    e.printStackTrace();
                }
            }
        }
        if (CanRelease.equals("true")) {
            this.updateReleaseWeb(json);
        }
        TransferableArtifact reportArt = new TransferableArtifact();
        reportArt.putAttributes("isReleasable", Arrays.asList(CanRelease));
        TransferableArtifactsContainer container = new TransferableArtifactsContainer();
        ArrayList<TransferableArtifact> list = new ArrayList<TransferableArtifact>();
        list.add(reportArt);
        container.setArtifactList(list);
        String json1 = gson.toJson((Object)container);
        return json1;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="closeReleaseWeb")
    public String getAssociatedsCloseReleasesForProjectWeb(String projectGuid) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            String attribute = projectGuid;
            if (attribute != null) {
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                ResultSet<ArtifactReadable> mileStones = CommonUtil.getReleasesForProject(attribute);
                for (ArtifactReadable artifactReadable : mileStones) {
                    ResultSet relatedSprints = artifactReadable.getRelated(CoreRelationTypes.DefaultHierarchical_Child);
                    if (relatedSprints == null || relatedSprints.size() <= 0) continue;
                    for (ArtifactReadable artifactReadable2 : relatedSprints) {
                        ResultSet releasedAttribute = artifactReadable2.getAttributes((AttributeTypeToken)AtsAttributeTypes.Released);
                        if (releasedAttribute == null || releasedAttribute.size() <= 0) continue;
                        for (AttributeReadable attributeReadable : releasedAttribute) {
                            boolean releasedAttributeString = (Boolean)attributeReadable.getValue();
                            if (!releasedAttributeString) continue;
                            TransferableArtifact ar = new TransferableArtifact();
                            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable2, (ITransferableArtifact)ar);
                            String displayName = String.valueOf(artifactReadable.getName()) + "-->" + artifactReadable2.getName();
                            ar.putAttributes("displayName", Arrays.asList(displayName));
                            listTras.add(ar);
                        }
                    }
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(listTras);
                String json = gson.toJson((Object)container);
                return json;
            }
            return null;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="openReleaseWeb")
    public String getAssociatedOpenReleasesForProjectWeb(String projectGuid) {
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            String attribute = projectGuid;
            if (attribute != null) {
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                ResultSet<ArtifactReadable> mileStones = CommonUtil.getReleasesForProject(attribute);
                for (ArtifactReadable artifactReadable : mileStones) {
                    ResultSet relatedSprints = artifactReadable.getRelated(CoreRelationTypes.DefaultHierarchical_Child);
                    if (relatedSprints == null || relatedSprints.size() <= 0) continue;
                    for (ArtifactReadable artifactReadable2 : relatedSprints) {
                        ResultSet releasedAttribute = artifactReadable2.getAttributes((AttributeTypeToken)AtsAttributeTypes.Released);
                        if (releasedAttribute == null || releasedAttribute.size() <= 0) continue;
                        for (AttributeReadable attributeReadable : releasedAttribute) {
                            boolean releasedAttributeString = (Boolean)attributeReadable.getValue();
                            if (releasedAttributeString) continue;
                            TransferableArtifact ar = new TransferableArtifact();
                            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable2, (ITransferableArtifact)ar);
                            String displayName = String.valueOf(artifactReadable.getName()) + "-->" + artifactReadable2.getName();
                            ar.putAttributes("displayName", Arrays.asList(displayName));
                            listTras.add(ar);
                        }
                    }
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(listTras);
                String json = gson.toJson((Object)container);
                return json;
            }
            return null;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

