/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.mail.notifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.mail.notifier.ICTeamEmail;
import org.eclipse.osee.icteam.web.mail.notifier.ICTeamNotifyType;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.UserUtility;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ICTeamMailNotifier {
    public static final int TABLE_WIDTH = 95;
    private static ArtifactReadable artifact;
    private static List<ICTeamNotifyType> types;
    private static List<String> assignees;
    private static OrcsApi orcsApi;
    private static String artiafctLink;
    private static String update;
    private static TransferableArtifact parentArtifact;
    public static final String labelFont = "<font color=\"darkcyan\" face=\"Arial\" size=\"-1\">";
    public static final String normalColor = "#EEEEEE";
    private static final String activeColor = "#9CCCFF";
    private static final String fromAddresss = "ICTeam-Admin@icteam.com";

    public static void notify(OrcsApi orcs, ArtifactReadable awa, List<String> users, List<String> _mailIds, String updates, String link, ICTeamNotifyType ... notifyTypes) {
        update = updates;
        assignees = new ArrayList<String>(new HashSet<String>(users));
        orcsApi = orcs;
        artifact = awa;
        artiafctLink = link;
        ArrayList<String> mailIds = new ArrayList<String>(new HashSet<String>(_mailIds));
        try {
            ICTeamEmail emailMessage;
            types = Arrays.asList(notifyTypes);
            if (types.contains((Object)ICTeamNotifyType.Subscribed) && mailIds.size() > 0) {
                emailMessage = new ICTeamEmail(mailIds, fromAddresss, fromAddresss, ICTeamMailNotifier.getNotificationEmailSubject(), ICTeamMailNotifier.getBody(), ICTeamEmail.BodyType.Html);
                emailMessage.send();
            }
            if ((types.contains((Object)ICTeamNotifyType.Cancelled) || types.contains((Object)ICTeamNotifyType.Completed)) && mailIds.size() > 0) {
                emailMessage = new ICTeamEmail(mailIds, fromAddresss, fromAddresss, ICTeamMailNotifier.getNotificationEmailSubject(), ICTeamMailNotifier.getBody(), ICTeamEmail.BodyType.Html);
                emailMessage.send();
            }
            if (types.contains((Object)ICTeamNotifyType.Updated) && mailIds.size() > 0) {
                emailMessage = new ICTeamEmail(mailIds, fromAddresss, fromAddresss, ICTeamMailNotifier.getNotificationEmailSubject(), ICTeamMailNotifier.getBody(), ICTeamEmail.BodyType.Html);
                emailMessage.send();
            }
            if (types.contains((Object)ICTeamNotifyType.Created) && mailIds.size() > 0) {
                emailMessage = new ICTeamEmail(mailIds, fromAddresss, fromAddresss, ICTeamMailNotifier.getNotificationEmailSubject(), ICTeamMailNotifier.getBody(), ICTeamEmail.BodyType.Html);
                emailMessage.send();
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
    }

    private static String getBody() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(AHTML.newline());
            buffer.append(AHTML.simplePage((String)"---------------------------------------------------------------"));
            buffer.append(AHTML.newline());
            if (types.contains((Object)ICTeamNotifyType.Originator)) {
                buffer.append(AHTML.simplePage((String)"Status : Created"));
            } else if (types.contains((Object)ICTeamNotifyType.Assigned)) {
                buffer.append(AHTML.simplePage((String)"Status : Assigned"));
            } else if (types.contains((Object)ICTeamNotifyType.Subscribed)) {
                buffer.append(AHTML.simplePage((String)"Status : Subscribed"));
            } else if (types.contains((Object)ICTeamNotifyType.Completed) && types.contains((Object)ICTeamNotifyType.predecessor)) {
                buffer.append(AHTML.simplePage((String)"Status : Predecessor Task Completed"));
            } else if (types.contains((Object)ICTeamNotifyType.Cancelled) && types.contains((Object)ICTeamNotifyType.predecessor)) {
                buffer.append(AHTML.simplePage((String)"Status : Predecessor Task Cancelled"));
            } else if (types.contains((Object)ICTeamNotifyType.Cancelled)) {
                buffer.append(AHTML.simplePage((String)"Status : Cancelled"));
            } else if (types.contains((Object)ICTeamNotifyType.Completed)) {
                buffer.append(AHTML.simplePage((String)"Status : Completed"));
            } else if (types.contains((Object)ICTeamNotifyType.Peer_Reviewers_Completed)) {
                buffer.append(AHTML.simplePage((String)"Status : Review Completed"));
            } else if (types.contains((Object)ICTeamNotifyType.Updated) && !types.contains((Object)ICTeamNotifyType.predecessor)) {
                buffer.append(AHTML.simplePage((String)"Status : Updated"));
            } else if (types.contains((Object)ICTeamNotifyType.Created)) {
                buffer.append(AHTML.simplePage((String)"Status : Created"));
            }
            if (update != null && !update.isEmpty()) {
                buffer.append(AHTML.newline());
                if (artifact.getArtifactType().getName().equals("Team Workflow")) {
                    buffer.append(AHTML.italics((String)update));
                }
                if (artifact.getArtifactType().getName().equals("Task")) {
                    buffer.append(AHTML.italics((String)update));
                }
                buffer.append(AHTML.newline());
            }
            if (types.contains((Object)ICTeamNotifyType.predecessor)) {
                buffer.append(AHTML.newline());
                buffer.append(AHTML.newline());
                buffer.append(AHTML.newline());
            }
            buffer.append(AHTML.newline());
            buffer.append(AHTML.simplePage((String)"---------------------------------------------------------------"));
            buffer.append(AHTML.newline());
            if (artifact.getArtifactType().getName().equals("Team Workflow")) {
                ResultSet relatedProjects = artifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project);
                if (relatedProjects.size() > 0) {
                    for (ArtifactReadable project : relatedProjects) {
                    }
                }
                buffer.append(ICTeamMailNotifier.getContentForProject());
            }
            if (artiafctLink != null) {
                buffer.append(AHTML.newline());
                try {
                    buffer.append("Link: ");
                    buffer.append(AHTML.newline());
                    artiafctLink = artiafctLink.replaceAll(" ", "%20");
                    buffer.append(AHTML.simplePage((String)artiafctLink));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                buffer.append(AHTML.newline());
            }
            buffer.append(AHTML.simplePage((String)"---------------------------------------------------------------"));
            buffer.append(AHTML.newline());
            buffer.append(AHTML.newline());
            buffer.append(AHTML.italics((String)"This is automatically generated message."));
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static StringBuffer getContentForProject() {
        StringBuffer buffer = new StringBuffer();
        ArtifactReadable projectArtifact = (ArtifactReadable)artifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne();
        String shortName = ((AttributeReadable)projectArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
        String workPackageId = ((AttributeReadable)artifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
        String taskId = String.valueOf(shortName) + "-" + workPackageId;
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Task ID:" + taskId)));
        String actionableItemId = artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.ActionableItem);
        ArtifactReadable componentArt = ICTeamMailNotifier.getActionalBleItemsByGuid(actionableItemId);
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Packages:          " + componentArt.getName())));
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("CreatedBy:          " + ICTeamMailNotifier.getUserNameByUserId(artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CreatedBy)))));
        if (assignees.isEmpty()) {
            List<ITransferableArtifact> assignees2 = CommonUtil.getAssignees(artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentState));
            ArrayList<String> userList = new ArrayList<String>();
            for (ITransferableArtifact transferableArtifact : assignees2) {
                userList.add((String)transferableArtifact.getAttributes(CoreAttributeTypes.UserId.toString()).get(0));
            }
            assignees.addAll(userList);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String assignee : assignees) {
            stringBuffer.append(ICTeamMailNotifier.getUserNameByUserId(assignee));
            stringBuffer.append(", ");
        }
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Assignee:          " + stringBuffer.toString())));
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Status:          " + artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentState).substring(0, artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentState).indexOf(";")))));
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Request Type:          " + artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.ChangeType))));
        String teamDefId = artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.TeamDefinition);
        ArtifactReadable teamArt = ICTeamMailNotifier.getTeamDefinitionByGuid(teamDefId);
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Team:          " + teamArt.getName())));
        buffer.append(String.valueOf(AHTML.addSpace((int)5)) + AHTML.simplePage((String)("Description:          " + artifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Description))));
        return buffer;
    }

    private static ArtifactReadable getTeamDefinitionByGuid(String teamDefId) {
        ResultSet list = null;
        try {
            list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andUuid(Long.valueOf(teamDefId).longValue()).getResults();
            return (ArtifactReadable)list.getExactlyOne();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ArtifactReadable getActionalBleItemsByGuid(String actionableItemId) {
        ResultSet list = null;
        try {
            list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andUuid(Long.valueOf(actionableItemId).longValue()).getResults();
            return (ArtifactReadable)list.getExactlyOne();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createTable(List<String> datas, String[] headers, int numColumns, int cellPadding, int border, StringBuffer table) {
        if (datas == null) {
            throw new IllegalArgumentException("The data can not be null");
        }
        if (datas.size() % numColumns != 0) {
            throw new IllegalArgumentException("The table could not be created becuase the data does not match the column size");
        }
        if (border > 0) {
            table.append("border=\"" + border + "\"");
        }
        if (cellPadding > 0) {
            table.append("cellpadding=\"" + cellPadding + "\"");
        }
        table.append(">");
        if (headers != null && headers.length == numColumns) {
            table.append("<tr>");
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                table.append("<th>" + header + "</th>");
                ++n2;
            }
            table.append("</tr>");
        }
        int colIndex = 0;
        for (String data : datas) {
            if (colIndex == 0) {
                table.append("<tr>");
            }
            table.append("<td>" + data + "</td>");
            if (++colIndex != numColumns) continue;
            table.append("</tr>");
            colIndex = 0;
        }
        return table.toString();
    }

    public static String getLabel(String label) {
        return AHTML.getLabelStr((String)labelFont, (String)(String.valueOf(label) + ": "));
    }

    public static void endBorderTable(StringBuffer buffer) {
        buffer.append(AHTML.endBorderTable());
    }

    public static void startBorderTable(boolean active, String caption, StringBuffer buffer) {
        buffer.append(ICTeamMailNotifier.startBorderTable(95, active ? activeColor : normalColor, caption));
    }

    public static String startBorderTable(int width, String bgcolor, String caption) {
        String capStr = "";
        if (!caption.equals("")) {
            capStr = "<caption ALIGN=top>" + caption + "</caption>";
        }
        return "<table border=\"1\" align=\"left\" bgcolor=\"" + bgcolor + "\" cellpadding=\"3\" cellspacing=\"0\" width=\"" + width + "%\">" + capStr;
    }

    public static String endBorderTable() {
        return "</td></tr></table>";
    }

    public static String addHeaderRowMultiColumnTable(String[] str, Integer[] width) {
        StringBuilder s = new StringBuilder("<tr>");
        String widthStr = "";
        int i = 0;
        while (i < str.length) {
            if (width != null) {
                widthStr = " width =\"" + width[i] + "\"";
            }
            String s1234 = " align=\"left\"";
            s.append("<th");
            s.append(widthStr);
            s.append(s1234);
            s.append(">");
            s.append(str[i]);
            s.append("</th>");
            ++i;
        }
        s.append("</tr>");
        return s.toString();
    }

    private static String getNotificationEmailSubject() {
        String buffer = "";
        if (types.contains((Object)ICTeamNotifyType.Originator)) {
            buffer = "ICTeam Notification : Created - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Assigned)) {
            buffer = "ICTeam Notification : Updated - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Subscribed)) {
            buffer = "ICTeam Notification : Subscribed - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Completed) && types.contains((Object)ICTeamNotifyType.predecessor)) {
            buffer = "ICTeam Notification : Predecessor Task Completed - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Cancelled) && types.contains((Object)ICTeamNotifyType.predecessor)) {
            buffer = "ICTeam Notification : Predecessor Task Cancelled - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Cancelled)) {
            buffer = "ICTeam Notification : Cancelled - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Completed)) {
            buffer = "ICTeam Notification : Completed - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Peer_Reviewers_Completed)) {
            buffer = "ICTeam Notification : Review Completed - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Updated) && !types.contains((Object)ICTeamNotifyType.predecessor)) {
            buffer = "ICTeam Notification : Updated - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.Created)) {
            buffer = "ICTeam Notification : Created - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.UserCreated)) {
            buffer = "ICTeam Notification : User Created - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.AdminUserCreated)) {
            buffer = "ICTeam Notification : Admin User Created - " + artifact.getName();
        } else if (types.contains((Object)ICTeamNotifyType.PasswordChangeRequest)) {
            buffer = "ICTeam Notification : Password Modification Request Created - " + artifact.getName();
        }
        return buffer.toString();
    }

    public static String getUserNameByUserId(String userId) {
        if (!"".equals(userId.trim())) {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable artifactReadable = UserUtility.getUserById(orcsApi, userId);
            TransferableArtifact tr = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)tr);
            return tr.getName();
        }
        return "";
    }

    public static void notify(OrcsApi orcsApi2, ArtifactReadable readableArtifact, String currentLoggedInUser, String mailId, String changes, String rapLink, ICTeamNotifyType type) {
        types = Arrays.asList(type);
        assignees = new ArrayList<String>();
        assignees.add(mailId);
        orcsApi = orcsApi2;
        artifact = readableArtifact;
        artiafctLink = rapLink;
        String senderMailId = ICTeamMailNotifier.getMailIdByType(orcsApi2, currentLoggedInUser);
        if (assignees.size() > 0) {
            ICTeamEmail emailMessage = new ICTeamEmail(assignees, senderMailId, fromAddresss, ICTeamMailNotifier.getNotificationEmailSubject(), ICTeamMailNotifier.getUserMailBody(), ICTeamEmail.BodyType.Html);
            emailMessage.send();
        }
    }

    private static String getMailIdByType(OrcsApi orcsApi2, String currentLoggedInUser) {
        String buffer = "";
        if (types.contains((Object)ICTeamNotifyType.UserCreated) || types.contains((Object)ICTeamNotifyType.AdminUserCreated)) {
            buffer = ICTeamMailNotifier.getMailIdByUserId(orcsApi2, currentLoggedInUser);
        } else if (types.contains((Object)ICTeamNotifyType.PasswordChangeRequest)) {
            buffer = currentLoggedInUser;
        }
        return buffer.toString();
    }

    private static String getUserMailBody() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(AHTML.newline());
            buffer.append(AHTML.simplePage((String)"---------------------------------------------------------------"));
            buffer.append(AHTML.newline());
            buffer.append(ICTeamMailNotifier.getBodyMessage());
            buffer.append(AHTML.newline());
            if (artiafctLink != null) {
                buffer.append(AHTML.newline());
                try {
                    buffer.append("Link: ");
                    buffer.append(AHTML.newline());
                    artiafctLink = artiafctLink.replaceAll(" ", "%20");
                    buffer.append(AHTML.simplePage((String)artiafctLink));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                buffer.append(AHTML.newline());
            }
            buffer.append(AHTML.simplePage((String)"---------------------------------------------------------------"));
            buffer.append(AHTML.newline());
            buffer.append(AHTML.newline());
            buffer.append(AHTML.italics((String)"This is automatically generated message."));
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private static String getMailIdByUserId(OrcsApi orcsApi, String userId) {
        try {
            ArtifactReadable artifactReadable = UserUtility.getUserById(orcsApi, userId);
            ResultSet attrList = artifactReadable.getAttributes();
            for (AttributeReadable attributeReadable : attrList) {
                if (!attributeReadable.getValue().toString().contains("@")) continue;
                return attributeReadable.getValue().toString();
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getBodyMessage() {
        String buffer = "";
        if (types.contains((Object)ICTeamNotifyType.UserCreated)) {
            buffer = "Please use the below link to activate the user.";
        } else if (types.contains((Object)ICTeamNotifyType.AdminUserCreated)) {
            buffer = "Please use the below link to activate the admin user.";
        } else if (types.contains((Object)ICTeamNotifyType.PasswordChangeRequest)) {
            buffer = "Please use the below link to change the password.";
        }
        return buffer.toString();
    }
}

