/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;

public class BlockApplicabilityRule
extends Rule {
    private final BlockApplicabilityOps orcsApplicability;
    private final Map<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap;
    private final Stack<ApplicabilityBlock> applicBlocks = new Stack();

    public BlockApplicabilityRule(BlockApplicabilityOps orcsApplicability, Map<String, FileTypeApplicabilityData> fileTypeApplicabilityData) {
        super(null);
        this.orcsApplicability = orcsApplicability;
        this.fileTypeApplicabilityDataMap = fileTypeApplicabilityData;
    }

    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        FileTypeApplicabilityData fileTypeApplicabilityData = this.fileTypeApplicabilityDataMap.get(Lib.getExtension((String)this.getInputFile().getName()));
        Matcher matcher = fileTypeApplicabilityData.getCommentedTagPattern().matcher(seq);
        int matcherIndex = 0;
        while (matcherIndex < seq.length() && matcher.find(matcherIndex)) {
            String beginFeature = matcher.group(1);
            String endFeature = matcher.group(6);
            if (beginFeature != null) {
                matcherIndex = this.startApplicabilityBlock(beginFeature, matcher, fileTypeApplicabilityData);
                continue;
            }
            if (endFeature != null) {
                matcherIndex = this.finishApplicabilityBlock(changeSet, matcher);
                this.ruleWasApplicable = true;
                continue;
            }
            throw new OseeCoreException("Did not find a start or end feature tag", new Object[0]);
        }
        return changeSet;
    }

    private int startApplicabilityBlock(String beginFeature, Matcher matcher, FileTypeApplicabilityData fileTypeApplicabilityData) {
        ApplicabilityBlock applicStart = new ApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Feature);
        applicStart.setFileTypeApplicabilityData(fileTypeApplicabilityData);
        applicStart.setApplicabilityExpression(matcher.group(2));
        applicStart.setStartInsertIndex(matcher.start());
        applicStart.setStartTextIndex(matcher.end());
        applicStart.setBeginTag(beginFeature);
        this.applicBlocks.add(applicStart);
        return matcher.end();
    }

    private int finishApplicabilityBlock(ChangeSet changeSet, Matcher matcher) {
        if (this.applicBlocks.isEmpty()) {
            throw new OseeCoreException("An End Feature tag was found before a beginning Feature tag", new Object[0]);
        }
        ApplicabilityBlock applicBlock = this.applicBlocks.pop();
        applicBlock.setEndTextIndex(matcher.start());
        applicBlock.setEndInsertIndex(matcher.end());
        applicBlock.setInsideText(changeSet.subSequence(applicBlock.getStartTextIndex(), applicBlock.getEndTextIndex()).toString());
        String replacementText = this.orcsApplicability.evaluateApplicabilityExpression(applicBlock);
        changeSet.replace(applicBlock.getStartInsertIndex(), applicBlock.getEndInsertIndex(), replacementText);
        return matcher.end();
    }
}

