/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Arrays;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.core.internal.applicability.DemoFeatures;
import org.eclipse.osee.orcs.core.util.Artifacts;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateDemoBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final OrcsApplicability ops;
    private final OrcsBranch branchOps;

    public CreateDemoBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.ops = orcsApi.getApplicabilityOps();
        this.branchOps = orcsApi.getBranchOps();
    }

    public void populate() {
        UserToken account = DemoUsers.Joe_Smith;
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Create Demo Users");
        this.orcsApi.getAdminOps().createUsers(tx, (Iterable)DemoUsers.values());
        tx.commit();
        this.createDemoProgramBranch(DemoBranches.SAW_Bld_1, (UserId)account);
        this.createDemoProgramBranch(DemoBranches.CIS_Bld_1, (UserId)account);
        this.branchOps.createBaselineBranch(DemoBranches.SAW_PL, (ArtifactId)DemoUsers.Joe_Smith, DemoBranches.SAW_Bld_1, ArtifactId.SENTINEL);
        Branch hardeningBranch = this.branchOps.createBaselineBranch(DemoBranches.SAW_PL_Hardening_Branch, (ArtifactId)DemoUsers.Joe_Smith, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
        this.orcsApi.getAccessControlService().removePermissions((BranchId)hardeningBranch);
        this.createProductLineConfig((BranchId)DemoBranches.SAW_PL, (UserId)account);
        this.branchOps.createWorkingBranch(DemoBranches.SAW_PL_Working_Branch, (ArtifactId)DemoUsers.Joe_Smith, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
    }

    private void createProductLineConfig(BranchId branch, UserId account) {
        TransactionBuilder tx = this.txFactory.createTransaction(branch, (UserId)SystemUser.OseeSystem, "Create Product Line folders");
        ArtifactToken plFolder = Artifacts.getOrCreate(CoreArtifactTokens.ProductLineFolder, (ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, tx, this.orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.ProductsFolder, (ArtifactId)plFolder, tx, this.orcsApi);
        ArtifactToken featuresFolder = Artifacts.getOrCreate(CoreArtifactTokens.FeaturesFolder, (ArtifactId)plFolder, tx, this.orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.PlCfgGroupsFolder, (ArtifactId)plFolder, tx, this.orcsApi);
        ArtifactToken productA = tx.createView(branch, "Product A");
        ArtifactToken productB = tx.createView(branch, "Product B");
        ArtifactToken productC = tx.createView(branch, "Product C");
        ArtifactToken productD = tx.createView(branch, "Product D");
        ArtifactToken[] products = new ArtifactToken[]{productA, productB, productC, productD};
        this.createFeatureConfigs((ArtifactId)featuresFolder, tx);
        this.configureFeature(tx, DemoFeatures.ROBOT_ARM_LIGHT.name(), (ArtifactId[])products, "Excluded", "Included", "Excluded", "Excluded");
        this.configureFeature(tx, DemoFeatures.ENGINE_5.name(), (ArtifactId[])products, "A2543", "A2543", "A2543", "B5543");
        this.configureFeature(tx, DemoFeatures.JHU_CONTROLLER.name(), (ArtifactId[])products, "Excluded", "Included", "Included", "Excluded");
        this.configureFeature(tx, DemoFeatures.ROBOT_SPEAKER.name(), (ArtifactId[])products, "SPKR_A", "SPKR_A", "SPKR_B", "SPKR_B");
        this.createLegacyFeatureConfig((ArtifactId)featuresFolder, tx);
        tx.commit();
        ConfigurationGroupDefinition group = new ConfigurationGroupDefinition();
        group.setName("abGroup");
        this.orcsApi.getApplicabilityOps().createCfgGroup(group, branch, account);
        this.orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product A", branch, account);
        this.orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product B", branch, account);
        this.orcsApi.getApplicabilityOps().syncConfigGroup(branch, account);
    }

    private void createFeatureConfigs(ArtifactId folder, TransactionBuilder tx) {
        XResultData results = new XResultData();
        FeatureDefinition def1 = new FeatureDefinition(Lib.generateArtifactIdAsInt(), DemoFeatures.ROBOT_ARM_LIGHT.name(), "String", Arrays.asList("Included", "Excluded"), "Included", false, "A significant capability", Arrays.asList("Test"));
        this.ops.createUpdateFeatureDefinition(def1, "add", tx, results);
        FeatureDefinition def2 = new FeatureDefinition(Lib.generateArtifactIdAsInt(), DemoFeatures.ENGINE_5.name(), "String", Arrays.asList("A2543", "B5543"), "A2543", false, "Used select type of engine", Arrays.asList("Test"));
        this.ops.createUpdateFeatureDefinition(def2, "add", tx, results);
        FeatureDefinition def3 = new FeatureDefinition(Lib.generateArtifactIdAsInt(), DemoFeatures.JHU_CONTROLLER.name(), "String", Arrays.asList("Included", "Excluded"), "Included", false, "A small point of variation", null);
        this.ops.createUpdateFeatureDefinition(def3, "add", tx, results);
        FeatureDefinition def4 = new FeatureDefinition(Lib.generateArtifactIdAsInt(), DemoFeatures.ROBOT_SPEAKER.name(), "String", Arrays.asList("SPKR_A", "SPKR_B", "SPKR_C"), "SPKR_A", true, "This feature is multi-select.", null);
        this.ops.createUpdateFeatureDefinition(def4, "add", tx, results);
        this.orcsApi.getApplicabilityOps();
        Conditions.assertFalse((boolean)results.isErrors(), (String)results.toString(), (Object[])new Object[0]);
    }

    private void createLegacyFeatureConfig(ArtifactId folder, TransactionBuilder tx) {
        ArtifactToken featureDefinition = tx.createArtifact(folder, CoreArtifactTypes.FeatureDefinition, "Feature Definition_SAW_Bld_1");
        String featureDefJson = "[{\"name\": \"" + DemoFeatures.ROBOT_ARM_LIGHT.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Included\"," + "\"description\": \"Test It\"" + "}, {" + "\"name\": \"" + DemoFeatures.ENGINE_5.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"A2543\", \"B5543\"]," + "\"defaultValue\": \"A2543\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.JHU_CONTROLLER.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Excluded\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.ROBOT_SPEAKER.name() + "\"," + "\"type\": \"multiple\"," + "\"values\": [\"SPKR_A\", \"SPKR_B\", \"SPKR_C\"]," + "\"defaultValue\": \"SPKR_A\"," + "\"description\": \"Test It\"" + "}" + "]";
        tx.createAttribute((ArtifactId)featureDefinition, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)featureDefJson);
    }

    private void configureFeature(TransactionBuilder tx, String featureName, ArtifactId[] products, String ... featureValues) {
        int i = 0;
        while (i < products.length) {
            tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)products[i], (Object)(String.valueOf(featureName) + " = " + featureValues[i]));
            ++i;
        }
    }

    private void createDemoProgramBranch(BranchToken branch, UserId account) {
        this.branchOps.createProgramBranch(branch, account);
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)branch, account, "Create SAW Product Decomposition");
        ArtifactToken sawProduct = tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTypes.Component, "SAW Product Decomposition");
        for (String subsystem : DemoSubsystems.getSubsystems()) {
            tx.createArtifact((ArtifactId)sawProduct, CoreArtifactTypes.Component, subsystem);
        }
        tx.commit();
    }
}

