/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.security;

public enum OAuthTokenType {
    UNKNOW_TOKEN("unknown", -1),
    BEARER_TOKEN("bearer", 0),
    REFRESH_TOKEN("refresh", 1),
    HAWK_TOKEN("hawk", 2);

    private final String tokenType;
    private final int value;

    private OAuthTokenType(String tokenType, int value) {
        this.tokenType = tokenType;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getType() {
        return this.tokenType;
    }

    public static OAuthTokenType fromValue(int value) {
        OAuthTokenType toReturn = UNKNOW_TOKEN;
        OAuthTokenType[] oAuthTokenTypeArray = OAuthTokenType.values();
        int n = oAuthTokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OAuthTokenType tokenType = oAuthTokenTypeArray[n2];
            if (tokenType.getValue() == value) {
                toReturn = tokenType;
                break;
            }
            ++n2;
        }
        return toReturn;
    }

    public static OAuthTokenType fromType(String tokenType) {
        OAuthTokenType toReturn = UNKNOW_TOKEN;
        OAuthTokenType[] oAuthTokenTypeArray = OAuthTokenType.values();
        int n = oAuthTokenTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OAuthTokenType type = oAuthTokenTypeArray[n2];
            if (type.getType().equals(tokenType)) {
                toReturn = type;
                break;
            }
            ++n2;
        }
        return toReturn;
    }
}

