/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OOBResponseDeliverer;
import org.apache.cxf.rs.security.oauth2.services.AuthorizationCodeGrantService;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientLogoUriResolver;

public class AuthorizationCodeEndpoint
extends AuthorizationCodeGrantService {
    private boolean canSupportPublicClients;
    private OOBResponseDeliverer oobDeliverer;
    private final ClientLogoUriResolver clientLogoUriResolver;

    public AuthorizationCodeEndpoint(ClientLogoUriResolver clientLogoUriResolver) {
        this.clientLogoUriResolver = clientLogoUriResolver;
    }

    protected Response deliverOOBResponse(OOBAuthorizationResponse response) {
        if (this.oobDeliverer != null) {
            return this.oobDeliverer.deliver(response);
        }
        return Response.ok((Object)response).build();
    }

    protected boolean canSupportPublicClient(Client c) {
        return this.canSupportPublicClients;
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public void setOobDeliverer(OOBResponseDeliverer oobDeliverer) {
        this.oobDeliverer = oobDeliverer;
    }

    protected OAuthAuthorizationData createAuthorizationData(Client client, MultivaluedMap<String, String> params, UserSubject subject, String redirectUri, List<OAuthPermission> perms) {
        OAuthAuthorizationData secData = super.createAuthorizationData(client, params, subject, redirectUri, perms);
        secData.setApplicationName(client.getApplicationName());
        secData.setApplicationCertificates(client.getApplicationCertificates());
        UriInfo uriInfo = this.getMessageContext().getUriInfo();
        URI clientLogoUri = this.clientLogoUriResolver.getClientLogoUri(uriInfo, client);
        String applicationLogoUri = clientLogoUri.toASCIIString();
        secData.setApplicationLogoUri(applicationLogoUri);
        return secData;
    }
}

