/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider;

import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.SubjectProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.AccessToken;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.AuthorizationCode;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.OAuthEncryption;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.RefreshOAuthToken;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuthStorage;
import org.eclipse.osee.jaxrs.server.security.OAuthCodeGrant;
import org.eclipse.osee.jaxrs.server.security.OAuthToken;
import org.eclipse.osee.jaxrs.server.security.OAuthTokenType;
import org.eclipse.osee.jaxrs.server.session.SessionData;

public class OAuth2DataProvider
implements AuthorizationCodeDataProvider {
    private final OAuthEncryption serializer;
    private final JaxRsOAuthStorage storage;
    private final ClientProvider clientProvider;
    private final SubjectProvider subjectProvider;
    private boolean isRefreshTokenAllowed;
    private long accessTokenExpiration;
    private long refreshTokenExpiration;
    private long codeGrantExpiration;
    private String secretKeyEncoded;
    private String secretKeyAlgorithm;
    private volatile SecretKey secretKey;

    public OAuth2DataProvider(ClientProvider clientProvider, SubjectProvider subjectProvider, OAuthEncryption serializer, JaxRsOAuthStorage storage) {
        this.clientProvider = clientProvider;
        this.subjectProvider = subjectProvider;
        this.serializer = serializer;
        this.storage = storage;
    }

    public void setSecretKeyEncoded(String secretKeyEncoded) {
        this.secretKeyEncoded = secretKeyEncoded;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public void setRefreshTokenAllowed(boolean isRefreshTokenAllowed) {
        this.isRefreshTokenAllowed = isRefreshTokenAllowed;
    }

    public void setAccessTokenExpiration(long accessTokenExpiration) {
        this.accessTokenExpiration = accessTokenExpiration;
    }

    public void setRefreshTokenExpiration(long refreshTokenExpiration) {
        this.refreshTokenExpiration = refreshTokenExpiration;
    }

    public void setCodeGrantExpiration(long codeGrantExpiration) {
        this.codeGrantExpiration = codeGrantExpiration;
    }

    public boolean isRefreshTokenAllowed() {
        return this.isRefreshTokenAllowed;
    }

    public long getAccessTokenExpiration() {
        return this.accessTokenExpiration;
    }

    public long getRefreshTokenExpiration() {
        return this.refreshTokenExpiration;
    }

    public long getCodeGrantExpiration() {
        return this.codeGrantExpiration;
    }

    private SecretKey getSecretKey() {
        if (this.secretKey == null) {
            this.secretKey = this.serializer.decodeSecretKey(this.secretKeyEncoded, this.secretKeyAlgorithm);
        }
        return this.secretKey;
    }

    private long getClientId(Client client) {
        return this.clientProvider.getClientId(client);
    }

    private long getSubjectId(UserSubject subject) {
        return this.subjectProvider.getSubjectId(subject);
    }

    public Client getClient(String clientId) {
        Client client = this.clientProvider.getClient(clientId);
        if (client == null) {
            OAuthError error = new OAuthError("invalid_client", "Client Id not found.");
            throw new OAuthServiceException(error);
        }
        return client;
    }

    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) {
        long expiresIn = this.getCodeGrantExpiration();
        long uuid = Lib.generateUuid();
        long clientId = this.getClientId(reg.getClient());
        long subjectId = this.getSubjectId(reg.getSubject());
        AuthorizationCode grant = new AuthorizationCode(uuid, clientId, subjectId);
        grant.setCode(OAuthUtils.generateRandomTokenKey());
        grant.setIssuedAt(OAuthUtils.getIssuedAt());
        grant.setExpiresIn(expiresIn);
        grant.setClient(reg.getClient());
        grant.setSubject(reg.getSubject());
        grant.setAudience(reg.getAudience());
        grant.setRedirectUri(reg.getRedirectUri());
        grant.setClientCodeVerifier(reg.getClientCodeVerifier());
        grant.setApprovedScopes(this.getApprovedScopes(reg.getRequestedScope(), reg.getApprovedScope()));
        grant.setClientCodeVerifier(reg.getClientCodeVerifier());
        String encrypted = this.serializer.encryptCodeGrant(grant, this.getSecretKey());
        grant.setCode(encrypted);
        this.storage.storeCodeGrant(grant);
        return grant;
    }

    public ServerAuthorizationCodeGrant removeCodeGrant(String code) {
        OAuthCodeGrant codeGrant = this.storage.getCodeGrant(code);
        ServerAuthorizationCodeGrant toReturn = null;
        if (codeGrant != null) {
            String encryptedCode = codeGrant.getCode();
            toReturn = this.serializer.decryptCodeGrant((OAuthDataProvider)this, encryptedCode, this.getSecretKey());
            this.storage.removeCodeGrant(codeGrant);
        }
        return toReturn;
    }

    public ServerAccessToken createAccessToken(AccessTokenRegistration reg) {
        Client client = reg.getClient();
        List<String> approvedScopes = this.getApprovedScopes(reg.getRequestedScope(), reg.getApprovedScope());
        List<OAuthPermission> permissions = this.convertScopeToPermissions(client, approvedScopes);
        long uuid = Lib.generateUuid();
        long clientId = this.getClientId(reg.getClient());
        long subjectId = this.getSubjectId(reg.getSubject());
        OAuthTokenType type = OAuthTokenType.BEARER_TOKEN;
        AccessToken accessToken = new AccessToken(uuid, clientId, subjectId, type);
        accessToken.setTokenKey(OAuthUtils.generateRandomTokenKey());
        accessToken.setIssuedAt(OAuthUtils.getIssuedAt());
        accessToken.setExpiresIn(this.getAccessTokenExpiration());
        accessToken.setClient(client);
        accessToken.setSubject(reg.getSubject());
        accessToken.setTokenType(type.getType());
        accessToken.setAudience(reg.getAudience());
        accessToken.setGrantType(reg.getGrantType());
        accessToken.setScopes(permissions);
        RefreshOAuthToken refreshToken = null;
        if (this.isRefreshTokenAllowed()) {
            refreshToken = this.newRefreshToken(accessToken, clientId, subjectId, this.getSecretKey());
            accessToken.setRefreshToken(refreshToken.getTokenKey());
        }
        String encryptedAccessToken = this.serializer.encryptAccessToken(accessToken, this.getSecretKey());
        accessToken.setTokenKey(encryptedAccessToken);
        if (refreshToken != null) {
            this.storage.storeToken(accessToken, refreshToken);
            this.storage.relateTokens(refreshToken, accessToken);
        } else {
            this.storage.storeToken(accessToken);
        }
        return accessToken;
    }

    public String createSessionToken(SessionData session) {
        return this.serializer.encryptSessionToken(session, this.getSecretKey());
    }

    public ServerAccessToken getAccessToken(String accessToken) {
        return this.serializer.decryptAccessToken((OAuthDataProvider)this, accessToken, this.getSecretKey());
    }

    public ServerAccessToken refreshAccessToken(Client client, String refreshToken, List<String> requestedScopes) {
        if (!this.isRefreshTokenAllowed()) {
            OAuthError error = new OAuthError("invalid_request", "Refresh tokens are not allowed.");
            throw new OAuthServiceException(error);
        }
        SecretKey secretKey = this.getSecretKey();
        RefreshToken oldRefreshToken = this.serializer.decryptRefreshToken((OAuthDataProvider)this, refreshToken, secretKey);
        Iterable<OAuthToken> tokens = this.storage.getAccessTokensByRefreshToken(refreshToken);
        this.storage.removeToken(tokens);
        this.storage.removeTokenByKey(refreshToken);
        long uuid = Lib.generateUuid();
        long clientId = this.getClientId(oldRefreshToken.getClient());
        long subjectId = this.getSubjectId(oldRefreshToken.getSubject());
        OAuthTokenType type = OAuthTokenType.BEARER_TOKEN;
        AccessToken newAccessToken = new AccessToken(uuid, clientId, subjectId, type);
        newAccessToken.setTokenKey(OAuthUtils.generateRandomTokenKey());
        newAccessToken.setIssuedAt(OAuthUtils.getIssuedAt());
        newAccessToken.setExpiresIn(this.getAccessTokenExpiration());
        newAccessToken.setClient(oldRefreshToken.getClient());
        newAccessToken.setSubject(oldRefreshToken.getSubject());
        newAccessToken.setTokenType(type.getType());
        newAccessToken.setAudience(oldRefreshToken.getAudience());
        newAccessToken.setGrantType(oldRefreshToken.getGrantType());
        newAccessToken.setScopes(oldRefreshToken.getScopes());
        RefreshOAuthToken newRefreshToken = this.newRefreshToken(newAccessToken, clientId, subjectId, this.getSecretKey());
        newAccessToken.setRefreshToken(newRefreshToken.getTokenKey());
        String newEncryptedAccessToken = this.serializer.encryptAccessToken(newAccessToken, secretKey);
        newAccessToken.setTokenKey(newEncryptedAccessToken);
        this.storage.storeToken(newAccessToken, newRefreshToken);
        this.storage.relateTokens(newRefreshToken, newAccessToken);
        return newAccessToken;
    }

    private RefreshOAuthToken newRefreshToken(AccessToken token, long clientId, long subjectId, SecretKey secretKey) {
        long refreshUuid = Lib.generateUuid();
        RefreshOAuthToken toReturn = new RefreshOAuthToken(refreshUuid, clientId, subjectId);
        toReturn.setTokenKey(OAuthUtils.generateRandomTokenKey());
        toReturn.setIssuedAt(OAuthUtils.getIssuedAt());
        toReturn.setExpiresIn(this.getRefreshTokenExpiration());
        toReturn.setClient(token.getClient());
        toReturn.setSubject(token.getSubject());
        toReturn.setAudience(token.getAudience());
        toReturn.setGrantType(token.getGrantType());
        toReturn.setScopes(token.getScopes());
        String encryptedRefreshToken = this.serializer.encryptRefreshToken(toReturn, secretKey);
        toReturn.setTokenKey(encryptedRefreshToken);
        return toReturn;
    }

    public void removeAccessToken(ServerAccessToken accessToken) {
        this.storage.removeTokenByKey(accessToken.getTokenKey());
    }

    public void revokeToken(Client client, String tokenKey, String tokenTypeHint) {
        Iterable<OAuthToken> tokens = this.storage.getAccessTokensByRefreshToken(tokenKey);
        this.storage.removeToken(tokens);
        this.storage.removeTokenByKey(tokenKey);
    }

    public ServerAccessToken getPreauthorizedToken(Client client, List<String> requestedScopes, UserSubject subject, String grantType) {
        boolean isRolesOutdated;
        long clientId = this.getClientId(client);
        long subjectId = this.getSubjectId(subject);
        OAuthToken accessToken = this.storage.getPreauthorizedToken(clientId, subjectId, grantType);
        ServerAccessToken token = null;
        boolean isExpired = false;
        if (accessToken != null) {
            isExpired = OAuthUtils.isExpired((Long)accessToken.getIssuedAt(), (Long)accessToken.getExpiresIn());
            if (isExpired) {
                this.revokeToken(client, accessToken.getTokenKey(), accessToken.getTokenType());
            } else {
                token = this.getTokenHelper(client, grantType, accessToken, token);
            }
        }
        if (token != null && (isRolesOutdated = this.isRolesOutdated(subject, token))) {
            this.revokeAllTokens(client, subjectId, grantType);
            token = null;
        }
        return token;
    }

    private ServerAccessToken getTokenHelper(Client client, String grantType, OAuthToken accessToken, ServerAccessToken token) {
        block0 : switch (accessToken.getType()) {
            case BEARER_TOKEN: 
            case HAWK_TOKEN: {
                token = this.serializer.decryptAccessToken((OAuthDataProvider)this, accessToken.getTokenKey(), this.getSecretKey());
                break;
            }
            case REFRESH_TOKEN: {
                Iterable<OAuthToken> accessTokens = this.storage.getAccessTokensByRefreshToken(accessToken.getTokenKey());
                for (OAuthToken entry : accessTokens) {
                    boolean isExpired = OAuthUtils.isExpired((Long)entry.getIssuedAt(), (Long)entry.getExpiresIn());
                    if (!isExpired && entry.getGrantType().equals(grantType)) {
                        token = this.serializer.decryptAccessToken((OAuthDataProvider)this, entry.getTokenKey(), this.getSecretKey());
                    } else if (isExpired) {
                        this.revokeToken(client, entry.getTokenKey(), entry.getTokenType());
                    }
                    if (token != null) break block0;
                }
                break;
            }
        }
        return token;
    }

    private boolean isRolesOutdated(UserSubject subject, ServerAccessToken token) {
        List oldRoles = token.getSubject().getRoles();
        List newRoles = subject.getRoles();
        boolean equalLists = oldRoles.size() == newRoles.size() && oldRoles.containsAll(newRoles);
        return !equalLists;
    }

    private void revokeAllTokens(Client client, long subjectId, String grantType) {
        long clientId = this.getClientId(client);
        OAuthToken preauthorizedToken = this.storage.getPreauthorizedToken(clientId, subjectId, grantType);
        while (preauthorizedToken != null) {
            Iterable<OAuthToken> accessTokens = this.storage.getAccessTokensByRefreshToken(preauthorizedToken.getTokenKey());
            for (OAuthToken entry : accessTokens) {
                this.revokeToken(client, entry.getTokenKey(), "");
            }
            this.revokeToken(client, preauthorizedToken.getTokenKey(), "");
            preauthorizedToken = this.storage.getPreauthorizedToken(clientId, subjectId, grantType);
        }
    }

    public List<OAuthPermission> convertScopeToPermissions(Client client, List<String> requestedScope) {
        return Collections.emptyList();
    }

    private List<String> getApprovedScopes(List<String> requestedScopes, List<String> approvedScopes) {
        return approvedScopes.isEmpty() ? requestedScopes : approvedScopes;
    }
}

