/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.WorkItemArray;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.workitem.WorkItemJsonWriter;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.AttributeTypes;

@Provider
public class WorkItemArrayJsonWriter
implements MessageBodyWriter<WorkItemArray> {
    private JsonFactory jsonFactory;
    private AtsApi atsApi;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setAtsServer(IAtsServer atsServer) {
        this.atsApi = atsServer;
    }

    public void start() {
        this.jsonFactory = JsonUtil.getFactory();
    }

    public void stop() {
        this.jsonFactory = null;
    }

    public long getSize(WorkItemArray data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean assignableFrom = WorkItemArray.class.isAssignableFrom(type);
        return assignableFrom && MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    private boolean matches(Class<? extends Annotation> toMatch, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAssignableFrom(toMatch)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AttributeTypes getAttributeTypes() {
        return this.orcsApi.getOrcsTypes().getAttributeTypes();
    }

    public void writeTo(WorkItemArray workItemArray, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator writer = null;
        try {
            writer = this.jsonFactory.createGenerator(entityStream);
            writer.writeStartObject();
            writer.writeArrayFieldStart("workItems");
            for (IAtsWorkItem workItem : workItemArray.getWorkItems()) {
                WorkItemJsonWriter.addWorkItem(this.atsApi, this.orcsApi, workItem, annotations, writer, this.matches(IdentityView.class, annotations), this.getAttributeTypes(), Collections.emptyList());
            }
            writer.writeEndArray();
            writer.writeEndObject();
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }
}

