/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.task.JaxRelation;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CreateTasksOperation {
    private final NewTaskDatas newTaskDatas;
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    private final List<JaxAtsTask> tasks = new ArrayList<JaxAtsTask>();
    private IAtsUser asUser;
    private XResultData results;
    private Date createdByDate;
    private final Map<Long, IAtsTeamWorkflow> idToTeamWf = new HashMap<Long, IAtsTeamWorkflow>();

    public CreateTasksOperation(NewTaskData newTaskData, AtsApi atsApi, OrcsApi orcsApi, XResultData results) {
        this(new NewTaskDatas(newTaskData), atsApi, orcsApi, results);
    }

    public CreateTasksOperation(NewTaskDatas newTaskDatas, AtsApi atsApi, OrcsApi orcsApi, XResultData results) {
        this.newTaskDatas = newTaskDatas;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.results = results;
    }

    public XResultData validate() {
        if (this.results == null) {
            this.results = new XResultData(false);
        }
        for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
            Long teamWfId = newTaskData.getTeamWfId();
            if (teamWfId == null) {
                this.results.error("Team Workflow id not specified");
                continue;
            }
            IAtsTeamWorkflow teamWf = this.getTeamWorkflow(teamWfId);
            if (teamWf == null) {
                teamWf = this.atsApi.getWorkItemService().getTeamWf(ArtifactId.valueOf((Long)teamWfId));
            }
            if (teamWf == null) {
                this.results.errorf("Team Workflow id %s does not exist", new Object[]{teamWfId});
                continue;
            }
            String asUserId = newTaskData.getAsUserId();
            if (asUserId == null) {
                this.results.error("As User Id id not specified");
                continue;
            }
            this.asUser = this.atsApi.getUserService().getUserById(asUserId);
            if (this.asUser == null) {
                this.results.errorf("As User Id id %d does not exist\n", new Object[]{asUserId});
                continue;
            }
            if (!Strings.isValid((String)newTaskData.getCommitComment())) {
                this.results.errorf("Inavlidate Commit Comment [%s]\n", new Object[]{newTaskData.getCommitComment()});
                continue;
            }
            for (JaxAtsTask task : newTaskData.getNewTasks()) {
                List assigneeUserIds;
                String relatedToState;
                IAtsUser createdBy;
                ArtifactReadable taskArt;
                Long taskId = task.getId();
                if (taskId != null && taskId > 0L && (taskArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(taskId)) != null) {
                    this.results.errorf("Task with id %d already exists for %s\n", new Object[]{taskId, task});
                }
                if (!Strings.isValid((String)task.getName())) {
                    this.results.errorf("Task name [%s] is invalid for %s\n", new Object[]{task.getName(), task});
                }
                if ((createdBy = this.atsApi.getUserService().getUserById(task.getCreatedByUserId())) == null) {
                    this.results.errorf("Task Created By user id %d does not exist in %s\n", new Object[]{createdBy, task});
                }
                this.createdByDate = task.getCreatedDate();
                if (this.createdByDate == null) {
                    this.results.errorf("Task Created By Date %s does not exist in %s\n", new Object[]{this.createdByDate, task});
                }
                if (Strings.isValid((String)(relatedToState = task.getRelatedToState())) && teamWf.getWorkDefinition().getStateByName(relatedToState) == null) {
                    this.results.errorf("Task Related To State %s invalid for Team Workflow %d\n", new Object[]{relatedToState, teamWfId});
                }
                if (!(assigneeUserIds = task.getAssigneeUserIds()).isEmpty()) {
                    Collection assignees = this.atsApi.getUserService().getUsersByUserIds((Collection)assigneeUserIds);
                    if (assigneeUserIds.size() != assignees.size()) {
                        this.results.errorf("Task Assignees [%s] not all valid in %s\n", new Object[]{String.valueOf(assigneeUserIds), task});
                    }
                }
                IAtsWorkDefinition workDefinition = null;
                if (Strings.isValid((String)task.getTaskWorkDef())) {
                    try {
                        workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)ArtifactId.valueOf((String)task.getTaskWorkDef()));
                        if (workDefinition == null) {
                            this.results.errorf("Error finding Task Work Def [%s].\n", new Object[]{task.getTaskWorkDef()});
                        }
                    }
                    catch (Exception ex) {
                        this.results.errorf("Exception finding Task Work Def [%s].  Exception: %s\n", new Object[]{task.getTaskWorkDef(), ex.getMessage()});
                    }
                }
                if (workDefinition == null) {
                    workDefinition = this.atsApi.getWorkDefinitionService().computedWorkDefinitionForTaskNotYetCreated(teamWf);
                }
                Conditions.assertNotNull((Object)workDefinition, (String)"Work Definition can not be null for [%s]", (Object[])new Object[]{task.getTaskWorkDef()});
                for (JaxAttribute attribute : task.getAttributes()) {
                    AttributeTypeToken attrType = this.atsApi.getStoreService().getAttributeType(attribute.getAttrTypeName());
                    if (attrType == null || attrType.isInvalid()) {
                        this.results.errorf("Attribute Type [%s] not valid for Task creation in %s", new Object[]{attrType, task});
                    }
                    for (JaxRelation relation : task.getRelations()) {
                        RelationTypeToken relationType = this.getRelationType(this.atsApi, relation.getRelationTypeName());
                        if (relationType == null) {
                            this.results.errorf("Relation Type [%s] not valid for Task creation in %s\n", new Object[]{relation.getRelationTypeName(), task});
                        }
                        if (relation.getRelatedIds().isEmpty()) {
                            this.results.errorf("Relation [%s] Ids must be suplied Task creation in %s\n", new Object[]{relation.getRelationTypeName(), task});
                        }
                        ArrayList<Long> foundWorkItemIds = new ArrayList<Long>();
                        for (ArtifactId foundId : this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(relation.getRelatedIds().toArray(new Long[relation.getRelatedIds().size()])).getItemIds()) {
                            foundWorkItemIds.add(foundId.getId());
                        }
                        if (foundWorkItemIds.size() == relation.getRelatedIds().size()) continue;
                        ArrayList notFoundIds = new ArrayList();
                        System.err.println(String.valueOf(this.getClass().getSimpleName()) + " - Fix art long not used below");
                        Iterator iterator = relation.getRelatedIds().iterator();
                        while (iterator.hasNext()) {
                            Long cfr_ignored_0 = (Long)iterator.next();
                            notFoundIds.addAll(relation.getRelatedIds());
                            notFoundIds.removeAll(foundWorkItemIds);
                            this.results.errorf("Relation [%s] Work Item Ids [%s] has unfound Work Item(s) in db for task %s", new Object[]{relation.getRelationTypeName(), notFoundIds, task});
                        }
                    }
                }
            }
        }
        return this.results;
    }

    private IAtsTeamWorkflow getTeamWorkflow(Long teamWfId) {
        ArtifactToken art;
        IAtsTeamWorkflow teamWf = this.idToTeamWf.get(teamWfId);
        if (teamWf == null && (art = this.atsApi.getQueryService().getArtifact(teamWfId)) != null && (teamWf = this.atsApi.getWorkItemService().getTeamWf(art)) != null) {
            this.idToTeamWf.put((long)teamWfId, teamWf);
        }
        return teamWf;
    }

    private RelationTypeToken getRelationType(AtsApi atsApi, String relationTypeName) {
        for (RelationTypeToken relation : this.orcsApi.getOrcsTypes().getRelationTypes().getAll()) {
            if (!relation.getName().equals(relationTypeName)) continue;
            return relation;
        }
        return RelationTypeToken.SENTINEL;
    }

    public List<JaxAtsTask> getTasks() {
        return this.tasks;
    }

    public void run() {
        XResultData results = this.validate();
        if (results.isErrors()) {
            return;
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet(((NewTaskData)this.newTaskDatas.getTaskDatas().iterator().next()).getCommitComment(), this.asUser);
        this.run(changes);
        TransactionId trans = changes.executeIfNeeded();
        if (trans != null && trans.isValid()) {
            for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
                for (JaxAtsTask jaxTask : newTaskData.getNewTasks()) {
                    JaxAtsTask newJaxTask = CreateTasksOperation.createNewJaxTask(jaxTask.getId(), this.atsApi);
                    if (newJaxTask == null) {
                        results.errorf("Unable to create return New Task for id %s\n" + jaxTask.getId(), new Object[0]);
                    }
                    this.tasks.add(newJaxTask);
                }
            }
        }
    }

    public void run(IAtsChangeSet changes) {
        this.createTasks(changes);
        if (changes.isEmpty()) {
            this.results.log(String.valueOf(this.getClass().getSimpleName()) + " Error - No Tasks to Create");
        }
    }

    private void createTasks(IAtsChangeSet changes) {
        for (NewTaskData newTaskData : this.newTaskDatas.getTaskDatas()) {
            for (JaxAtsTask jaxTask : newTaskData.getNewTasks()) {
                Long id = jaxTask.getId();
                if (id == null || id <= 0L) {
                    id = Lib.generateArtifactIdAsInt();
                    jaxTask.setId(id);
                }
                ArtifactToken taskArt = changes.createArtifact(AtsArtifactTypes.Task, jaxTask.getName(), id);
                IAtsTask task = this.atsApi.getWorkItemService().getTask(taskArt);
                IAtsTeamWorkflow teamWf = this.idToTeamWf.get(newTaskData.getTeamWfId());
                this.atsApi.getActionFactory().setAtsId((IAtsObject)task, teamWf.getTeamDefinition(), null, changes);
                changes.relate((Object)teamWf, AtsRelationTypes.TeamWfToTask_Task, (Object)taskArt);
                ArrayList<IAtsUser> assignees = new ArrayList<IAtsUser>();
                if (jaxTask.getAssigneeUserIds() != null) {
                    assignees.addAll(this.atsApi.getUserService().getUsersByUserIds((Collection)jaxTask.getAssigneeUserIds()));
                }
                if (assignees.isEmpty()) {
                    assignees.add(AtsCoreUsers.UNASSIGNED_USER);
                }
                IAtsWorkDefinition workDefinition = null;
                if (Strings.isNumeric((String)jaxTask.getTaskWorkDef())) {
                    workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition(Long.valueOf(jaxTask.getTaskWorkDef()));
                    Conditions.assertNotNull((Object)workDefinition, (String)"Work Definition can not be null for [%s]", (Object[])new Object[]{task});
                    this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)task, workDefinition, changes);
                } else {
                    workDefinition = this.atsApi.getWorkDefinitionService().computeAndSetWorkDefinitionAttrs((IAtsWorkItem)task, null, changes);
                    Conditions.assertNotNull((Object)workDefinition, (String)"Work Definition can not be null for [%s]", (Object[])new Object[]{task});
                }
                if (Strings.isValid((String)jaxTask.getDescription())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.Description, jaxTask.getDescription());
                }
                IAtsUser createdBy = this.atsApi.getUserService().getUserById(jaxTask.getCreatedByUserId());
                this.atsApi.getActionFactory().initializeNewStateMachine((IAtsWorkItem)task, assignees, this.createdByDate, createdBy, workDefinition, changes);
                if (Strings.isValid((String)jaxTask.getRelatedToState())) {
                    changes.setSoleAttributeValue((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, jaxTask.getRelatedToState());
                }
                for (JaxAttribute attribute : jaxTask.getAttributes()) {
                    AttributeTypeToken attrType = this.orcsApi.getOrcsTypes().getAttributeTypes().getByName(attribute.getAttrTypeName());
                    changes.setAttributeValues((IAtsObject)task, attrType, attribute.getValues());
                }
                for (JaxRelation relation : jaxTask.getRelations()) {
                    RelationTypeToken relationType = this.getRelationType(this.atsApi, relation.getRelationTypeName());
                    if (relationType == null) {
                        this.results.errorf("Relation Type [%s] not valid for Task creation in %s\n", new Object[]{relation.getRelationTypeName(), task});
                    }
                    Collection items = this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(relation.getRelatedIds().toArray(new Long[relation.getRelatedIds().size()])).getItems();
                    RelationTypeSide side = null;
                    side = relation.isSideA() ? new RelationTypeSide(relationType, RelationSide.SIDE_A) : new RelationTypeSide(relationType, RelationSide.SIDE_B);
                    changes.setRelations((Object)task, side, items);
                }
                changes.add((Object)taskArt);
            }
        }
    }

    public static JaxAtsTask createNewJaxTask(Long id, AtsApi atsApi) {
        ArtifactReadable taskArt = (ArtifactReadable)atsApi.getQueryService().getArtifact(id);
        if (taskArt != null) {
            JaxAtsTask newJaxTask = new JaxAtsTask();
            newJaxTask.setName(taskArt.getName());
            newJaxTask.setDescription((String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.Description, (Object)""));
            newJaxTask.setId(taskArt.getId());
            newJaxTask.setActive(true);
            String createdByUserId = (String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CreatedBy, null);
            newJaxTask.setCreatedByUserId(createdByUserId);
            newJaxTask.setCreatedDate((Date)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CreatedDate));
            newJaxTask.setRelatedToState((String)taskArt.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)""));
            IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem((ArtifactToken)taskArt);
            for (IAtsUser user : workItem.getAssignees()) {
                newJaxTask.addAssigneeUserIds(user.getUserId());
            }
            for (AttributeTypeToken type : taskArt.getExistingAttributeTypes()) {
                LinkedList attributeValues = new LinkedList();
                for (Object value : taskArt.getAttributeValues(type)) {
                    attributeValues.add(value);
                }
                newJaxTask.addAttributes(type.getName(), attributeValues);
            }
            return newJaxTask;
        }
        return null;
    }

    public void setIdToTeamWf(Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        for (Map.Entry<Long, IAtsTeamWorkflow> entry : idToTeamWf.entrySet()) {
            this.idToTeamWf.put(entry.getKey(), entry.getValue());
        }
    }
}

