/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.transition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.ITransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TransitionResults {
    boolean cancelled;
    private final List<ITransitionResult> results = new ArrayList<ITransitionResult>();
    private final Map<IAtsWorkItem, List<ITransitionResult>> workItemToResults = new HashMap<IAtsWorkItem, List<ITransitionResult>>();

    public void addResult(IAtsWorkItem workItem, ITransitionResult result) {
        List<ITransitionResult> results = this.workItemToResults.get(workItem);
        if (results == null) {
            results = new ArrayList<ITransitionResult>();
            this.workItemToResults.put(workItem, results);
        }
        results.add(result);
    }

    public void clear() {
        this.results.clear();
        this.workItemToResults.clear();
    }

    public void addResult(ITransitionResult result) {
        this.results.add(result);
    }

    public boolean isEmpty() {
        return this.results.isEmpty() && this.workItemToResults.isEmpty();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean contains(String string) {
        return this.toString().contains(string);
    }

    public boolean contains(TransitionResult transitionResult) {
        return this.results.contains(transitionResult);
    }

    public boolean isEmpty(IAtsWorkItem workItem) {
        List<ITransitionResult> workItemResults = this.workItemToResults.get(workItem);
        return workItemResults == null || workItemResults.isEmpty();
    }

    public boolean contains(IAtsWorkItem workItem, TransitionResult transitionResult) {
        List<ITransitionResult> workItemResults = this.workItemToResults.get(workItem);
        if (workItemResults == null) {
            return false;
        }
        return workItemResults.contains(transitionResult);
    }

    public String getResultString() {
        if (this.results.isEmpty() && this.workItemToResults.isEmpty()) {
            return "<Empty>";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Reason(s):\n");
        this.appendResultsString(sb, this.results);
        for (IAtsWorkItem workItem : this.workItemToResults.keySet()) {
            sb.append("\n");
            sb.append(workItem.getArtifactTypeName());
            sb.append(" [");
            sb.append(workItem.getAtsId());
            sb.append("] Titled [");
            sb.append(workItem.getName());
            sb.append("]\n\n");
            this.appendResultsString(sb, this.workItemToResults.get(workItem));
        }
        return sb.toString();
    }

    public void appendResultsString(StringBuffer sb, List<ITransitionResult> results) {
        for (ITransitionResult result : results) {
            sb.append("    - ");
            sb.append(result.getDetails());
            if (result.getException() != null) {
                if (Strings.isValid((String)result.getException().getLocalizedMessage())) {
                    sb.append(" - Exception [");
                    sb.append(result.getException().getLocalizedMessage());
                    sb.append("] (see log for details)");
                } else {
                    sb.append(" - (see log for details)");
                }
            }
            sb.append("\n");
        }
    }

    public XResultData getResultXResultData() {
        XResultData resultData = new XResultData(false);
        resultData.log("Transition Failed");
        String str = this.getResultString();
        resultData.addRaw(str);
        return resultData;
    }

    public String toString() {
        return this.getResultString();
    }

    public List<ITransitionResult> getResults() {
        return this.results;
    }

    public Map<IAtsWorkItem, List<ITransitionResult>> getWorkItemToResults() {
        return this.workItemToResults;
    }
}

