/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.note;

import java.util.Date;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.note.NoteType;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class NoteItem {
    private Date date;
    private final String state;
    private String msg;
    private IAtsUser user;
    private NoteType type = NoteType.Other;

    public NoteItem(NoteType type, String state, String date, IAtsUser user, String msg) {
        Long l = Long.valueOf(date);
        this.date = new Date(l);
        this.state = Strings.intern((String)state);
        this.msg = msg;
        this.user = user;
        this.type = type;
    }

    public NoteItem(String type, String state, String date, IAtsUser user, String msg) {
        this(NoteType.getType(type), state, date, user, msg);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return String.format("Note: %s from %s%s on %s - %s", new Object[]{this.type, this.user.getName(), this.toStringState(), DateUtil.getMMDDYYHHMM((Date)this.date), this.msg});
    }

    private String toStringState() {
        return this.state.isEmpty() ? "" : " for \"" + this.state + "\"";
    }

    public IAtsUser getUser() {
        return this.user;
    }

    public NoteType getType() {
        return this.type;
    }

    public void setType(NoteType type) {
        this.type = type;
    }

    public String toHTML() {
        return this.toString().replaceFirst("^Note: ", "<b>Note:</b>");
    }

    public String getState() {
        return this.state;
    }

    public void setUser(IAtsUser user) {
        this.user = user;
    }
}

