/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;
import org.eclipse.osee.ats.api.workdef.model.HeaderDefinition;

public class WorkDefinition
extends AbstractWorkDefItem
implements IAtsWorkDefinition {
    private final List<IAtsStateDefinition> states = new ArrayList<IAtsStateDefinition>(5);
    private IAtsStateDefinition startState;
    private HeaderDefinition headerDef;
    private boolean showStateMetrics = false;
    private final List<CreateTasksDefinition> createTasksDefs = new ArrayList<CreateTasksDefinition>();

    public WorkDefinition(Long id, String name) {
        super(id, name);
        this.headerDef = new HeaderDefinition(this);
    }

    @Override
    public IAtsStateDefinition getStateByName(String name) {
        for (IAtsStateDefinition state : this.states) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    @Override
    public IAtsStateDefinition getStartState() {
        return this.startState;
    }

    public void setStartState(IAtsStateDefinition startState) {
        this.startState = startState;
    }

    public IAtsStateDefinition addState(IAtsStateDefinition state) {
        IAtsStateDefinition currState = this.getStateByName(state.getName());
        if (currState != null) {
            throw new IllegalArgumentException("Can not add two states of same name");
        }
        this.states.add(state);
        return state;
    }

    @Override
    public List<IAtsStateDefinition> getStates() {
        return this.states;
    }

    @Override
    public HeaderDefinition getHeaderDef() {
        return this.headerDef;
    }

    @Override
    public boolean hasHeaderDefinitionItems() {
        return this.headerDef != null && !this.headerDef.getLayoutItems().isEmpty();
    }

    @Override
    public HeaderDefinition getDefaultHeaderDef() {
        HeaderDefinition defaultHeaderDef = new HeaderDefinition(this);
        defaultHeaderDef.setShowMetricsHeader(true);
        defaultHeaderDef.setShowWorkPackageHeader(true);
        return defaultHeaderDef;
    }

    @Override
    public void setHeaderDefinition(HeaderDefinition headerDef) {
        this.headerDef = headerDef;
    }

    @Override
    public boolean isShowStateMetrics() {
        return this.showStateMetrics;
    }

    @Override
    public void setShowStateMetrics(boolean showStateMetrics) {
        this.showStateMetrics = showStateMetrics;
    }

    public void addTaskSetDef(CreateTasksDefinition createTasksDef) {
        this.createTasksDefs.add(createTasksDef);
    }

    @Override
    public List<CreateTasksDefinition> getCreateTasksDefs() {
        return this.createTasksDefs;
    }
}

