/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.session;

import java.util.Collection;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.cache.admin.CacheAdmin;
import org.eclipse.osee.cache.admin.CacheConfiguration;
import org.eclipse.osee.cache.admin.CacheDataLoader;
import org.eclipse.osee.cache.admin.CacheKeysLoader;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.core.server.internal.session.DatabaseSessionAccessor;
import org.eclipse.osee.framework.core.server.internal.session.DatabaseSessionQuery;
import org.eclipse.osee.framework.core.server.internal.session.Session;
import org.eclipse.osee.framework.core.server.internal.session.SessionFactory;
import org.eclipse.osee.framework.core.server.internal.session.SessionManagerImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;

public final class SessionManagerService
implements ISessionManager {
    private Log logger;
    private JdbcService jdbcService;
    private IAuthenticationManager authenticationManager;
    private CacheAdmin cacheAdmin;
    private ISessionManager proxiedSessionManager;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setAuthenticationManager(IAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setCacheAdmin(CacheAdmin cacheAdmin) {
        this.cacheAdmin = cacheAdmin;
    }

    public void start() {
        JdbcClient jdbcClient = this.jdbcService.getClient();
        SessionFactory sessionFactory = new SessionFactory(this.logger, this.jdbcService);
        DatabaseSessionQuery sessionQuery = new DatabaseSessionQuery(jdbcClient);
        DatabaseSessionAccessor accessor = new DatabaseSessionAccessor(sessionFactory, sessionQuery, jdbcClient);
        CacheConfiguration config = CacheConfiguration.newConfiguration();
        Cache sessionCache = null;
        try {
            sessionCache = this.cacheAdmin.createLoadingCache(config, (CacheDataLoader)accessor, (CacheKeysLoader)accessor);
        }
        catch (Exception e) {
            OseeCoreException.wrapAndThrow((Throwable)e);
        }
        this.proxiedSessionManager = new SessionManagerImpl(sessionFactory, (Cache<String, Session>)sessionCache, this.authenticationManager, accessor);
    }

    public void stop() {
    }

    @Override
    public OseeSessionGrant createSession(OseeCredential credential) {
        return this.proxiedSessionManager.createSession(credential);
    }

    @Override
    public void releaseSession(String sessionId) {
        this.proxiedSessionManager.releaseSession(sessionId);
    }

    @Override
    public ISession getSessionById(String sessionId) {
        return this.proxiedSessionManager.getSessionById(sessionId);
    }

    @Override
    public Collection<ISession> getSessionByClientAddress(String clientAddress) {
        return this.proxiedSessionManager.getSessionByClientAddress(clientAddress);
    }

    @Override
    public Collection<ISession> getSessionsByUserId(String userId) {
        return this.proxiedSessionManager.getSessionsByUserId(userId);
    }

    @Override
    public Collection<ISession> getAllSessions() {
        return this.proxiedSessionManager.getAllSessions();
    }

    @Override
    public void releaseSessionImmediate(String ... sessionId) {
        this.proxiedSessionManager.releaseSessionImmediate(sessionId);
    }
}

