/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.integration;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osee.framework.core.data.IAccessContextId;
import org.eclipse.osee.framework.core.dsl.integration.AccessModelInterpreter;
import org.eclipse.osee.framework.core.dsl.integration.OseeDslProvider;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessContext;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDsl;
import org.eclipse.osee.framework.core.model.access.AccessData;
import org.eclipse.osee.framework.core.model.access.AccessDetail;
import org.eclipse.osee.framework.core.model.access.AccessDetailCollector;
import org.eclipse.osee.framework.core.model.access.AccessModel;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class OseeDslAccessModel
implements AccessModel {
    private final AccessModelInterpreter interpreter;
    private final OseeDslProvider dslProvider;

    public OseeDslAccessModel(AccessModelInterpreter interpreter, OseeDslProvider dslProvider) {
        this.interpreter = interpreter;
        this.dslProvider = dslProvider;
    }

    public void computeAccess(IAccessContextId contextId, Collection<Object> objectsToCheck, AccessData accessData) {
        Conditions.checkNotNull((Object)contextId, (String)"contextId");
        Conditions.checkNotNull(objectsToCheck, (String)"objectsToCheck");
        Conditions.checkNotNull((Object)accessData, (String)"accessData");
        OseeDsl oseeDsl = this.dslProvider.getDsl();
        Conditions.checkNotNull((Object)oseeDsl, (String)"oseeDsl", (String)"dsl provider returned null", (Object[])new Object[0]);
        EList contexts = oseeDsl.getAccessDeclarations();
        AccessContext context = this.interpreter.getContext((Collection<AccessContext>)contexts, contextId);
        Conditions.checkNotNull((Object)context, (String)"interpreted accessContext", (String)"No matching access context was found in access dsl for [%s]", (Object[])new Object[]{contextId});
        for (Object objectToCheck : objectsToCheck) {
            LinkedList accessDetail = new LinkedList();
            AccessDataCollector collector = new AccessDataCollector(accessDetail);
            this.interpreter.computeAccessDetails(collector, context, objectToCheck);
            accessData.addAll(objectToCheck, accessDetail);
        }
    }

    private static final class AccessDataCollector
    implements AccessDetailCollector {
        private final Collection<AccessDetail<?>> accessDetails;

        public AccessDataCollector(Collection<AccessDetail<?>> accessDetails) {
            this.accessDetails = accessDetails;
        }

        public void collect(AccessDetail<?> accessDetail) {
            if (accessDetail != null) {
                this.accessDetails.add(accessDetail);
            }
        }
    }
}

