/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.grammar.ApplicabilityBlock;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarLexer;
import org.eclipse.osee.framework.core.grammar.ApplicabilityGrammarParser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordMLApplicabilityHandler {
    private static String SCRIPT_ENGINE_NAME = "JavaScript";
    private final Set<String> validConfigurations;
    private Map<String, List<String>> viewApplicabilitiesMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final String configurationToView;
    private final Stack<ApplicabilityBlock> applicBlocks = new Stack();
    private final String featureDefinitionJson;
    private final ScriptEngine se;
    private final Log logger;

    public WordMLApplicabilityHandler(OrcsApi orcsApi, Log logger, BranchId branch, ArtifactId view) {
        this.logger = logger;
        ScriptEngineManager sem = new ScriptEngineManager();
        this.se = sem.getEngineByName(SCRIPT_ENGINE_NAME);
        QueryFactory query = orcsApi.getQueryFactory();
        branch = WordMLApplicabilityHandler.getProductLineBranch(query, branch);
        this.validConfigurations = WordMLApplicabilityHandler.getValidConfigurations(query, branch);
        this.viewApplicabilitiesMap = query.applicabilityQuery().getNamedViewApplicabilityMap(branch, view);
        ArtifactToken viewArtifact = query.fromBranch(branch).andId(view).asArtifactToken();
        this.configurationToView = viewArtifact.getName();
        ArtifactReadable featureDefArt = (ArtifactReadable)query.fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.FeatureDefinition}).getResults().getExactlyOne();
        this.featureDefinitionJson = featureDefArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
    }

    public static BranchId getProductLineBranch(QueryFactory query, BranchId branch) {
        Branch br = (Branch)((BranchQuery)query.branchQuery().andId(branch)).getResults().getExactlyOne();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branch = br.getParentBranch();
        }
        return branch;
    }

    public String previewValidApplicabilityContent(String content) {
        String toReturn = content;
        int searchIndex = 0;
        int applicBlockCount = 0;
        Matcher matcher = WordCoreUtil.FULL_PATTERN.matcher(toReturn);
        while (searchIndex < toReturn.length() && matcher.find(searchIndex)) {
            String endConfig;
            String beginFeature = matcher.group(1);
            String beginConfig = matcher.group(26);
            String endFeature = matcher.group(12) != null ? WordCoreUtil.textOnly((String)matcher.group(12)).toLowerCase() : null;
            String string = endConfig = matcher.group(48) != null ? WordCoreUtil.textOnly((String)matcher.group(48)).toLowerCase() : null;
            if (beginFeature != null && WordCoreUtil.textOnly((String)beginFeature).toLowerCase().contains(WordCoreUtil.FEATUREAPP)) {
                ++applicBlockCount;
                searchIndex = this.addApplicabilityBlock(ApplicabilityBlock.ApplicabilityType.Feature, matcher, beginFeature, searchIndex, toReturn);
                continue;
            }
            if (beginConfig != null && WordCoreUtil.textOnly((String)beginConfig).toLowerCase().contains(WordCoreUtil.CONFIGAPP)) {
                if (this.isValidConfigurationBracket(beginConfig)) {
                    ++applicBlockCount;
                    ApplicabilityBlock.ApplicabilityType type = ApplicabilityBlock.ApplicabilityType.Configuration;
                    if (beginConfig.contains("Not")) {
                        type = ApplicabilityBlock.ApplicabilityType.NotConfiguration;
                    }
                    searchIndex = this.addApplicabilityBlock(type, matcher, beginConfig, searchIndex, toReturn);
                    continue;
                }
                searchIndex = matcher.end();
                continue;
            }
            if ((endFeature == null || !endFeature.contains(WordCoreUtil.FEATUREAPP)) && (endConfig == null || !endConfig.contains(WordCoreUtil.CONFIGAPP))) break;
            ApplicabilityBlock applicabilityBlock = this.getFullApplicabilityBlock(matcher, toReturn);
            if (applicabilityBlock == null) {
                searchIndex = matcher.end();
                continue;
            }
            --applicBlockCount;
            String toInsert = this.evaluateApplicabilityBlock(applicabilityBlock, toReturn);
            String toReplace = toReturn.substring(applicabilityBlock.getStartInsertIndex(), applicabilityBlock.getEndInsertIndex());
            toReturn = toReturn.replace(toReplace, toInsert);
            searchIndex = applicabilityBlock.getStartInsertIndex() + (applicabilityBlock.isInTable() ? 0 : toInsert.length());
            matcher = WordCoreUtil.FULL_PATTERN.matcher(toReturn);
        }
        toReturn = this.removeEmptyLists(toReturn);
        if (applicBlockCount != 0) {
            this.logger.error("An applicability block of text is missing an End Feature/Configuration tag", new Object[0]);
        }
        return toReturn;
    }

    private boolean isValidConfigurationBracket(String beginConfig) {
        beginConfig = WordCoreUtil.textOnly((String)beginConfig);
        int start = beginConfig.indexOf("[") + 1;
        int end = beginConfig.indexOf("]");
        String applicExpText = beginConfig.substring(start, end);
        String[] configs = applicExpText.split("&|\\|");
        int i = 0;
        while (i < configs.length) {
            configs[i] = configs[i].split("=")[0].trim();
            if (!this.containsIgnoreCase(this.validConfigurations, configs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidFeatureBracket(String optionalEndBracket) {
        String[] featureValueStrings;
        String text = WordCoreUtil.textOnly((String)optionalEndBracket);
        text = text.replaceAll("\\[", "");
        text = text.replaceAll("\\]", "").trim();
        String[] stringArray = featureValueStrings = text.split("\\||&");
        int n = featureValueStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String featVal;
            String featureValueString = stringArray[n2];
            String[] split = featureValueString.split("=");
            String featName = split[0].trim().toUpperCase();
            String string = featVal = split.length > 1 ? split[1].trim() : null;
            if (this.viewApplicabilitiesMap.containsKey(featName)) {
                List<String> values = this.viewApplicabilitiesMap.get(featName);
                if (featVal != null && !this.containsIgnoreCase(values, featVal)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String evaluateApplicabilityBlock(ApplicabilityBlock applicabilityBlock, String fullWordML) {
        TreeMap<String, String> binDataMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.saveBinData(applicabilityBlock.getFullText(), binDataMap);
        String toInsert = this.evaluateApplicabilityExpression(applicabilityBlock);
        return this.insertMissingbinData(toInsert, binDataMap);
    }

    private String removeEmptyLists(String wordML) {
        return wordML.replaceAll(WordCoreUtil.EMPTY_LIST_REGEX, "");
    }

    private String insertMissingbinData(String toInsert, Map<String, String> binDataMap) {
        String temp = toInsert;
        Matcher matcher = WordCoreUtil.IMG_SRC_PATTERN.matcher(temp);
        while (matcher.find()) {
            String binData;
            String srcId = matcher.group(1);
            if (!binDataMap.containsKey(srcId) || temp.contains(binData = binDataMap.get(srcId))) continue;
            temp = String.valueOf(binData) + temp;
        }
        return temp;
    }

    private void saveBinData(String fullText, Map<String, String> binDataMap) {
        Matcher matcher = WordCoreUtil.BIN_DATA_PATTERN.matcher(fullText);
        while (matcher.find()) {
            binDataMap.put(matcher.group(1), matcher.group(0));
        }
    }

    private int addApplicabilityBlock(ApplicabilityBlock.ApplicabilityType type, Matcher matcher, String applicabilityExpression, int searchIndex, String fullWordMl) {
        ApplicabilityBlock beginApplic = new ApplicabilityBlock();
        beginApplic.setType(type);
        String applicExpText = WordCoreUtil.textOnly((String)applicabilityExpression).toLowerCase().replace(" [", "[");
        beginApplic.setApplicabilityExpression(applicExpText);
        beginApplic.setStartInsertIndex(matcher.start());
        beginApplic.setStartTextIndex(matcher.end());
        this.applicBlocks.push(beginApplic);
        searchIndex = matcher.end();
        return searchIndex;
    }

    private ApplicabilityBlock getFullApplicabilityBlock(Matcher matcher, String toReturn) {
        String findEndOfRow;
        int endRowIndex;
        String findStartOfRow;
        int startRowIndex;
        int endBracketGroup;
        if (this.applicBlocks.isEmpty()) {
            this.logger.error("An applicability block of text is missing a start Feature/Configuration tag", new Object[0]);
            return null;
        }
        ApplicabilityBlock applic = this.applicBlocks.pop();
        String optionalEndBracket = null;
        boolean isValidBracket = false;
        if (applic.getType().equals((Object)ApplicabilityBlock.ApplicabilityType.Configuration)) {
            endBracketGroup = 65;
            optionalEndBracket = matcher.group(endBracketGroup);
            isValidBracket = optionalEndBracket == null ? false : this.isValidConfigurationBracket(optionalEndBracket);
        } else {
            endBracketGroup = 23;
            optionalEndBracket = matcher.group(endBracketGroup);
            boolean bl = isValidBracket = optionalEndBracket == null ? false : this.isValidFeatureBracket(optionalEndBracket);
        }
        if (optionalEndBracket != null && !isValidBracket) {
            int newEndInsertIndex = matcher.end() - optionalEndBracket.length();
            applic.setEndInsertIndex(newEndInsertIndex);
        } else {
            applic.setEndInsertIndex(matcher.end());
        }
        applic.setEndTextIndex(matcher.start());
        String insideText = toReturn.substring(applic.getStartTextIndex(), applic.getEndTextIndex());
        applic.setFullText(insideText);
        if (!applic.getFullText().contains(WordCoreUtil.TABLE) && applic.getFullText().contains(WordCoreUtil.TABLE_CELL) && (startRowIndex = (findStartOfRow = toReturn.substring(0, applic.getStartInsertIndex())).lastIndexOf(WordCoreUtil.START_TABLE_ROW)) != -1 && (endRowIndex = (findEndOfRow = toReturn.substring(matcher.end())).indexOf(WordCoreUtil.END_TABLE_ROW)) != -1) {
            endRowIndex = endRowIndex + matcher.end() + 7;
            String fullText = toReturn.substring(startRowIndex, endRowIndex);
            applic.setIsInTable(true);
            applic.setStartInsertIndex(startRowIndex);
            applic.setEndInsertIndex(startRowIndex + fullText.length());
            fullText = fullText.replaceFirst("(?i)(" + WordCoreUtil.ENDFEATURE + "|" + WordCoreUtil.ENDCONFIG + ")", "");
            fullText = fullText.replaceFirst("(?i)(" + WordCoreUtil.BEGINFEATURE + "|" + WordCoreUtil.BEGINCONFIG + ")", "");
            applic.setFullText(fullText);
        }
        return applic;
    }

    private String evaluateApplicabilityExpression(ApplicabilityBlock applic) {
        String applicabilityExpression = applic.getApplicabilityExpression();
        String toInsert = "";
        try {
            String fullText = applic.getFullText();
            ApplicabilityGrammarLexer lex = new ApplicabilityGrammarLexer((CharStream)new ANTLRStringStream(applicabilityExpression.toUpperCase()));
            ApplicabilityGrammarParser parser = new ApplicabilityGrammarParser((TokenStream)new CommonTokenStream((TokenSource)lex));
            parser.start();
            ApplicabilityBlock.ApplicabilityType type = applic.getType();
            if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Feature)) {
                toInsert = this.getValidFeatureContent(fullText, applic.isInTable(), parser.getIdValuesMap(), parser.getOperators());
            } else if (type.equals((Object)ApplicabilityBlock.ApplicabilityType.Configuration) || type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration)) {
                toInsert = this.getValidConfigurationContent(type, fullText, parser.getIdValuesMap());
            }
        }
        catch (RecognitionException recognitionException) {
            this.logger.error("Failed to parse expression: " + applicabilityExpression + " at start Index: " + applic.getStartInsertIndex(), new Object[0]);
        }
        return toInsert;
    }

    public String getValidConfigurationContent(ApplicabilityBlock.ApplicabilityType type, String fullText, HashMap<String, List<String>> id_value_map) {
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            beginningText = fullText.substring(0, match.start());
            elseText = fullText.substring(match.end());
            elseText = elseText.replaceAll(WordCoreUtil.ENDCONFIG, "");
            elseText = elseText.replaceAll(WordCoreUtil.BEGINCONFIG, "");
        }
        String toReturn = "";
        List<String> values = id_value_map.get(this.configurationToView.toUpperCase());
        toReturn = type.equals((Object)ApplicabilityBlock.ApplicabilityType.NotConfiguration) ? (values != null ? elseText : beginningText) : (values == null ? elseText : beginningText);
        return toReturn;
    }

    private String getValidFeatureContent(String fullText, boolean isInTable, HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(fullText);
        String beginningText = fullText;
        String elseText = "";
        if (match.find()) {
            if (isInTable) {
                String temp = fullText.substring(0, match.end());
                int lastIndexOf = temp.lastIndexOf(WordCoreUtil.START_TABLE_ROW);
                if (lastIndexOf != -1) {
                    elseText = fullText.substring(lastIndexOf);
                    elseText = elseText.replaceAll(WordCoreUtil.ELSE_EXP, "");
                    beginningText = fullText.substring(0, lastIndexOf);
                }
            } else {
                beginningText = fullText.substring(0, match.start());
                elseText = fullText.substring(match.end());
            }
            elseText = elseText.replaceAll(WordCoreUtil.ENDFEATURE, "");
            elseText = elseText.replaceAll(WordCoreUtil.BEGINFEATURE, "");
        }
        String toReturn = "";
        String expression = this.createFeatureExpression(featureIdValuesMap, featureOperators);
        boolean result = false;
        try {
            result = (Boolean)this.se.eval(expression);
        }
        catch (ScriptException scriptException) {
            this.logger.error("Failed to parse expression: " + expression, new Object[0]);
        }
        toReturn = result ? beginningText : elseText;
        return toReturn;
    }

    private String createFeatureExpression(HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators) {
        String myFeatureExpression = "";
        Iterator<String> iterator = featureOperators.iterator();
        for (String feature : featureIdValuesMap.keySet()) {
            List<String> values = featureIdValuesMap.get(feature);
            String valueExpression = this.createValueExpression(feature, values);
            boolean result = false;
            try {
                result = (Boolean)this.se.eval(valueExpression);
            }
            catch (ScriptException scriptException) {
                this.logger.error("Failed to parse expression: " + valueExpression, new Object[0]);
            }
            myFeatureExpression = String.valueOf(myFeatureExpression) + result + " ";
            if (!iterator.hasNext()) continue;
            String next = iterator.next();
            if (next.equals("|")) {
                myFeatureExpression = String.valueOf(myFeatureExpression) + "|| ";
                continue;
            }
            if (!next.equals("&")) continue;
            myFeatureExpression = String.valueOf(myFeatureExpression) + "&& ";
        }
        return myFeatureExpression;
    }

    private String createValueExpression(String feature, List<String> values) {
        String myValueExpression = "";
        for (String value : values) {
            if (value.equals("(")) {
                myValueExpression = String.valueOf(myValueExpression) + "( ";
                continue;
            }
            if (value.equals(")")) {
                myValueExpression = String.valueOf(myValueExpression) + ") ";
                continue;
            }
            if (value.equals("|")) {
                myValueExpression = String.valueOf(myValueExpression) + "|| ";
                continue;
            }
            if (value.equals("&")) {
                myValueExpression = String.valueOf(myValueExpression) + "&& ";
                continue;
            }
            boolean eval = this.isFeatureValuePairValid(feature, value);
            myValueExpression = String.valueOf(myValueExpression) + eval + " ";
        }
        return myValueExpression;
    }

    private boolean isFeatureValuePairValid(String feature, String value) {
        if (this.viewApplicabilitiesMap.containsKey(feature)) {
            Collection validValues = this.viewApplicabilitiesMap.get(feature);
            String string = value = value.equalsIgnoreCase("Default") ? this.getDefaultValue(feature) : value.trim();
            if (this.containsIgnoreCase(validValues, value)) {
                return true;
            }
        }
        return false;
    }

    private boolean containsIgnoreCase(Collection<String> validValues, String val) {
        for (String validValue : validValues) {
            if (!validValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private String getDefaultValue(String feature) {
        FeatureDefinition[] featDataList;
        String toReturn = null;
        FeatureDefinition[] featureDefinitionArray = featDataList = (FeatureDefinition[])JsonUtil.readValue((String)this.featureDefinitionJson, FeatureDefinition[].class);
        int n = featDataList.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDefinition featData = featureDefinitionArray[n2];
            if (featData.getName().equalsIgnoreCase(feature)) {
                toReturn = featData.getDefaultValue();
                break;
            }
            ++n2;
        }
        return toReturn;
    }

    public static HashSet<String> getValidConfigurations(QueryFactory query, BranchId branch) {
        HashSet<String> validConfigurations = new HashSet<String>();
        List views = query.fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).asArtifactTokens();
        for (ArtifactToken view : views) {
            validConfigurations.add(view.getName().toUpperCase());
        }
        return validConfigurations;
    }
}

