/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.define.rest.importing.parsers.DoorsTableRowCollector;
import org.eclipse.osee.define.rest.internal.importing.NormalizeHtml;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.data.EnumType;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class DoorsArtifactExtractor
extends AbstractArtifactExtractor {
    private final Vector<String> postProcessImages = new Vector();
    private String uriDirectoryName = "";
    private static final String NAME_TAG = "<a name=";
    private static final String CLOSING_A_TAG = "</a>";
    private static final String BR_TAG = "<br />";
    private static final String BODY_START_TAG = "<body>";
    private static final String BODY_END_TAG = "</body>";
    private static final String LIST_ITEM_TAG = "<li>";
    private static final String LIST_ITEM_END_TAG = "</li>";
    private static final String IMAGE_BASE_NAME = "Image Content_";
    private final String BLANK_HTML_LINE = "<br />";
    private static String VERIFICATION_ACCEPTANCE_CRITERIA = "Verification Acceptance Criteria:";
    private static String CRITERIA = "Criteria:";
    private static final String[] VERIFICATION_KEYWORDS = new String[]{"Effectivity:", "Configuration:", "Verf Method:", "Verification Method:", "Verf Level:", "Verf Location:", "Verification Environment:", "Verf Type:", "Verified By:", VERIFICATION_ACCEPTANCE_CRITERIA, CRITERIA};
    private static final AttributeTypeToken[] FIELD_TYPE;

    static {
        AttributeTypeToken[] attributeTypeTokenArray = new AttributeTypeToken[11];
        attributeTypeTokenArray[2] = CoreAttributeTypes.QualificationMethod;
        attributeTypeTokenArray[3] = CoreAttributeTypes.QualificationMethod;
        attributeTypeTokenArray[4] = CoreAttributeTypes.VerificationLevel;
        attributeTypeTokenArray[5] = CoreAttributeTypes.VerificationEvent;
        attributeTypeTokenArray[6] = CoreAttributeTypes.VerificationEvent;
        attributeTypeTokenArray[7] = CoreAttributeTypes.VerificationEvent;
        FIELD_TYPE = attributeTypeTokenArray;
    }

    public String getDescription() {
        return "Extract artifacts from a DOORS HTML table export file ";
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".htm");
            }
        };
    }

    public String getName() {
        return "DOORS HTML Table export file";
    }

    public boolean usesTypeList() {
        return false;
    }

    @Override
    public XResultData extractFromSource(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector) throws Exception {
        this.doExtraction(orcsApi, results, source, collector, "");
        return results;
    }

    public void doExtraction(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector, String documentApplicabilty) {
        block8: {
            InputStream htmlStream = null;
            try {
                try {
                    String fileName = "file://" + source.getPath();
                    this.uriDirectoryName = fileName.substring(0, fileName.lastIndexOf(47) + 1);
                    this.postProcessImages.clear();
                    htmlStream = source.toURL().openStream();
                    DoorsTableRowCollector rowCollector = new DoorsTableRowCollector(this);
                    Document doc = Jsoup.parse((InputStream)htmlStream, (String)"UTF-8", (String)"");
                    Element body = doc.body();
                    for (Node cNodes : body.childNodes()) {
                        for (Node subNodes : cNodes.childNodes()) {
                            if (subNodes.nodeName().compareTo("tbody") != 0) continue;
                            for (Node tableRow : subNodes.childNodes()) {
                                if (!(tableRow instanceof Element)) continue;
                                rowCollector.addRawRow(tableRow);
                            }
                        }
                    }
                    rowCollector.createArtifacts(orcsApi, collector);
                }
                catch (Exception ex) {
                    results.error(ex.toString());
                    Lib.close(htmlStream);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Lib.close(htmlStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)htmlStream);
        }
    }

    @Override
    public boolean artifactCreated(TransactionBuilder transaction, ArtifactId theArtifact, RoughArtifact source) {
        boolean toReturn = false;
        String content = "";
        Collection imageURIs = source.getURIAttributes();
        if (imageURIs.size() > 0) {
            URI uri = (URI)source.getURIAttributes().iterator().next();
            if (uri != null) {
                content = uri.toASCIIString();
            }
            if (this.postProcessImages.contains(content)) {
                try {
                    List Ids = this.getAttributes(source.getOrcsApi(), transaction.getBranch(), theArtifact, (AttributeTypeToken)CoreAttributeTypes.ImageContent).getList();
                    List HTML = this.getAttributes(source.getOrcsApi(), transaction.getBranch(), theArtifact, (AttributeTypeToken)CoreAttributeTypes.HtmlContent).getList();
                    transaction.deleteAttributes(theArtifact, (AttributeTypeId)CoreAttributeTypes.HtmlContent);
                    for (Object htmlValObj : HTML) {
                        if (!(htmlValObj instanceof String)) continue;
                        String htmlVal = (String)htmlValObj;
                        int iCount = 0;
                        for (Object imageNumberObj : Ids) {
                            if (!(imageNumberObj instanceof Integer)) continue;
                            Integer imageNumber = (Integer)imageNumberObj;
                            htmlVal = htmlVal.replaceAll(IMAGE_BASE_NAME + Integer.toString(iCount), imageNumber.toString());
                            ++iCount;
                            toReturn = true;
                        }
                        transaction.createAttribute(theArtifact, (AttributeTypeToken)CoreAttributeTypes.HtmlContent, (Object)htmlVal);
                    }
                }
                catch (OseeCoreException ex) {
                    source.getResults().error(ex.toString());
                }
            }
        }
        return toReturn;
    }

    private ResultSet<?> getAttributes(OrcsApi orcsApi, BranchId branch, ArtifactId theArtifact, AttributeTypeToken attr) {
        return orcsApi.getQueryFactory().fromBranch(branch).andId(theArtifact).getArtifact().getAttributes((AttributeTypeId)attr);
    }

    public void foundStartOfWorksheet(String sheetName) {
    }

    public String processList(String inputValue) {
        int startPos;
        inputValue = this.normalizeHtml(inputValue);
        inputValue = inputValue.replaceAll("\\s+", " ");
        inputValue = inputValue.replaceAll("<div>", "");
        inputValue = inputValue.replaceAll("</div>", "");
        inputValue = inputValue.replaceAll("<br />\\s+<br />", BR_TAG);
        StringBuilder returnString = new StringBuilder(inputValue.trim());
        char[] theChars = DoorsArtifactExtractor.stringBuilderToChars(returnString);
        int[] startEnd = this.findEndOfList(theChars, 0);
        int iPos = startEnd[0];
        int endOfList = startEnd[1];
        int startOfNextList = startEnd[2];
        boolean isNumeric = Character.isDigit(theChars[iPos]);
        boolean isLowerCase = Character.isLowerCase(theChars[iPos]);
        int currentNumber = 0;
        String currentLetter = "";
        if (isNumeric) {
            startPos = iPos;
            while (theChars[iPos] != '.' && theChars[iPos] != ')') {
                ++iPos;
            }
            String theNumber = returnString.substring(startPos, iPos);
            currentNumber = Integer.parseInt(theNumber);
        } else {
            startPos = iPos;
            while (theChars[iPos] != '.' && theChars[iPos] != ')') {
                ++iPos;
            }
            currentLetter = returnString.substring(startPos, iPos);
        }
        int nextItem = 0;
        returnString.delete(iPos - 1, iPos + 1);
        endOfList -= 2;
        startOfNextList -= 2;
        String insertValue = null;
        insertValue = isNumeric ? "<ol>" : (isLowerCase ? "<ol type = \"a\">" : "<ol type = \"A\">");
        returnString.insert(iPos - 1, insertValue);
        if (iPos < endOfList) {
            endOfList += insertValue.length();
            startOfNextList += insertValue.length();
        }
        int adjust = this.removeForcedSpaces(returnString, (iPos += insertValue.length()) - 1, false);
        startOfNextList -= adjust;
        endOfList -= adjust;
        listData theListData = new listData();
        boolean lastWasSublist = false;
        while (nextItem != -1) {
            if (theListData.getNewList()) {
                lastWasSublist = true;
            } else {
                lastWasSublist = false;
                returnString.insert(iPos - 1, LIST_ITEM_TAG);
                if (iPos < endOfList) {
                    endOfList += LIST_ITEM_TAG.length();
                    startOfNextList += LIST_ITEM_TAG.length();
                }
                iPos += LIST_ITEM_TAG.length() - 1;
            }
            adjust = this.removeForcedSpaces(returnString, nextItem + LIST_ITEM_TAG.length(), false);
            startOfNextList -= adjust;
            endOfList -= adjust;
            theChars = DoorsArtifactExtractor.stringBuilderToChars(returnString);
            nextItem = this.findNextListItem(theChars, iPos, isNumeric, isLowerCase, currentNumber, currentLetter, theListData);
            if (nextItem == -1) break;
            if (theListData.getNewList()) {
                int startPoint = nextItem < startOfNextList ? nextItem : startOfNextList;
                int delta = this.removeForcedSpaces(returnString, startPoint - 1, true);
                if (delta > 0) {
                    theChars = DoorsArtifactExtractor.stringBuilderToChars(returnString);
                    startPoint -= delta;
                    endOfList -= delta;
                }
                String theSublist = returnString.substring(0, startPoint);
                int end = theListData.getNextItem() - delta;
                if (theListData.getNextItem() != -1) {
                    theListData.setNextItem(end);
                }
                if (end >= returnString.length()) {
                    end = returnString.length() - 1;
                }
                String theRawSublist = new String(theChars, startPoint, end - startPoint + 1);
                int initialLen = theRawSublist.length();
                theRawSublist = this.processList(theRawSublist);
                theSublist = String.valueOf(theSublist) + theRawSublist;
                theSublist = String.valueOf(theSublist) + LIST_ITEM_END_TAG;
                delta = theRawSublist.length() - initialLen + LIST_ITEM_END_TAG.length();
                endOfList += delta;
                startOfNextList += delta;
                if (theListData.getNextItem() != -1 && theListData.getNextItem() < returnString.length() - 1) {
                    theSublist = String.valueOf(theSublist) + returnString.substring(theListData.getNextItem() + 1);
                }
                returnString.delete(0, returnString.length());
                returnString.append(theSublist);
            } else {
                if (isNumeric) {
                    currentNumber = Integer.valueOf(returnString.substring(nextItem, nextItem + theListData.getItemLength() - 1));
                } else {
                    currentLetter = returnString.substring(nextItem, nextItem + theListData.getItemLength() - 1);
                }
                returnString.delete(nextItem, nextItem + theListData.getItemLength());
                endOfList -= theListData.getItemLength();
                startOfNextList -= theListData.getItemLength();
                if (!lastWasSublist) {
                    String test;
                    int lastPoint;
                    int end = nextItem;
                    if (end > returnString.length()) {
                        end = returnString.length();
                    }
                    if ((lastPoint = (test = returnString.substring(0, end)).lastIndexOf(BR_TAG)) != -1) {
                        returnString.delete(lastPoint, end);
                        int delta = test.length() - lastPoint;
                        endOfList -= delta;
                        nextItem -= delta;
                        startOfNextList -= delta;
                    }
                }
                if (!lastWasSublist) {
                    returnString.insert(nextItem, LIST_ITEM_END_TAG);
                    if (nextItem < endOfList) {
                        endOfList += LIST_ITEM_END_TAG.length();
                        startOfNextList += LIST_ITEM_END_TAG.length();
                    }
                    nextItem += LIST_ITEM_END_TAG.length();
                }
                iPos = nextItem + 1;
            }
            theChars = DoorsArtifactExtractor.stringBuilderToChars(returnString);
        }
        String tokenToInsert = "</li></ol>";
        if (theListData.getNewList()) {
            tokenToInsert = "</ol>";
        }
        if (endOfList < returnString.length()) {
            returnString.insert(endOfList, tokenToInsert);
        } else {
            String test = returnString.toString();
            int lastPoint = test.lastIndexOf(BR_TAG);
            if (lastPoint == test.length() - BR_TAG.length()) {
                returnString.delete(lastPoint, returnString.length());
            }
            returnString.append(tokenToInsert);
        }
        return returnString.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private int[] findEndOfList(char[] theChars, int startPoint) {
        iPos = startPoint;
        v0 = new int[3];
        v0[1] = theChars.length;
        v0[2] = theChars.length;
        iReturn = v0;
        tagCount = 0;
        notFirst = false;
        foundNonTagItem = false;
        ** GOTO lbl61
        {
            ++iPos;
            do {
                block13: {
                    block12: {
                        block10: {
                            block11: {
                                if (iPos < theChars.length && (theChars[iPos] == '\t' || theChars[iPos] == '\n' || Character.isWhitespace(theChars[iPos]))) continue block0;
                                if (iPos >= theChars.length) {
                                    iReturn[1] = theChars.length;
                                    return iReturn;
                                }
                                if (theChars[iPos] != '<') break block10;
                                startofCloseTag = iPos++;
                                if (theChars[iPos] != '/') break block11;
                                --tagCount;
                                if (true) ** GOTO lbl37
                            }
                            ++tagCount;
                            ** GOTO lbl48
                        }
                        if (!notFirst) break block12;
                        if (!foundNonTagItem) {
                            iReturn[0] = iPos;
                            foundNonTagItem = true;
                        }
                        if (tagCount == 0) {
                            return iReturn;
                        }
                        ** GOTO lbl52
                    }
                    iPos = theChars.length;
                    break block13;
                    do {
                        ++iPos;
lbl37:
                        // 2 sources

                    } while (iPos < theChars.length && theChars[iPos] != '>');
                    if ((tagCount != 0 || !foundNonTagItem) && tagCount >= 0) ** GOTO lbl48
                    iReturn[1] = startofCloseTag;
                    iReturn[2] = iPos;
                    if (true) ** GOTO lbl44
                    do {
                        iReturn[2] = iReturn[2] + 1;
lbl44:
                        // 2 sources

                        if (iReturn[2] >= theChars.length) return iReturn;
                    } while (theChars[iReturn[2]] != '<');
                    return iReturn;
lbl-1000:
                    // 1 sources

                    {
                        ++iPos;
lbl48:
                        // 3 sources

                        ** while (iPos < theChars.length && theChars[iPos] != '>')
                    }
lbl49:
                    // 1 sources

                    ++iPos;
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        ++iPos;
lbl52:
                        // 2 sources

                        ** while (iPos < theChars.length && theChars[iPos] != '<')
                    }
lbl53:
                    // 1 sources

                    iReturn[1] = iPos - 1;
                    iReturn[2] = iPos;
                    while (iReturn[2] < theChars.length && theChars[iReturn[2]] != '>') {
                        iReturn[2] = iReturn[2] + 1;
                    }
                    iReturn[2] = iReturn[2] + 1;
                }
                notFirst = true;
lbl61:
                // 2 sources

            } while (iPos < theChars.length);
        }
        return iReturn;
    }

    static char[] stringBuilderToChars(StringBuilder sb) {
        char[] returnArray = new char[sb.length()];
        sb.getChars(0, sb.length(), returnArray, 0);
        return returnArray;
    }

    private int findNextListItem(char[] theChars, int iPos, boolean isNumeric, boolean isLowerCase, int currentNumber, String currentLetter, listData listData2) {
        if (++iPos >= theChars.length) {
            return -1;
        }
        StringBuilder asString = new StringBuilder();
        asString.append(theChars, iPos, theChars.length - iPos);
        int aListDot = asString.toString().toLowerCase().indexOf("a.");
        int aListParen = asString.toString().toLowerCase().indexOf("a.");
        int aList = -1;
        aList = aListDot == -1 ? aListParen : (aListParen == -1 ? aListDot : (aListDot < aListParen ? aListDot : aListParen));
        int oneListDot = asString.indexOf("1.");
        int oneListParen = asString.indexOf("1)");
        int oneList = -1;
        oneList = oneListDot == -1 ? oneListParen : (aListParen == -1 ? oneListDot : (oneListDot < oneListParen ? oneListDot : oneListParen));
        int nextListItem = -1;
        String nextItem = "";
        if (isNumeric) {
            nextItem = String.valueOf(Integer.toString(currentNumber + 1)) + ".";
        } else {
            byte[] theLetters = null;
            try {
                theLetters = currentLetter.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                theLetters = currentLetter.getBytes();
            }
            int theCharToChange = theLetters.length - 1;
            if (currentLetter.toLowerCase().charAt(theCharToChange) == 'z') {
                if (theCharToChange > 0) {
                    int n = theCharToChange - 1;
                    theLetters[n] = (byte)(theLetters[n] + 1);
                    theLetters[theCharToChange] = isLowerCase ? "a".getBytes()[0] : "A".getBytes()[0];
                } else {
                    byte[] newLetterArray = new byte[theLetters.length + 1];
                    int i = 0;
                    while (i < newLetterArray.length) {
                        newLetterArray[i] = isLowerCase ? "a".getBytes()[0] : "A".getBytes()[0];
                        ++i;
                    }
                    theLetters = newLetterArray;
                }
            } else {
                theLetters[0] = (byte)(theLetters[0] + 1);
            }
            nextItem = String.valueOf(new String(theLetters)) + ".";
        }
        nextListItem = asString.indexOf(nextItem);
        if (nextListItem != -1) {
            char prev = asString.charAt(nextListItem - 1);
            while (!Character.isWhitespace(prev) && prev != ';' && prev != '>') {
                if ((nextListItem = asString.indexOf(nextItem, nextListItem + 1)) == -1) break;
                prev = asString.charAt(nextListItem - 1);
            }
        }
        if (aList == -1 && oneList == -1 && nextListItem == -1) {
            return -1;
        }
        aList = aList != -1 ? aList + iPos : theChars.length + 1;
        oneList = oneList != -1 ? oneList + iPos : theChars.length + 1;
        nextListItem = nextListItem != -1 ? nextListItem + iPos : theChars.length + 1;
        int iReturn = aList < oneList ? aList : oneList;
        int n = iReturn = iReturn < nextListItem ? iReturn : nextListItem;
        if (iReturn == nextListItem) {
            listData2.setNewList(false);
            listData2.setItemLength(nextItem.length());
            listData2.setNextItem(nextListItem);
        } else {
            listData2.setNewList(true);
            listData2.setItemLength(2);
            listData2.setNextItem(nextListItem - 1);
        }
        return iReturn;
    }

    public void handleRequirement(String rowValue, RoughArtifact roughArtifact) {
        StringBuffer imageFileList = new StringBuffer("");
        this.appendToImageList(rowValue, imageFileList);
        rowValue = this.normalizeHtml(rowValue);
        String imageFile = imageFileList.toString();
        if (!imageFile.isEmpty()) {
            int comma = 0;
            int imageNumber = 0;
            do {
                String theImage;
                String replaceName = "";
                comma = imageFile.indexOf(44);
                if (comma == -1) {
                    theImage = String.valueOf(this.uriDirectoryName) + imageFile;
                    replaceName = imageFile;
                    imageFile = " ";
                } else {
                    theImage = String.valueOf(this.uriDirectoryName) + imageFile.substring(0, comma);
                    replaceName = imageFile.substring(0, comma);
                    imageFile = imageFile.substring(comma + 1);
                }
                try {
                    URI imageURI = new URI(theImage);
                    if (roughArtifact != null) {
                        roughArtifact.addAttribute(CoreAttributeTypes.ImageContent.getName(), imageURI);
                    }
                    rowValue = rowValue.replace(replaceName, IMAGE_BASE_NAME + Integer.toString(imageNumber));
                    ++imageNumber;
                    this.postProcessImages.add(imageURI.toASCIIString());
                }
                catch (URISyntaxException ex) {
                    if (roughArtifact == null) continue;
                    roughArtifact.getResults().error(ex.toString());
                }
            } while (comma != -1);
        }
        if (Strings.isValid((String)rowValue) && roughArtifact != null) {
            roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.HtmlContent, rowValue);
        }
    }

    public void processVerification(OrcsApi orcsApi, String column, RoughArtifact roughArtifact) {
        String trimmed = this.clearHTML(column);
        if (trimmed.trim().isEmpty()) {
            return;
        }
        int i = 0;
        while (i < VERIFICATION_KEYWORDS.length) {
            int iStart;
            if ((FIELD_TYPE[i] != null || VERIFICATION_KEYWORDS[i].equals(CRITERIA) || VERIFICATION_KEYWORDS[i].equals(VERIFICATION_ACCEPTANCE_CRITERIA)) && (iStart = trimmed.indexOf(VERIFICATION_KEYWORDS[i])) != -1) {
                boolean dataFound = true;
                String rest = trimmed.substring(iStart + VERIFICATION_KEYWORDS[i].length());
                dataFound = !(rest = rest.trim()).isEmpty();
                int j = 0;
                while (j < VERIFICATION_KEYWORDS.length && dataFound) {
                    dataFound = !rest.startsWith(VERIFICATION_KEYWORDS[j]);
                    ++j;
                }
                if (dataFound) {
                    int colon = rest.indexOf(58);
                    if (colon == -1) {
                        if (VERIFICATION_KEYWORDS[i].equals(CRITERIA) || VERIFICATION_KEYWORDS[i].equals(VERIFICATION_ACCEPTANCE_CRITERIA)) {
                            roughArtifact.addAttribute("Verification Acceptance Criteria", rest);
                        } else if (FIELD_TYPE[i].equals(CoreAttributeTypes.QualificationMethod)) {
                            this.parseAndStoreEnum(orcsApi, roughArtifact, rest, (AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
                        } else if (FIELD_TYPE[i].equals(CoreAttributeTypes.VerificationEvent)) {
                            this.parseAndStoreEnum(orcsApi, roughArtifact, rest, (AttributeTypeToken)CoreAttributeTypes.VerificationEvent);
                        } else {
                            roughArtifact.addAttribute(FIELD_TYPE[i], rest);
                        }
                    } else {
                        boolean foundKeyword = false;
                        int j2 = 0;
                        while (j2 < VERIFICATION_KEYWORDS.length) {
                            int index;
                            int theIndex = rest.indexOf(VERIFICATION_KEYWORDS[j2]);
                            if (theIndex != -1 && theIndex == colon - VERIFICATION_KEYWORDS[j2].length() + 1 && (index = rest.indexOf(VERIFICATION_KEYWORDS[j2])) >= 0) {
                                if (VERIFICATION_KEYWORDS[i].equals(CRITERIA) || VERIFICATION_KEYWORDS[i].equals(VERIFICATION_ACCEPTANCE_CRITERIA)) {
                                    roughArtifact.addAttribute("Verification Acceptance Criteria", rest.substring(0, index));
                                } else if (FIELD_TYPE[i].equals(CoreAttributeTypes.QualificationMethod)) {
                                    this.parseAndStoreEnum(orcsApi, roughArtifact, rest.substring(0, index), (AttributeTypeToken)CoreAttributeTypes.QualificationMethod);
                                } else if (FIELD_TYPE[i].equals(CoreAttributeTypes.VerificationEvent)) {
                                    this.parseAndStoreEnum(orcsApi, roughArtifact, rest.substring(0, index), (AttributeTypeToken)CoreAttributeTypes.VerificationEvent);
                                } else {
                                    roughArtifact.addAttribute(FIELD_TYPE[i], rest.substring(0, index));
                                }
                                foundKeyword = true;
                                break;
                            }
                            ++j2;
                        }
                        if (!foundKeyword) {
                            if (VERIFICATION_KEYWORDS[i].equals("Criteria:") || VERIFICATION_KEYWORDS[i].equals("Verification Acceptance Criteria:")) {
                                roughArtifact.addAttribute("Verification Acceptance Criteria", rest);
                            } else {
                                roughArtifact.addAttribute(FIELD_TYPE[i], rest);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void parseAndStoreEnum(OrcsApi orcsApi, RoughArtifact roughArtifact, String data, AttributeTypeToken type) {
        StringTokenizer theTokens = new StringTokenizer(data, " ");
        OrcsTypes orcsTypes = orcsApi.getOrcsTypes();
        EnumType enumType = orcsTypes.getAttributeTypes().getEnumType((AttributeTypeId)type);
        Set theValues = enumType.valuesAsOrderedStringSet();
        String singleItem = "";
        while (theTokens.hasMoreTokens()) {
            singleItem = String.valueOf(singleItem) + theTokens.nextToken();
            for (String item : theValues) {
                if (!item.equals(singleItem)) continue;
                roughArtifact.addAttribute(type, singleItem);
                singleItem = "";
                break;
            }
            if (!Strings.isValid((String)singleItem)) continue;
            singleItem = String.valueOf(singleItem) + " ";
        }
        if (Strings.isValid((String)singleItem)) {
            roughArtifact.addAttribute(type, singleItem);
        }
    }

    private void appendToImageList(String inputHTML, StringBuffer imageFileList) {
        String outputHtml = inputHTML;
        String Lower = outputHtml.toLowerCase();
        int img = Lower.indexOf("img ");
        imageFileList.setLength(0);
        boolean first = true;
        while (img != -1) {
            int src = Lower.indexOf("src=", img);
            if (src != -1) {
                char qte = Lower.charAt(src += 4);
                int iEnd = Lower.indexOf(qte, src + 1);
                if (first) {
                    imageFileList.append(inputHTML.substring(src + 1, iEnd));
                    first = false;
                } else {
                    imageFileList.append("," + inputHTML.substring(src + 1, iEnd));
                }
                img = Lower.indexOf("img ", src);
                continue;
            }
            img = -1;
        }
    }

    private String clearHTML(String input) {
        String returnValue = "";
        String processString = input;
        int openBracket = processString.indexOf(60);
        if (openBracket == -1) {
            returnValue = input;
        }
        while (openBracket >= 0) {
            int closeBracket;
            if (openBracket != 0) {
                returnValue = String.valueOf(returnValue) + processString.substring(0, openBracket) + " ";
            }
            if ((closeBracket = processString.indexOf(62)) > 0) {
                processString = processString.substring(closeBracket + 1);
            }
            openBracket = processString.indexOf(60);
        }
        returnValue = String.valueOf(returnValue) + processString;
        return returnValue;
    }

    private String normalizeHtml(String inputHtml) {
        String returnValue = this.preprocessHTML(inputHtml);
        returnValue = NormalizeHtml.convertToNormalizedHTML(returnValue, true, true, true);
        int bodyStart = returnValue.indexOf(BODY_START_TAG);
        int bodyEnd = returnValue.indexOf(BODY_END_TAG);
        if (bodyStart != -1) {
            bodyStart += BODY_START_TAG.length();
            bodyEnd = bodyEnd == -1 ? returnValue.length() - 1 : --bodyEnd;
            returnValue = bodyEnd <= bodyStart ? "" : returnValue.substring(bodyStart, bodyEnd);
        }
        int nameTag = returnValue.indexOf(NAME_TAG);
        while (nameTag != -1) {
            int endTag = returnValue.substring(nameTag).indexOf(62) + nameTag;
            if (endTag > nameTag) {
                endTag = returnValue.indexOf(CLOSING_A_TAG);
                returnValue = String.valueOf(returnValue.substring(0, nameTag - 1)) + returnValue.substring(endTag + CLOSING_A_TAG.length() + 1);
                nameTag = returnValue.indexOf(NAME_TAG);
                continue;
            }
            nameTag = -1;
        }
        returnValue = returnValue.trim();
        int brTag = returnValue.toLowerCase().lastIndexOf(BR_TAG);
        while (brTag != -1 && brTag == returnValue.length() - BR_TAG.length()) {
            returnValue = returnValue.substring(0, brTag).trim();
            brTag = returnValue.toLowerCase().lastIndexOf(BR_TAG);
        }
        returnValue = returnValue.replaceAll("<br />  ", "<br /> ");
        return returnValue;
    }

    private String preprocessHTML(String inputHTML) {
        String toReturn = inputHTML;
        toReturn = toReturn.replaceAll("\t", " ");
        toReturn = toReturn.replaceAll("<BR></BR>", "<BR />");
        toReturn = toReturn.replaceAll("<br></br>", BR_TAG);
        return toReturn;
    }

    private int removeForcedSpaces(StringBuilder returnString, int iPos, boolean reverse) {
        int adjust;
        block9: {
            adjust = 0;
            String nbsp = "&nbsp;";
            String tab = "&#9;";
            if (iPos <= 0) break block9;
            if (reverse) {
                char[] theChars = DoorsArtifactExtractor.stringBuilderToChars(returnString);
                while (Character.isWhitespace(theChars[iPos])) {
                    returnString.delete(iPos, iPos + 1);
                    --iPos;
                    ++adjust;
                }
                int nbspPos = returnString.lastIndexOf(nbsp, iPos);
                int tabPos = returnString.lastIndexOf(tab, iPos);
                while (nbspPos == iPos - nbsp.length() + 1 || tabPos == iPos - tab.length() + 1) {
                    if (nbspPos == iPos - nbsp.length() + 1) {
                        returnString.replace(nbspPos, nbspPos + nbsp.length(), "");
                        adjust += nbsp.length();
                        iPos -= nbsp.length();
                    } else {
                        returnString.replace(tabPos, tabPos + tab.length(), "");
                        adjust += tab.length();
                        iPos -= tab.length();
                    }
                    nbspPos = returnString.lastIndexOf(nbsp, iPos);
                    tabPos = returnString.lastIndexOf(tab, iPos);
                }
            } else {
                int nbspPos = returnString.indexOf(nbsp, iPos);
                int tabPos = returnString.indexOf(tab, iPos);
                while (nbspPos == iPos || tabPos == iPos) {
                    if (nbspPos == iPos) {
                        returnString.replace(nbspPos, nbspPos + nbsp.length(), "");
                        adjust += nbsp.length();
                    } else {
                        returnString.replace(tabPos, tabPos + tab.length(), "");
                        adjust += tab.length();
                    }
                    nbspPos = returnString.indexOf(nbsp, iPos);
                    tabPos = returnString.indexOf(tab, iPos);
                }
            }
        }
        return adjust;
    }

    private class listData {
        private boolean newList = false;
        private int itemLength = 0;
        private int nextItem;

        public int getItemLength() {
            return this.itemLength;
        }

        public int getNextItem() {
            return this.nextItem;
        }

        public boolean getNewList() {
            return this.newList;
        }

        public void setNextItem(int nextItem) {
            this.nextItem = nextItem;
        }

        public void setItemLength(int itemLength) {
            this.itemLength = itemLength;
        }

        public void setNewList(boolean newList) {
            this.newList = newList;
        }
    }
}

