/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.osee.define.api.DefineTupleTypes;
import org.eclipse.osee.define.rest.HistoryImportStrategy;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class FullHistoryTolerant
implements HistoryImportStrategy {
    protected final Map<String, ArtifactId> pathToCodeunitMap;
    private final TupleQuery tupleQuery;
    protected final ArtifactToken repoArtifact;
    protected final BranchId branch;
    protected final QueryFactory queryFactory;

    public FullHistoryTolerant(ArtifactToken repoArtifact, OrcsApi orcsApi, Map<String, ArtifactId> pathToCodeunitMap) {
        this.repoArtifact = repoArtifact;
        this.branch = repoArtifact.getBranch();
        this.queryFactory = orcsApi.getQueryFactory();
        this.tupleQuery = this.queryFactory.tupleQuery();
        this.pathToCodeunitMap = pathToCodeunitMap;
    }

    @Override
    public ArtifactId getCodeUnit(BranchId branch, TransactionBuilder tx, String commitSHA, DiffEntry.ChangeType changeType, String path, String newPath) {
        ArtifactId codeUnit = ArtifactId.SENTINEL;
        if (changeType == DiffEntry.ChangeType.MODIFY) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
        } else if (changeType == DiffEntry.ChangeType.ADD || changeType == DiffEntry.ChangeType.COPY) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, newPath);
            if (codeUnit.isValid()) {
                System.out.printf("commit [%s] adds code unit [%s] but found existing code unit [%s]\n", commitSHA, newPath, codeUnit);
                return ArtifactId.SENTINEL;
            }
            codeUnit = tx.createArtifact(CoreArtifactTypes.CodeUnit, newPath);
            this.pathToCodeunitMap.put(newPath, codeUnit);
        } else if (changeType == DiffEntry.ChangeType.DELETE) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
            if (codeUnit.isValid()) {
                tx.deleteArtifact(codeUnit);
                this.pathToCodeunitMap.remove(path);
            } else {
                System.out.printf("didn't find %s for deletion in commit %s\n", path, commitSHA);
            }
        } else if (changeType == DiffEntry.ChangeType.RENAME) {
            codeUnit = this.findCodeUnit((ArtifactId)this.repoArtifact, path);
            if (codeUnit.isValid()) {
                if (Strings.isValid((String)newPath)) {
                    tx.setName(codeUnit, newPath);
                    this.pathToCodeunitMap.remove(path);
                    this.pathToCodeunitMap.put(newPath, codeUnit);
                }
            } else {
                System.out.printf("didn't find in commit [%s] for rename from [%s] to [%s]\n", commitSHA, path, newPath);
                if (Strings.isValid((String)newPath)) {
                    codeUnit = tx.createArtifact(CoreArtifactTypes.CodeUnit, newPath);
                    this.pathToCodeunitMap.put(newPath, codeUnit);
                }
            }
        } else {
            System.out.printf("unexpected change type [%s] on path [%s]\n", changeType, path);
        }
        return codeUnit;
    }

    private ArtifactId findCodeUnit(ArtifactId repository, String path) {
        ArtifactId codeUnit = this.pathToCodeunitMap.get(path);
        if (codeUnit != null) {
            return codeUnit;
        }
        return ArtifactId.SENTINEL;
    }

    @Override
    public void handleCodeUnit(BranchId branch, ArtifactId codeUnit, TransactionBuilder tx, ArtifactId repository, ArtifactId commit, DiffEntry.ChangeType changeType) {
        tx.addTuple4(DefineTupleTypes.GitCommitFile, (Object)repository, (Object)codeUnit, (Object)commit, (Object)changeType);
        ArtifactId[] commitWraper = new ArtifactId[]{ArtifactId.SENTINEL};
        this.tupleQuery.getTuple4E3E4FromE1E2(DefineTupleTypes.GitLatest, branch, (Object)repository, (Object)codeUnit, (ignore, baselineCommit) -> {
            ArtifactId artifactId = baselineCommit;
        });
        tx.deleteTuple4ByE1E2(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit);
        tx.addTuple4(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit, (Object)commit, (Object)commitWraper[0]);
    }

    @Override
    public TransactionBuilder getTransactionBuilder(OrcsApi orcsApi, BranchId branch, UserId account) {
        return orcsApi.getTransactionFactory().createTransaction(branch, account, "TraceabilityOperationsImpl.parseGitHistory repo [" + this.repoArtifact.getIdString() + "]");
    }

    @Override
    public void finishGitCommit(TransactionBuilder tx) {
        tx.commit();
    }

    @Override
    public TransactionToken finishImport() {
        return TransactionToken.SENTINEL;
    }

    @Override
    public boolean hasChangeIdAlredyImported(String changeId) {
        return this.queryFactory.fromBranch(this.branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.GitChangeId, changeId).exists();
    }
}

