/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class SqlScriptFlywayCallback
implements FlywayCallback {
    private static final Log LOG = LogFactory.getLog(SqlScriptFlywayCallback.class);
    private final Map<String, SqlScript> scripts = new HashMap<String, SqlScript>();

    public SqlScriptFlywayCallback(DbSupport dbSupport, ClassLoader classLoader, Locations locations, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationSuffix) {
        Scanner scanner = new Scanner(classLoader);
        this.scripts.put("beforeClean", null);
        this.scripts.put("afterClean", null);
        this.scripts.put("beforeMigrate", null);
        this.scripts.put("afterMigrate", null);
        this.scripts.put("beforeEachMigrate", null);
        this.scripts.put("afterEachMigrate", null);
        this.scripts.put("beforeValidate", null);
        this.scripts.put("afterValidate", null);
        this.scripts.put("beforeBaseline", null);
        this.scripts.put("afterBaseline", null);
        this.scripts.put("beforeRepair", null);
        this.scripts.put("afterRepair", null);
        this.scripts.put("beforeInfo", null);
        this.scripts.put("afterInfo", null);
        for (Location location : locations.getLocations()) {
            Resource[] resources;
            try {
                resources = scanner.scanForResources(location, "", sqlMigrationSuffix);
            }
            catch (FlywayException e) {
                continue;
            }
            for (Resource resource : resources) {
                String key = resource.getFilename().replace(sqlMigrationSuffix, "");
                if (!this.scripts.keySet().contains(key)) continue;
                SqlScript existing = this.scripts.get(key);
                if (existing != null) {
                    throw new FlywayException("Found more than 1 SQL callback script for " + key + "!\n" + "Offenders:\n" + "-> " + existing.getResource().getLocationOnDisk() + "\n" + "-> " + resource.getLocationOnDisk());
                }
                this.scripts.put(key, new SqlScript(dbSupport, resource, placeholderReplacer, encoding));
            }
        }
    }

    @Override
    public void beforeClean(Connection connection) {
        this.execute("beforeClean", connection);
    }

    @Override
    public void afterClean(Connection connection) {
        this.execute("afterClean", connection);
    }

    @Override
    public void beforeMigrate(Connection connection) {
        this.execute("beforeMigrate", connection);
    }

    @Override
    public void afterMigrate(Connection connection) {
        this.execute("afterMigrate", connection);
    }

    @Override
    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
        this.execute("beforeEachMigrate", connection);
    }

    @Override
    public void afterEachMigrate(Connection connection, MigrationInfo info) {
        this.execute("afterEachMigrate", connection);
    }

    @Override
    public void beforeValidate(Connection connection) {
        this.execute("beforeValidate", connection);
    }

    @Override
    public void afterValidate(Connection connection) {
        this.execute("afterValidate", connection);
    }

    @Override
    public void beforeBaseline(Connection connection) {
        this.execute("beforeBaseline", connection);
    }

    @Override
    public void afterBaseline(Connection connection) {
        this.execute("afterBaseline", connection);
    }

    @Override
    public void beforeInit(Connection connection) {
    }

    @Override
    public void afterInit(Connection connection) {
    }

    @Override
    public void beforeRepair(Connection connection) {
        this.execute("beforeRepair", connection);
    }

    @Override
    public void afterRepair(Connection connection) {
        this.execute("afterRepair", connection);
    }

    @Override
    public void beforeInfo(Connection connection) {
        this.execute("beforeInfo", connection);
    }

    @Override
    public void afterInfo(Connection connection) {
        this.execute("afterInfo", connection);
    }

    private void execute(String key, Connection connection) {
        SqlScript sqlScript = this.scripts.get(key);
        if (sqlScript != null) {
            LOG.info("Executing SQL callback: " + key);
            sqlScript.execute(new JdbcTemplate(connection, 0));
        }
    }
}

