/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.XViewerUtil;
import org.eclipse.nebula.widgets.xviewer.core.util.XmlUtil;

public class SortingData {
    private static final String XTREESORTER_TAG = "xSorter";
    private static final String COL_NAME_TAG = "id";
    private static final String OLD_COL_NAME_TAG = "name";
    private final List<String> sortingIds = new ArrayList<String>();
    private final CustomizeData custData;
    private static Pattern pattern1 = Pattern.compile("<id>(.*?)</id>");
    private static Pattern pattern2 = Pattern.compile("<name>(.*?)</name>");

    public SortingData() {
        this.custData = null;
    }

    public SortingData(CustomizeData custData) {
        this.custData = custData;
    }

    public SortingData(String xml) {
        this.custData = null;
        this.setFromXml(xml);
    }

    public void clearSorter() {
        this.sortingIds.clear();
    }

    public boolean isSorting() {
        return this.sortingIds.size() > 0;
    }

    public List<XViewerColumn> getSortXCols(Map<String, XViewerColumn> oldNameToColumnId) {
        ArrayList<XViewerColumn> cols = new ArrayList<XViewerColumn>();
        for (String id : this.getSortingIds()) {
            XViewerColumn resolvedCol;
            XViewerColumn xCol = this.custData.getColumnData().getXColumn(id);
            if (xCol == null && (resolvedCol = oldNameToColumnId.get(id)) != null) {
                xCol = this.custData.getColumnData().getXColumn(resolvedCol.getId());
            }
            if (xCol == null) continue;
            cols.add(xCol);
        }
        return cols;
    }

    public void setSortXCols(List<XViewerColumn> sortXCols) {
        this.sortingIds.clear();
        for (XViewerColumn xCol : sortXCols) {
            this.sortingIds.add(XViewerUtil.intern(xCol.getId()));
        }
    }

    public String getXml() {
        StringBuffer sb = new StringBuffer("<xSorter>");
        for (String item : this.sortingIds) {
            sb.append(XmlUtil.addTagData(COL_NAME_TAG, item));
        }
        sb.append("</xSorter>");
        return sb.toString();
    }

    public void setFromXml(String xml) {
        this.sortingIds.clear();
        String xmlSortStr = XmlUtil.getTagData(xml, XTREESORTER_TAG);
        Matcher m = pattern1.matcher(xmlSortStr);
        while (m.find()) {
            this.sortingIds.add(m.group(1));
        }
        Matcher mOld = pattern2.matcher(xmlSortStr);
        while (mOld.find()) {
            this.sortingIds.add(mOld.group(1));
        }
    }

    public List<String> getSortingIds() {
        return this.sortingIds;
    }

    public void removeSortingName(String name) {
        this.sortingIds.remove(name);
    }

    public void addSortingName(String name) {
        if (!this.sortingIds.contains(name)) {
            this.sortingIds.add(XViewerUtil.intern(name));
        }
    }

    public void setSortingNames(String ... xViewerColumnId) {
        this.sortingIds.clear();
        String[] stringArray = xViewerColumnId;
        int n = xViewerColumnId.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.sortingIds.add(XViewerUtil.intern(id));
            ++n2;
        }
    }

    public String toString() {
        return "SortingData [sortIds=" + this.sortingIds + "]";
    }
}

