/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.OseeServerContext;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.HttpUrlBuilder;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractArtifactUrl {
    public URL getOpenInOseeLink(ArtifactToken artifact, String cmd, PresentationType presentationType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sessionId", this.getSessionId());
        parameters.put("context", "osee/loopback");
        parameters.put("id", artifact.getIdString());
        parameters.put("guid", artifact.getGuid());
        parameters.put("branchUuid", artifact.getBranch().getIdString());
        parameters.put("isDeleted", String.valueOf(this.isDeleted(artifact)));
        if (this.isHistorical(artifact) && presentationType != PresentationType.DIFF && presentationType != PresentationType.F5_DIFF) {
            parameters.put("transactionId", String.valueOf(this.getTransactionId(artifact)));
        }
        parameters.put("cmd", cmd);
        String urlString = this.getPermanentLinkBaseUrl(OseeServerContext.CLIENT_LOOPBACK_CONTEXT, parameters);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return url;
    }

    public abstract String getSessionId();

    public abstract Long getTransactionId(ArtifactToken var1);

    public abstract boolean isUseConnectedServerUrl();

    public URL getOpenInOseeLink(ArtifactToken artifact, PresentationType presentationType) {
        return this.getOpenInOseeLink(artifact, "open.artifact", presentationType);
    }

    public String getPermanentLinkBaseUrl(String context, Map<String, String> parameters) {
        try {
            return HttpUrlBuilder.createURL((String)this.getSelectedPermanentLinkUrl(), (String)context, parameters);
        }
        catch (UnsupportedEncodingException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public abstract String getSelectedPermanentLinkUrl();

    protected String normalize(String address) {
        String toReturn = address;
        if (Strings.isValid((String)toReturn) && !toReturn.endsWith("/")) {
            toReturn = String.valueOf(toReturn) + "/";
        }
        return toReturn;
    }

    protected abstract boolean isDeleted(ArtifactToken var1);

    protected abstract boolean isHistorical(ArtifactToken var1);

    protected abstract String getPermanentBaseUrl();
}

