/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.executor.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.framework.core.executor.ExecutionCallback;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.executor.internal.ExecutorCache;
import org.eclipse.osee.framework.core.executor.internal.OseeThreadFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.logger.Log;

public class ExecutorAdminImpl
implements ExecutorAdmin {
    public static final String DEFAULT_EXECUTOR = "default.executor";
    private final OseeThreadFactory threadFactory = new OseeThreadFactory();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(3, this.threadFactory);
    private ExecutorCache cache;
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    private Log getLogger() {
        return this.logger;
    }

    public void start(Map<String, ?> props) {
        this.logger.trace("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
        this.cache = new ExecutorCache();
    }

    public void stop(Map<String, ?> props) {
        this.logger.trace("Stopping [%s]...", new Object[]{this.getClass().getSimpleName()});
        for (Map.Entry<String, ListeningExecutorService> entry : this.cache.getExecutors().entrySet()) {
            this.shutdown(entry.getKey(), (ExecutorService)entry.getValue());
        }
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListeningExecutorService getExecutor(String id) {
        ListeningExecutorService service = null;
        ExecutorCache executorCache = this.cache;
        synchronized (executorCache) {
            service = this.cache.getById(id);
            if (service == null) {
                service = this.createExecutor(id, -1);
            }
        }
        if (service == null) {
            throw new OseeStateException("Error creating executor [%s].", new Object[]{id});
        }
        if (service.isShutdown() || service.isTerminated()) {
            throw new OseeStateException("Error executor [%s] was previously shutdown.", new Object[]{id});
        }
        return service;
    }

    @Override
    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.executor.submit(this.asRenamingCallable(name, task));
    }

    @Override
    public <T> Future<T> schedule(String id, Callable<T> callable, ExecutionCallback<T> callback) {
        ListenableFuture listenableFuture = this.getExecutor(id).submit(callable);
        if (callback != null) {
            FutureCallback<T> futureCallback = this.asFutureCallback(callback);
            Futures.addCallback((ListenableFuture)listenableFuture, futureCallback);
        }
        return listenableFuture;
    }

    private <T> FutureCallback<T> asFutureCallback(final ExecutionCallback<T> callback) {
        return new FutureCallback<T>(){

            public void onFailure(Throwable arg0) {
                if (arg0 instanceof CancellationException) {
                    callback.onCancelled();
                } else {
                    callback.onFailure(arg0);
                }
            }

            public void onSuccess(T arg0) {
                callback.onSuccess(arg0);
            }
        };
    }

    private ListeningExecutorService createExecutor(String id, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(String.valueOf(id) + "- [%s]").setPriority(5).build();
        ExecutorService executor = null;
        executor = poolSize > 0 ? Executors.newFixedThreadPool(poolSize, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.cache.put(id, listeningExecutor);
        return listeningExecutor;
    }

    private void shutdown(String id, ExecutorService executor) {
        try {
            executor.shutdown();
            boolean completed = false;
            try {
                completed = executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {}
            if (!completed) {
                executor.shutdownNow();
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Throwable)ex, "Error shutting down executor [%s]", new Object[]{id});
        }
    }

    @Override
    public void createFixedPoolExecutor(String id, int poolSize) {
        this.createExecutor(id, poolSize);
    }

    @Override
    public void shutdown(String id) {
        ListeningExecutorService service = this.cache.getById(id);
        if (service != null) {
            this.shutdown(id, (ExecutorService)service);
            this.cache.remove(id);
        }
    }

    private Runnable asRenamingRunnable(final String name, final Runnable task) {
        return new Runnable(){

            @Override
            public void run() {
                Thread thisThread = Thread.currentThread();
                String oldName = thisThread.getName();
                thisThread.setName(name);
                task.run();
                thisThread.setName(oldName);
            }
        };
    }

    private <T> Callable<T> asRenamingCallable(final String name, final Callable<T> task) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Thread thisThread = Thread.currentThread();
                String oldName = thisThread.getName();
                thisThread.setName(name);
                Object result = task.call();
                thisThread.setName(oldName);
                return result;
            }
        };
    }

    @Override
    public Future<?> submit(String name, Runnable task) {
        return this.executor.submit(this.asRenamingRunnable(name, task));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(String name, Runnable task, long initialDelay, long executionRate, TimeUnit timeUnit) {
        return this.executor.scheduleAtFixedRate(this.asRenamingRunnable(name, task), initialDelay, executionRate, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(String name, Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(this.asRenamingRunnable(name, task), initialDelay, delay, unit);
    }

    @Override
    public <T> Future<T> submitAndWait(String name, Callable<T> task, long timeout, TimeUnit unit) {
        Future<T> future = this.submit(name, task);
        try {
            future.get(timeout, unit);
        }
        catch (Exception exception) {
            this.logger.error("%s didn't complete in under %s %s", new Object[]{name, timeout, unit});
        }
        return future;
    }

    @Override
    public Future<?> submitAndWait(String name, Runnable task, long timeout, TimeUnit unit) {
        Future<?> future = this.submit(name, task);
        try {
            future.get(timeout, unit);
        }
        catch (Exception exception) {
            this.logger.error("%s didn't complete in under %s %s", new Object[]{name, timeout, unit});
        }
        return future;
    }
}

