/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;

public class UserTokenSerializer
extends StdSerializer<UserToken> {
    private static final long serialVersionUID = 1L;

    public UserTokenSerializer() {
        super(UserToken.class);
    }

    public void serialize(UserToken userToken, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        jgen.writeStringField("id", userToken.getIdString());
        jgen.writeStringField("name", userToken.getName());
        jgen.writeStringField("userId", userToken.getUserId());
        jgen.writeBooleanField("active", userToken.isActive());
        jgen.writeStringField("email", userToken.getEmail());
        jgen.writeArrayFieldStart("loginIds");
        for (String loginId : userToken.getLoginIds()) {
            jgen.writeString(loginId);
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("roles");
        for (ArtifactToken role : userToken.getRoles()) {
            jgen.writeStartObject();
            jgen.writeStringField("id", role.getIdString());
            jgen.writeStringField("name", role.getName());
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }

    public void serializeWithType(UserToken transaction, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar((Object)transaction, jgen);
        this.serialize(transaction, jgen, provider);
        typeSer.writeTypeSuffixForScalar((Object)transaction, jgen);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }
}

