/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserTokenSerializer;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Lib;

@JsonSerialize(using=UserTokenSerializer.class)
public interface UserToken
extends ArtifactToken,
UserId {
    @JsonCreator
    public static UserToken create(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="userId") String userId) {
        return UserToken.create((long)Lib.generateArtifactIdAsInt(), name, email, userId, true, new IUserGroupArtifactToken[0]);
    }

    public static UserToken create(long id, String name, String email, String userId, boolean active, IUserGroupArtifactToken ... roles) {
        return new UserTokenImpl(id, name, userId, active, email, Collections.singleton(userId), roles);
    }

    public static UserToken create(long id, String name, String email, String userId, boolean active, Collection<String> loginIds, IUserGroupArtifactToken ... roles) {
        return new UserTokenImpl(id, name, userId, active, email, loginIds, roles);
    }

    public String getUserId();

    public boolean isActive();

    public boolean isOseeAdmin();

    public String getEmail();

    public Collection<ArtifactToken> getRoles();

    public Collection<String> getLoginIds();

    public static final class UserTokenImpl
    extends NamedIdBase
    implements UserToken {
        private final String userId;
        private final boolean active;
        private final boolean admin;
        private final String email;
        private final Set<ArtifactToken> roles = new HashSet<ArtifactToken>();
        private final Collection<String> loginIds = new ArrayList<String>();

        public UserTokenImpl(long id, String name, String userId, boolean active, String email, Collection<String> loginIds, ArtifactToken ... roles) {
            super(Long.valueOf(id), name);
            this.userId = userId;
            this.active = active;
            this.email = email;
            this.loginIds.addAll(loginIds);
            this.roles.addAll(org.eclipse.osee.framework.jdk.core.util.Collections.asHashSet((Object[])roles));
            this.admin = Arrays.asList(roles).contains(CoreUserGroups.OseeAdmin);
        }

        @Override
        public ArtifactTypeToken getArtifactType() {
            return CoreArtifactTypes.User;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public boolean isOseeAdmin() {
            return this.admin;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public Collection<ArtifactToken> getRoles() {
            return this.roles;
        }

        public String toString() {
            return String.format("UserToken [name [%s], userId=[%s], active=[%s], email=[%s], loginIds=[%s], roles=[%s]", this.getName(), this.userId, this.active, this.email, this.getLoginIds(), this.getRoles());
        }

        @Override
        public BranchId getBranch() {
            return CoreBranches.COMMON;
        }

        @Override
        public Collection<String> getLoginIds() {
            return this.loginIds;
        }
    }
}

