/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeMultiplicity;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.OrcsTokenService;
import org.eclipse.osee.framework.core.data.RelationTypeToken;

public class OrcsTypeTokens {
    private final List<ArtifactTypeToken> artifactTypes = new ArrayList<ArtifactTypeToken>();
    private final List<AttributeTypeToken> attributeTypes = new ArrayList<AttributeTypeToken>();
    private final List<RelationTypeToken> relationTypes = new ArrayList<RelationTypeToken>();
    private final NamespaceToken namespace;

    public AttributeMultiplicity artifactType(Long id, String name, boolean isAbstract, ArtifactTypeToken ... superTypes) {
        return new AttributeMultiplicity(id, this.namespace, name, isAbstract, superTypes);
    }

    public OrcsTypeTokens() {
        this.namespace = NamespaceToken.OSEE;
    }

    public OrcsTypeTokens(NamespaceToken namespace) {
        this.namespace = namespace;
    }

    public List<AttributeTypeToken> getAttributeTypes() {
        return this.attributeTypes;
    }

    public ArtifactTypeToken add(AttributeMultiplicity attributeMultiplicity) {
        ArtifactTypeToken artifactType = attributeMultiplicity.get();
        this.artifactTypes.add(artifactType);
        return artifactType;
    }

    public <V, T extends AttributeTypeGeneric<V>> T add(T attributeType) {
        this.attributeTypes.add(attributeType);
        return attributeType;
    }

    public RelationTypeToken add(RelationTypeToken relationType) {
        this.relationTypes.add(relationType);
        return relationType;
    }

    public void registerTypes(OrcsTokenService tokenService) {
        this.artifactTypes.forEach(tokenService::registerArtifactType);
        this.attributeTypes.forEach(tokenService::registerAttributeType);
        this.relationTypes.forEach(tokenService::registerRelationType);
    }
}

