/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeMultiplicity;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public interface ArtifactTypeToken
extends NamedId,
ArtifactTypeId {
    public static final ArtifactTypeToken SENTINEL = ArtifactTypeToken.valueOf(Id.SENTINEL, "Sentinel", new ArtifactTypeToken[0]);

    public static ArtifactTypeToken valueOf(String id) {
        return ArtifactTypeToken.valueOf(Long.valueOf(id), "Sentinel", new ArtifactTypeToken[0]);
    }

    public static ArtifactTypeToken valueOf(long id, String name, ArtifactTypeToken ... superTypes) {
        return ArtifactTypeToken.create(id, NamespaceToken.OSEE, name, false, null, superTypes);
    }

    public boolean isAbstract();

    public List<ArtifactTypeToken> getSuperTypes();

    public static ArtifactTypeToken create(Long id, NamespaceToken namespace, String name, boolean isAbstract, AttributeMultiplicity attributeTypes, ArtifactTypeToken ... superTypes) {
        final class ArtifactTypeTokenImpl
        extends NamedIdBase
        implements ArtifactTypeToken {
            private final boolean isAbstract;
            private final List<ArtifactTypeToken> superTypes;
            private final AttributeMultiplicity attributeTypes;

            public ArtifactTypeTokenImpl(Long id, String name, boolean isAbstract, AttributeMultiplicity attributeTypes, ArtifactTypeToken ... superTypes) {
                super(id, name);
                this.isAbstract = isAbstract;
                this.superTypes = Arrays.asList(superTypes);
                this.attributeTypes = attributeTypes;
                if (superTypes.length > 1 && this.superTypes.contains(CoreArtifactTypes.Artifact)) {
                    throw new OseeArgumentException("Multiple super types for artifact type [%s] and and supertype Artifact", new Object[]{name});
                }
                ArtifactTypeToken[] artifactTypeTokenArray = superTypes;
                int n = superTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactTypeToken superType = artifactTypeTokenArray[n2];
                    attributeTypes.putAll(((ArtifactTypeTokenImpl)superType).attributeTypes);
                    ++n2;
                }
            }

            @Override
            public boolean isAbstract() {
                return this.isAbstract;
            }

            @Override
            public List<ArtifactTypeToken> getSuperTypes() {
                return this.superTypes;
            }
        }
        return new ArtifactTypeTokenImpl(id, name, isAbstract, attributeTypes, superTypes);
    }
}

