/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.internal.types.impl.RelationTypeIndex;
import org.eclipse.osee.orcs.data.RelationTypes;

public class RelationTypesImpl
implements RelationTypes {
    private final RelationTypeIndexProvider provider;

    public RelationTypesImpl(RelationTypeIndexProvider provider) {
        this.provider = provider;
    }

    private XRelationType getType(RelationTypeId type) {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        return (XRelationType)this.provider.getRelationTypeIndex().getDslTypeByToken((Id)type);
    }

    public Collection<RelationTypeToken> getAll() {
        return this.provider.getRelationTypeIndex().getAllTokens();
    }

    public RelationTypeToken get(Id id) {
        if (id instanceof RelationTypeToken) {
            return (RelationTypeToken)id;
        }
        return (RelationTypeToken)this.provider.getRelationTypeIndex().get(id);
    }

    public RelationTypeToken get(Long id) {
        return (RelationTypeToken)this.provider.getRelationTypeIndex().get(id);
    }

    public RelationTypeMultiplicity getMultiplicity(RelationTypeId relation) {
        XRelationType type = this.getType(relation);
        String multiplicityId = type.getMultiplicity().getName();
        RelationTypeMultiplicity multiplicity = RelationTypeMultiplicity.getFromString((String)multiplicityId);
        return multiplicity;
    }

    public String getSideName(IRelationType relation, RelationSide relationSide) {
        Conditions.checkNotNull((Object)relationSide, (String)"relationSide");
        return relationSide == RelationSide.SIDE_A ? this.getSideAName(relation) : this.getSideBName(relation);
    }

    public String getSideAName(IRelationType relation) {
        XRelationType type = this.getType((RelationTypeId)relation);
        return type.getSideAName();
    }

    public String getSideBName(IRelationType relation) {
        XRelationType type = this.getType((RelationTypeId)relation);
        return type.getSideBName();
    }

    public boolean isSideAName(IRelationType relation, String sideName) {
        XRelationType type = this.getType((RelationTypeId)relation);
        boolean isSideA = type.getSideAName().equals(sideName);
        if (!isSideA && !type.getSideBName().equals(sideName)) {
            throw new OseeArgumentException("sideName does not match either of the available side names", new Object[0]);
        }
        return isSideA;
    }

    public boolean isOrdered(IRelationType relation) {
        return !RelationSorter.UNORDERED.equals((Object)this.getDefaultOrderTypeGuid(relation));
    }

    public RelationSorter getDefaultOrderTypeGuid(IRelationType relation) {
        XRelationType type = this.getType((RelationTypeId)relation);
        return RelationSorter.valueOfName((String)type.getDefaultOrderType());
    }

    public ArtifactTypeId getArtifactTypeSideA(IRelationType relation) {
        return this.getArtifactType((RelationTypeId)relation, RelationSide.SIDE_A);
    }

    public ArtifactTypeId getArtifactTypeSideB(IRelationType relation) {
        return this.getArtifactType((RelationTypeId)relation, RelationSide.SIDE_B);
    }

    public ArtifactTypeId getArtifactType(RelationTypeId relation, RelationSide relationSide) {
        Conditions.checkNotNull((Object)relation, (String)"relationType");
        Conditions.checkNotNull((Object)relationSide, (String)"relationSide");
        return this.provider.getRelationTypeIndex().getArtifactType(relation, relationSide);
    }

    public boolean isArtifactTypeAllowed(RelationTypeId relation, RelationSide relationSide, ArtifactTypeId artifactType) {
        Conditions.checkNotNull((Object)relation, (String)"relationType");
        Conditions.checkNotNull((Object)relationSide, (String)"relationSide");
        Conditions.checkNotNull((Object)artifactType, (String)"artifactType");
        return this.provider.getRelationTypeIndex().isArtifactTypeAllowed(relation, relationSide, artifactType);
    }

    public boolean isEmpty() {
        return this.provider.getRelationTypeIndex().isEmpty();
    }

    public int size() {
        return this.provider.getRelationTypeIndex().size();
    }

    public boolean exists(Id id) {
        return this.provider.getRelationTypeIndex().exists(id);
    }

    public static interface RelationTypeIndexProvider {
        public RelationTypeIndex getRelationTypeIndex();
    }
}

