/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumType;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.internal.types.impl.AttributeTypeIndex;
import org.eclipse.osee.orcs.core.internal.types.impl.EnumTypeIndex;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.data.EnumType;

public class AttributeTypesImpl
implements AttributeTypes {
    private static final String ATTRIBUTE_OCCURRENCE_UNLIMITED = "unlimited";
    private final AttributeTypeIndexProvider provider;
    private final EnumTypeIndexProvider enumTypeIndexProvider;

    public AttributeTypesImpl(AttributeTypeIndexProvider provider, EnumTypeIndexProvider enumTypeIndexProvider) {
        this.provider = provider;
        this.enumTypeIndexProvider = enumTypeIndexProvider;
    }

    private XAttributeType getType(AttributeTypeId attributeType) {
        return (XAttributeType)this.provider.getAttributeTypeIndex().getDslTypeByToken((Id)attributeType);
    }

    public Collection<AttributeTypeToken> getAll() {
        return this.provider.getAttributeTypeIndex().getAllTokens();
    }

    public AttributeTypeToken get(Id id) {
        return (AttributeTypeToken)this.provider.getAttributeTypeIndex().get(id);
    }

    public AttributeTypeToken get(Long id) {
        return (AttributeTypeToken)this.provider.getAttributeTypeIndex().get(id);
    }

    public String getBaseAttributeTypeId(AttributeTypeId attributeType) {
        return this.getType(attributeType).getBaseAttributeType();
    }

    public String getAttributeProviderId(AttributeTypeId attrType) {
        return this.getType(attrType).getDataProvider();
    }

    public String getDefaultValue(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        return type.getDefaultValue();
    }

    public int getMaxOccurrences(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        String maxValue = type.getMax();
        int max = Integer.MAX_VALUE;
        if (!ATTRIBUTE_OCCURRENCE_UNLIMITED.equals(maxValue) && Strings.isValid((String)maxValue)) {
            max = Integer.parseInt(maxValue);
        }
        return max;
    }

    public int getMinOccurrences(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        String minValue = type.getMin();
        int min = 0;
        if (Strings.isValid((String)minValue)) {
            min = Integer.parseInt(minValue);
        }
        return min;
    }

    public String getFileTypeExtension(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        String value = type.getFileExtension();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public TaggerTypeToken getTaggerId(AttributeTypeId attributeType) {
        String taggerId = this.getType(attributeType).getTaggerId();
        if ("DefaultAttributeTaggerProvider".equals(taggerId)) {
            return TaggerTypeToken.PlainTextTagger;
        }
        if ("XmlAttributeTaggerProvider".equals(taggerId)) {
            return TaggerTypeToken.XmlTagger;
        }
        return TaggerTypeToken.SENTINEL;
    }

    public boolean isTaggable(AttributeTypeId attributeType) {
        return this.getTaggerId(attributeType).isValid();
    }

    public boolean isEnumerated(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        XOseeEnumType enumType = type.getEnumType();
        return enumType != null;
    }

    public EnumType getEnumType(AttributeTypeId attrType) {
        EnumType toReturn = null;
        XAttributeType type = this.getType(attrType);
        XOseeEnumType enumType = type.getEnumType();
        if (enumType != null) {
            toReturn = (EnumType)this.enumTypeIndexProvider.getEnumTypeIndex().getTokenByDslType(enumType);
        }
        return toReturn;
    }

    public String getDescription(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        String value = type.getDescription();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public boolean isEmpty() {
        return this.provider.getAttributeTypeIndex().isEmpty();
    }

    public int size() {
        return this.provider.getAttributeTypeIndex().size();
    }

    public Collection<AttributeTypeId> getAllTaggable() {
        return this.provider.getAttributeTypeIndex().getAllTaggable();
    }

    public boolean exists(Id id) {
        return this.provider.getAttributeTypeIndex().exists(id);
    }

    public String getMediaType(AttributeTypeId attrType) {
        XAttributeType type = this.getType(attrType);
        String value = type.getMediaType();
        return Strings.isValid((String)value) ? value : Strings.emptyString();
    }

    public boolean hasMediaType(AttributeTypeId attrType) {
        boolean toReturn = false;
        String mediaType = this.getMediaType(attrType);
        if (mediaType != null) {
            toReturn = Strings.isValid((String)mediaType.trim());
        }
        return toReturn;
    }

    public boolean isBooleanType(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("boolean");
    }

    public boolean isIntegerType(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("integer");
    }

    public boolean isDateType(AttributeTypeId attributeType) {
        String baseType = this.getBaseAttributeTypeId(attributeType);
        return baseType != null && baseType.toLowerCase().contains("date");
    }

    public boolean isStringType(AttributeTypeId attributeType) {
        String baseType = this.getBaseAttributeTypeId(attributeType);
        return baseType != null && baseType.endsWith("StringAttribute");
    }

    public boolean isLongType(AttributeTypeId attributeType) {
        String baseType = this.getBaseAttributeTypeId(attributeType);
        return baseType != null && baseType.toLowerCase().contains("long");
    }

    public boolean isFloatingType(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.toLowerCase().contains("floatingpoint");
    }

    public boolean isArtifactReferencedAttribute(AttributeTypeId attrType) {
        String baseType = this.getBaseAttributeTypeId(attrType);
        return baseType != null && baseType.endsWith("ArtifactReferenceAttribute");
    }

    public AttributeTypeToken getByName(String attrTypeName) {
        for (AttributeTypeToken type : this.getAll()) {
            if (!type.getName().equals(attrTypeName)) continue;
            return type;
        }
        throw new OseeTypeDoesNotExist("AttributeTypeToken does not exist: %s", new Object[]{attrTypeName});
    }

    public boolean typeExists(String attrTypeName) {
        for (AttributeTypeToken type : this.getAll()) {
            if (!type.getName().equals(attrTypeName)) continue;
            return true;
        }
        return false;
    }

    public boolean typeExists(AttributeTypeId attrTypeId) {
        for (AttributeTypeToken type : this.getAll()) {
            if (!type.equals(attrTypeId)) continue;
            return true;
        }
        return false;
    }

    public static interface AttributeTypeIndexProvider {
        public AttributeTypeIndex getAttributeTypeIndex();
    }

    public static interface EnumTypeIndexProvider {
        public EnumTypeIndex getEnumTypeIndex();
    }
}

