/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.script.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BinaryDataProxy;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.DynamicData;
import org.eclipse.osee.orcs.core.ds.DynamicObject;
import org.eclipse.osee.orcs.core.ds.LoadDescription;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.SelectSet;
import org.eclipse.osee.orcs.core.internal.script.OrcsScriptOutputHandler;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;

public class ExcelOutputHandler
extends OrcsScriptOutputHandler {
    private static String OUTPUT_SCRIPT = "output.script";
    private static String OUTPUT_DEBUG = "output.debug";
    private final ScriptContext context;
    private ISheetWriter writer = null;
    private List<Throwable> errors;
    private DebugInfo debugInfo;
    private boolean isDebugModeEnabled;
    private boolean isScriptOutputEnabled;
    private int queriesRun = 1;
    private int numSheets;
    private int querySheetNum;
    private final HeaderCollector headers = new HeaderCollector();
    private final List<Map<String, Object>> providedData = new LinkedList<Map<String, Object>>();

    public ExcelOutputHandler(ScriptContext context) {
        Conditions.checkNotNull((Object)context, (String)"Context");
        this.context = context;
    }

    private void initalizeData() {
        this.isScriptOutputEnabled = true;
        this.numSheets = -1;
        this.querySheetNum = -1;
        Object debug = this.context.getAttribute(OUTPUT_DEBUG);
        this.isDebugModeEnabled = Boolean.parseBoolean(String.valueOf(debug));
        Object outputScript = this.context.getAttribute(OUTPUT_SCRIPT);
        if (outputScript != null) {
            this.isScriptOutputEnabled = this.isDebugModeEnabled || Boolean.parseBoolean(String.valueOf(outputScript));
        }
        this.debugInfo = this.isDebugModeEnabled ? new DebugInfo() : null;
        this.errors = null;
    }

    @Override
    public void onEvalStart() {
        super.onEvalStart();
        this.initalizeData();
        try {
            this.writer = new ExcelXmlWriter(this.context.getWriter());
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onError(Throwable th) {
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        this.errors.add(th);
    }

    @Override
    public void onCompileStart(OrcsScript model) {
        super.onCompileStart(model);
        if (this.isScriptOutputEnabled) {
            try {
                this.writer.startSheet("script", 4);
                ++this.numSheets;
                this.writeScriptData(model);
                this.writer.endSheet();
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
    }

    @Override
    public void onExecutionStart(String version) {
        super.onExecutionStart(version);
        if (this.isDebugModeEnabled) {
            this.debugInfo.setScriptVersion(version);
        }
    }

    @Override
    public void onQueryStart(QueryData data) {
        super.onQueryStart(data);
        if (this.isDebugModeEnabled) {
            this.debugInfo.addQuery(data);
        }
    }

    @Override
    public void onLoadStart() {
        super.onLoadStart();
        this.providedData.clear();
        this.headers.clear();
    }

    @Override
    public void onLoadDescription(LoadDescription data) {
        super.onLoadDescription(data);
        if (this.debugInfo != null) {
            this.debugInfo.addDescription(data);
        }
    }

    @Override
    public void onDynamicData(Map<String, Object> data) {
        super.onDynamicData(data);
        this.headers.process(data);
        this.providedData.add(data);
    }

    @Override
    public void onLoadEnd() {
        super.onLoadEnd();
        try {
            try {
                this.writeData();
            }
            finally {
                this.writer.endSheet();
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private void writeData() {
        this.startSheet();
        for (Map<String, Object> item : this.providedData) {
            try {
                try {
                    this.writeDataMap(item, 0);
                }
                finally {
                    this.writer.endRow();
                }
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
    }

    private void startSheet() {
        try {
            try {
                this.writer.startSheet("Query " + Integer.toString(this.queriesRun++), this.headers.size());
                ++this.numSheets;
                this.querySheetNum = this.numSheets;
                for (String s : this.headers.getHeaders()) {
                    this.writer.writeCell((Object)s);
                }
            }
            finally {
                this.writer.endRow();
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    @Override
    public void onEvalEnd() {
        super.onEvalEnd();
        if (this.writer != null) {
            try {
                try {
                    this.writeErrors();
                    this.writeDebug();
                    if (this.querySheetNum >= 0) {
                        this.writer.setActiveSheet(this.querySheetNum);
                    }
                }
                finally {
                    this.writer.endWorkbook();
                }
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
    }

    private void writeDataMap(Map<String, Object> data, int level) {
        Set<String> keys = data.keySet();
        try {
            for (String key : keys) {
                int columnIndex;
                Object entry = data.get(key);
                if (entry instanceof Map) {
                    this.writeMapEntry((Map)entry, key, level);
                    continue;
                }
                if (entry instanceof Set) {
                    columnIndex = this.headers.getColumnIndex(level, key);
                    Object setTypeCheck = ((Set)entry).iterator().next();
                    if (setTypeCheck instanceof Map) {
                        this.writeSetEntry((Iterable)entry, columnIndex);
                        continue;
                    }
                    throw new OseeCoreException("unknown data type in Set output", new Object[]{setTypeCheck});
                }
                columnIndex = this.headers.getColumnIndex(level, key);
                this.writer.writeCell((Object)entry.toString(), columnIndex);
            }
            if (level == this.headers.columnGroups.size()) {
                this.writer.endRow();
            }
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private String getValidContent(Object data) {
        StringBuilder toReturn = new StringBuilder();
        if (data instanceof BinaryDataProxy) {
            toReturn.append("binary data");
        } else if (data instanceof CharacterDataProxy) {
            toReturn.append(this.convertCharacterProxyData((CharacterDataProxy)data));
        } else {
            toReturn.append(AXml.textToXml((String)data.toString()));
        }
        return toReturn.toString();
    }

    private String convertCharacterProxyData(CharacterDataProxy dp) {
        String toWrite = dp.getValueAsString();
        return AXml.textToXml((String)toWrite);
    }

    private void writeMapEntry(Map<String, Object> data, String key, int level) throws IOException {
        if (data.size() > 1) {
            this.writeDataMap(data, level + 1);
        } else {
            Object value = data.values().iterator().next();
            if (value instanceof Map) {
                this.writeDataMap(data, level + 1);
            } else {
                int columnIndex = this.headers.getColumnIndex(level, key);
                String toWrite = this.getValidContent(value);
                this.writer.writeCell((Object)toWrite, columnIndex);
            }
        }
    }

    private void writeSetEntry(Iterable<Map<String, Object>> data, int column) throws IOException {
        StringBuilder combined = new StringBuilder();
        boolean first = true;
        for (Map<String, Object> content : data) {
            for (Object value : content.values()) {
                if (!first) {
                    combined.append(", ");
                }
                first = false;
                combined.append(this.getValidContent(value));
            }
        }
        this.writer.writeCell((Object)combined.toString(), column);
    }

    private void writeScriptData(OrcsScript model) throws IOException {
        Map binding = OrcsScriptUtil.getBinding((EObject)model);
        if (binding != null && !binding.isEmpty()) {
            this.writer.writeCell((Object)"parameters:");
            this.writer.endRow();
            for (Map.Entry entry : binding.entrySet()) {
                this.writer.writeCell(entry.getKey());
                this.writer.writeCell((Object)String.valueOf(entry.getValue()));
                this.writer.endRow();
            }
        }
        this.writer.writeCell((Object)"script:");
        this.writer.endRow();
        String value = "N/A";
        try {
            if (model != null && model.eAllContents().hasNext()) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OrcsScriptUtil.saveModel((OrcsScript)model, (String)"orcs:/unknown.orcs", (OutputStream)outputStream, (OrcsScriptUtil.OsStorageOption[])new OrcsScriptUtil.OsStorageOption[]{OrcsScriptUtil.OsStorageOption.NO_VALIDATION_ON_SAVE});
                value = outputStream.toString("UTF-8");
            }
        }
        catch (Exception ex) {
            value = ex.getMessage();
        }
        this.writer.writeCell((Object)value);
        this.writer.endRow();
    }

    private void writeErrors() throws IOException {
        if (this.errors != null && !this.errors.isEmpty()) {
            Writer errorWriter = this.context.getErrorWriter();
            if (errorWriter != null && errorWriter != this.context.getWriter()) {
                for (Throwable th : this.errors) {
                    errorWriter.write(Lib.exceptionToString((Throwable)th));
                }
            } else {
                this.writer.startSheet("errors", 1);
                ++this.numSheets;
                this.writer.writeCell((Object)"errors:");
                this.writer.endRow();
                for (Throwable th : this.errors) {
                    this.writer.writeCell((Object)Lib.exceptionToString((Throwable)th));
                    this.writer.endRow();
                }
                this.writer.endSheet();
            }
        }
    }

    private void writeDebug() throws IOException {
        if (this.debugInfo != null) {
            List<LoadDescription> descriptions = this.debugInfo.getDescriptions();
            this.writer.startSheet("Debug", 2);
            ++this.numSheets;
            this.writer.writeCell((Object)"debug:");
            this.writer.endRow();
            this.writer.writeCell((Object)("script-version: " + this.debugInfo.getScriptVersion()));
            this.writer.endRow();
            List<QueryData> queries = this.debugInfo.getQueries();
            int index = 0;
            while (index < descriptions.size()) {
                this.writer.writeCell((Object)("query_" + index));
                this.writer.endRow();
                LoadDescription description = descriptions.get(index);
                OrcsSession session = description.getSession();
                if (session != null) {
                    this.writer.writeCell((Object)"session");
                    this.writer.writeCell(session.getGuid());
                    this.writer.endRow();
                }
                Options options = description.getOptions();
                for (String key : new TreeSet<String>(options.getKeys())) {
                    this.writer.writeCell((Object)key);
                    this.writer.writeCell((Object)options.get(key).replaceAll("\\s+", " "));
                    this.writer.endRow();
                }
                this.writeQuery(queries.get(index));
                ++index;
            }
            this.writer.endSheet();
        }
    }

    private void writeQuery(QueryData queryData) throws IOException {
        List<List<Criteria>> criteriaSets = queryData.getCriteriaSets();
        List<SelectSet> selectSets = queryData.getSelectSets();
        this.writer.writeCell((Object)"query:");
        this.writer.endRow();
        int index = 0;
        while (index < criteriaSets.size()) {
            this.writer.writeCell((Object)"level");
            this.writer.writeCell((Object)index);
            this.writer.endRow();
            this.writeCriterias(criteriaSets.get(index));
            this.writeCollect(selectSets.get(index));
            ++index;
        }
        this.writer.endRow();
    }

    private void writeCriterias(List<Criteria> criteriaSet) throws IOException {
        this.writer.writeCell((Object)"criteria:");
        if (criteriaSet.size() == 0) {
            this.writer.writeCell((Object)"none");
            this.writer.endRow();
        } else {
            this.writer.endRow();
            for (Criteria criteria : criteriaSet) {
                String value = criteria.toString();
                this.writer.writeCell((Object)value);
                this.writer.endRow();
            }
        }
    }

    private void writeCollect(SelectSet selectSet) throws IOException {
        this.writer.writeCell((Object)"collect:");
        this.writer.endRow();
        this.writer.writeCell((Object)"limit:");
        this.writer.writeCell((Object)selectSet.getLimit());
        this.writer.endRow();
        this.writeDynamicData(selectSet.getData());
    }

    private void writeDynamicData(DynamicData data) throws IOException {
        if (data != null) {
            if (data instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)data;
                if (obj.hasChildren()) {
                    this.writer.writeCell((Object)data.getName());
                    this.writer.endRow();
                    for (DynamicData child : obj.getChildren()) {
                        this.writeDynamicData(child);
                    }
                }
            } else {
                StringBuilder value = new StringBuilder();
                if (data.isHidden()) {
                    value.append("hidden->");
                }
                value.append((String)data.getGuid());
                if (data.isPrimaryKey()) {
                    value.append("*");
                }
                this.writer.writeCell((Object)(String.valueOf(data.getName()) + ":"));
                this.writer.writeCell((Object)value.toString());
                this.writer.endRow();
            }
        }
    }

    private static final class DebugInfo {
        public String scriptVersion;
        public final List<LoadDescription> descriptions = new ArrayList<LoadDescription>();
        private final List<QueryData> queries = new ArrayList<QueryData>();

        private DebugInfo() {
        }

        public void setScriptVersion(String version) {
            this.scriptVersion = version;
        }

        public void addDescription(LoadDescription data) {
            this.descriptions.add(data);
        }

        public void addQuery(QueryData queryData) {
            this.queries.add(queryData);
        }

        public String getScriptVersion() {
            return this.scriptVersion;
        }

        public List<LoadDescription> getDescriptions() {
            return this.descriptions;
        }

        public List<QueryData> getQueries() {
            return this.queries;
        }
    }

    private static final class HeaderCollector {
        private final List<List<String>> columnGroups = new ArrayList<List<String>>();
        private volatile int totalSize = -1;

        private HeaderCollector() {
        }

        public void clear() {
            this.columnGroups.clear();
            this.totalSize = -1;
        }

        public void process(Map<String, Object> data) {
            this.processHelper(data, 0);
            this.totalSize = -1;
        }

        private void processHelper(Map<String, Object> data, int index) {
            List<String> columns;
            if (index >= this.columnGroups.size()) {
                columns = new ArrayList<String>(data.keySet());
                this.columnGroups.add(columns);
            } else {
                columns = this.columnGroups.get(index);
                for (String attributes : data.keySet()) {
                    if (columns.contains(attributes)) continue;
                    columns.add(attributes);
                }
            }
            for (Object item : data.values()) {
                if (!(item instanceof Map)) continue;
                Map child = (Map)item;
                if (child.size() > 1) {
                    this.processHelper(child, index + 1);
                    continue;
                }
                if (!(child.values().iterator().next() instanceof Map)) continue;
                this.processHelper(child, index + 1);
            }
        }

        public int size() {
            if (this.totalSize < 0) {
                this.totalSize = 0;
                for (Collection collection : this.columnGroups) {
                    this.totalSize += collection.size();
                }
            }
            return this.totalSize;
        }

        public Iterable<String> getHeaders() {
            ArrayList<String> headings = new ArrayList<String>();
            for (Collection collection : this.columnGroups) {
                for (String value : collection) {
                    headings.add(value);
                }
            }
            return headings;
        }

        public int getColumnIndex(int index, String key) {
            List<String> columns;
            int position = 0;
            try {
                int i = 0;
                while (i < index) {
                    position += this.columnGroups.get(i).size();
                    ++i;
                }
                columns = this.columnGroups.get(index);
            }
            catch (Exception exception) {
                throw new OseeCoreException("Invalid index: %d getting column heading position for %s", new Object[]{index, key});
            }
            return position += columns.indexOf(key);
        }
    }
}

