/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationResolver;
import org.eclipse.osee.orcs.core.internal.relation.RelationTypeValidity;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderManager;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderManagerFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.util.OrcsConditions;
import org.eclipse.osee.orcs.data.RelationTypes;

public class RelationManagerImpl
implements RelationManager {
    private final Log logger;
    private final RelationTypeValidity validity;
    private final RelationResolver resolver;
    private final RelationFactory relationFactory;
    private final OrderManagerFactory orderFactory;
    private final RelationTypes relationTypes;

    public RelationManagerImpl(Log logger, RelationTypeValidity validity, RelationResolver resolver, RelationFactory relationFactory, OrderManagerFactory orderFactory, QueryModule.QueryModuleProvider queryProvider, RelationTypes relationTypes) {
        this.logger = logger;
        this.validity = validity;
        this.resolver = resolver;
        this.relationFactory = relationFactory;
        this.orderFactory = orderFactory;
        this.relationTypes = relationTypes;
    }

    @Override
    public int getMaximumRelationAllowed(RelationTypeId type, Artifact node, RelationSide side) {
        Conditions.checkNotNull((Object)node, (String)"node");
        return this.validity.getMaximumRelationsAllowed(type, (ArtifactTypeId)node.getArtifactType(), side);
    }

    @Override
    public Collection<RelationTypeId> getValidRelationTypes(Artifact node) {
        Conditions.checkNotNull((Object)node, (String)"node");
        return this.validity.getValidRelationTypes((ArtifactTypeId)node.getArtifactType());
    }

    @Override
    public void accept(GraphData graph, Artifact node, RelationVisitor visitor) {
        OrcsConditions.checkOnGraph(graph, node);
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        if (container != null) {
            container.accept(visitor);
        } else {
            this.logger.warn("Unable to find relation container for [%s]", new Object[]{node.getExceptionString()});
        }
    }

    @Override
    public boolean hasDirtyRelations(Artifact node) {
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        return container != null ? container.hasDirty() : false;
    }

    @Override
    public Collection<RelationTypeId> getExistingRelationTypes(Artifact node) {
        Conditions.checkNotNull((Object)node, (String)"node");
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        Collection<RelationTypeId> toReturn = null;
        if (container != null) {
            toReturn = container.getExistingTypes(DeletionFlag.EXCLUDE_DELETED);
        } else {
            this.logger.warn("Unable to find relation container for [%s]", new Object[]{node.getExceptionString()});
            toReturn = Collections.emptyList();
        }
        return toReturn;
    }

    @Override
    public int getRelatedCount(RelationTypeId type, Artifact node, RelationSide side) {
        return this.getRelatedCount(type, node, side, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public int getRelatedCount(RelationTypeId type, Artifact node, RelationSide side, DeletionFlag includeDeleted) {
        return this.getRelations(type, node, side, includeDeleted).size();
    }

    @Override
    public boolean areRelated(Artifact aNode, RelationTypeId type, Artifact bNode) {
        return this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED).size() > 0;
    }

    @Override
    public <T extends Artifact> T getParent(OrcsSession session, Artifact child) {
        ResultSet<T> toReturn = this.getRelated(session, (RelationTypeId)CoreRelationTypes.DEFAULT_HIERARCHY, child, CoreRelationTypes.IS_CHILD);
        return (T)((Artifact)toReturn.getOneOrNull());
    }

    @Override
    public <T extends Artifact> ResultSet<T> getChildren(OrcsSession session, Artifact parent) {
        return this.getRelated(session, (RelationTypeId)CoreRelationTypes.DEFAULT_HIERARCHY, parent, CoreRelationTypes.IS_PARENT);
    }

    @Override
    public <T extends Artifact> ResultSet<T> getRelated(OrcsSession session, RelationTypeId type, Artifact node, RelationSide side) {
        return this.getRelated(session, type, node, side, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public <T extends Artifact> ResultSet<T> getRelated(OrcsSession session, RelationTypeId type, Artifact node, RelationSide side, DeletionFlag flag) {
        List<Relation> links = this.getRelations(type, node, side, flag);
        List result = null;
        if (links.isEmpty()) {
            result = Collections.emptyList();
        } else {
            RelationSide otherSide = side.oppositeSide();
            GraphData graph = node.getGraph();
            result = this.resolver.resolve(session, graph, links, otherSide);
            if (result.size() > 1) {
                OrderManager orderManager = this.orderFactory.createOrderManager(node);
                RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)((RelationTypeToken)this.relationTypes.get((Id)type)), (RelationSide)otherSide);
                orderManager.sort(key, result);
            }
        }
        return ResultSets.newResultSet(result);
    }

    @Override
    public String getRationale(Artifact aNode, RelationTypeId type, Artifact bNode) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        return ((Relation)result.getExactlyOne()).getRationale();
    }

    @Override
    public void setRationale(Artifact aNode, RelationTypeId type, Artifact bNode, String rationale) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        Relation relation = (Relation)result.getExactlyOne();
        relation.setRationale(rationale);
    }

    @Override
    public void addChild(OrcsSession session, Artifact parent, Artifact child) {
        this.unrelateFromAll(session, (RelationTypeId)CoreRelationTypes.DEFAULT_HIERARCHY, child, CoreRelationTypes.IS_CHILD);
        this.relate(session, parent, CoreRelationTypes.DEFAULT_HIERARCHY, child);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode) {
        this.relate(session, aNode, type, bNode, Strings.emptyString(), RelationSorter.PREEXISTING);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale) {
        this.relate(session, aNode, type, bNode, rationale, RelationSorter.PREEXISTING);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, RelationSorter sortType) {
        this.relate(session, aNode, type, bNode, Strings.emptyString(), sortType);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationSorter sortType) {
        OrcsConditions.checkBranch(aNode, bNode);
        OrcsConditions.checkRelateSelf(aNode, bNode);
        GraphData graph = this.getGraph(aNode, bNode);
        this.validity.checkRelationTypeValid(type, aNode, RelationSide.SIDE_A);
        this.validity.checkRelationTypeValid(type, bNode, RelationSide.SIDE_B);
        this.checkMultiplicityCanAdd((RelationTypeId)type, aNode, bNode);
        Relation relation = (Relation)this.getRelation(aNode, (RelationTypeId)type, bNode, DeletionFlag.INCLUDE_DELETED).getOneOrNull();
        boolean updated = false;
        if (relation == null) {
            relation = this.relationFactory.createRelation(aNode, type, bNode, rationale);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode)).add(type, relation);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode)).add(type, relation);
            updated = true;
        }
        if (relation.isDeleted()) {
            relation.unDelete();
            updated = true;
        }
        if (updated) {
            relation.setDirty();
            this.order(session, (RelationTypeId)type, aNode, RelationSide.SIDE_A, sortType, OrderOp.ADD_TO_ORDER, Collections.singleton(bNode));
        }
    }

    private GraphData getGraph(Artifact aNode, Artifact bNode) {
        OrcsConditions.checkBranch(aNode, bNode);
        return aNode.getGraph().getTransaction().isOlderThan(bNode.getGraph().getTransaction()) ? bNode.getGraph() : aNode.getGraph();
    }

    private void checkMultiplicityCanAdd(RelationTypeId type, Artifact aNode, Artifact bNode) {
        int aSideMax;
        int bSideMax;
        int bSideCount = this.getRelations(type, aNode, RelationSide.SIDE_A, DeletionFlag.EXCLUDE_DELETED).size();
        if (bSideCount >= (bSideMax = this.validity.getMaximumRelationsAllowed(type, (ArtifactTypeId)bNode.getArtifactType(), RelationSide.SIDE_B))) {
            throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, RelationSide.SIDE_B, aNode.getExceptionString()});
        }
        int aSideCount = this.getRelations(type, bNode, RelationSide.SIDE_B, DeletionFlag.EXCLUDE_DELETED).size();
        if (aSideCount >= (aSideMax = this.validity.getMaximumRelationsAllowed(type, (ArtifactTypeId)aNode.getArtifactType(), RelationSide.SIDE_A))) {
            throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, RelationSide.SIDE_A, bNode.getExceptionString()});
        }
    }

    @Override
    public void unrelate(OrcsSession session, Artifact aNode, RelationTypeId type, Artifact bNode) {
        Relation relation = (Relation)this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED).getOneOrNull();
        boolean modified = false;
        if (relation != null) {
            relation.delete();
            modified = true;
        }
        if (modified) {
            this.order(session, type, aNode, RelationSide.SIDE_A, OrderOp.REMOVE_FROM_ORDER, Collections.singleton(bNode));
        }
    }

    @Override
    public void unrelateFromAll(OrcsSession session, RelationTypeId type, Artifact node, RelationSide side) {
        List<Relation> relations = this.getRelations(type, node, side, DeletionFlag.EXCLUDE_DELETED);
        RelationSide otherSide = side.oppositeSide();
        GraphData graph = node.getGraph();
        this.resolver.resolve(session, graph, relations, otherSide);
        boolean modified = false;
        LinkedHashSet<Artifact> otherNodes = new LinkedHashSet<Artifact>();
        for (Relation relation : relations) {
            relation.delete();
            Artifact otherNode = (Artifact)graph.getNode(relation.getIdForSide(otherSide));
            otherNodes.add(otherNode);
            modified = true;
        }
        if (modified) {
            this.order(session, type, node, side, OrderOp.REMOVE_FROM_ORDER, otherNodes);
        }
    }

    @Override
    public void unrelateFromAll(OrcsSession session, Artifact node) {
        this.unrelate(session, node, true);
    }

    private void unrelate(OrcsSession session, Artifact node, boolean reorderRelations) {
        Conditions.checkNotNull((Object)node, (String)"node");
        if (node.isDeleteAllowed()) {
            GraphData graph = node.getGraph();
            List<Relation> relations = this.getRelations(node, DeletionFlag.EXCLUDE_DELETED);
            this.resolver.resolve(session, graph, relations, RelationSide.values());
            ResultSet children = this.getChildren(session, node);
            for (Artifact child : children) {
                this.unrelate(session, child, false);
            }
            try {
                node.delete();
                if (relations != null && !relations.isEmpty()) {
                    HashMap<RelationTypeId, RelationSide> typesToRemove = new HashMap<RelationTypeId, RelationSide>();
                    for (Relation relation : relations) {
                        relation.delete();
                        RelationTypeId type = relation.getRelationType();
                        RelationSide otherSide = relation.getIdForSide(RelationSide.SIDE_A).equals(node) ? RelationSide.SIDE_B : RelationSide.SIDE_A;
                        typesToRemove.put(type, otherSide);
                    }
                    if (!typesToRemove.isEmpty()) {
                        OrderManager orderManager = this.orderFactory.createOrderManager(node);
                        for (Map.Entry entry : typesToRemove.entrySet()) {
                            RelationTypeId type = (RelationTypeId)entry.getKey();
                            RelationSide side = (RelationSide)entry.getValue();
                            List<Relation> sideLinks = this.getRelations(type, node, side, DeletionFlag.EXCLUDE_DELETED);
                            List nodes = this.resolver.resolve(session, graph, sideLinks, side);
                            RelationTypeSide asTypeSide = RelationTypeSide.create((RelationTypeToken)((RelationTypeToken)this.relationTypes.get((Id)type)), (RelationSide)side);
                            orderManager.setOrder(asTypeSide, nodes);
                        }
                    }
                }
            }
            catch (OseeCoreException ex) {
                node.unDelete();
                throw ex;
            }
        }
    }

    private void ensureRelationsInitialized(GraphData graph, Artifact node) {
        if (graph.getAdjacencies((ArtifactId)node) == null) {
            RelationNodeAdjacencies container = this.relationFactory.createRelationContainer();
            graph.addAdjacencies((ArtifactId)node, container);
        }
    }

    private ResultSet<Relation> getRelation(Artifact aNode, RelationTypeId type, Artifact bNode, DeletionFlag inludeDeleted) {
        GraphData graph = this.getGraph(aNode, bNode);
        Conditions.checkNotNull((Object)type, (String)"relationType");
        this.ensureRelationsInitialized(graph, aNode);
        this.ensureRelationsInitialized(graph, bNode);
        RelationNodeAdjacencies aAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode);
        RelationNodeAdjacencies bAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode);
        Relation relation = aAdjacencies.getRelation(aNode, type, bNode, inludeDeleted);
        if (relation != null) {
            bAdjacencies.add(type, relation);
        } else {
            relation = bAdjacencies.getRelation(aNode, type, bNode, inludeDeleted);
            if (relation != null) {
                aAdjacencies.add(type, relation);
            }
        }
        return ResultSets.singleton((Object)relation);
    }

    private List<Relation> getRelations(RelationTypeId type, Artifact node, RelationSide side, DeletionFlag includeDeleted) {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        Conditions.checkNotNull((Object)node, (String)"node");
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        List<Relation> relations = adjacencies.getList(type, includeDeleted, (ArtifactId)node, side);
        return relations;
    }

    @Override
    public List<Relation> getRelations(Artifact node, DeletionFlag includeDeleted) {
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        return adjacencies.getList(includeDeleted);
    }

    private void order(OrcsSession session, RelationTypeId type, Artifact node1, RelationSide side, OrderOp op, Collection<? extends Artifact> node2) {
        this.order(session, type, node1, side, RelationSorter.PREEXISTING, op, node2);
    }

    private void order(OrcsSession session, RelationTypeId type, Artifact node1, RelationSide side, RelationSorter sorterId, OrderOp op, Collection<? extends Artifact> node2) {
        OrderManager orderManager = this.orderFactory.createOrderManager(node1);
        RelationSide orderSide = side.oppositeSide();
        RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)((RelationTypeToken)this.relationTypes.get((Id)type)), (RelationSide)orderSide);
        RelationSorter sorterIdToUse = sorterId;
        if (sorterIdToUse == RelationSorter.PREEXISTING) {
            sorterIdToUse = orderManager.getSorterId(key);
        }
        List relatives = Collections.emptyList();
        if (RelationSorter.USER_DEFINED == sorterIdToUse) {
            ResultSet arts = this.getRelated(session, type, node1, side);
            relatives = new LinkedList();
            for (Artifact art : arts) {
                relatives.add(art);
            }
            relatives.removeAll(node2);
            if (OrderOp.ADD_TO_ORDER == op) {
                relatives.addAll(node2);
            }
        }
        orderManager.setOrder(key, sorterIdToUse, relatives);
    }

    @Override
    public void order(Artifact node1, RelationTypeId type, RelationSide side, List<? extends Artifact> node2) {
        OrderManager orderManager = this.orderFactory.createOrderManager(node1);
        RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)((RelationTypeToken)this.relationTypes.get((Id)type)), (RelationSide)side);
        orderManager.setOrder(key, RelationSorter.USER_DEFINED, node2);
    }

    @Override
    public void cloneRelations(Artifact source, Artifact destination) {
        Collection all;
        this.ensureRelationsInitialized(source.getGraph(), source);
        RelationNodeAdjacencies adjacencies1 = (RelationNodeAdjacencies)source.getGraph().getAdjacencies((ArtifactId)source);
        if (adjacencies1 != null && !(all = adjacencies1.getAll()).isEmpty()) {
            RelationNodeAdjacencies adjacencies2 = this.relationFactory.createRelationContainer();
            destination.getGraph().addAdjacencies((ArtifactId)destination, adjacencies2);
            for (Relation relation : adjacencies1.getAll()) {
                Relation newRel = this.relationFactory.clone(relation);
                adjacencies2.add((RelationTypeId)newRel.getOrcsData().getType(), newRel);
            }
        }
    }

    @Override
    public void introduce(BranchId branch, Artifact source, Artifact destination) {
        String orderData;
        this.ensureRelationsInitialized(source.getGraph(), source);
        Collection<RelationTypeId> validRelationTypes = this.getValidRelationTypes(destination);
        RelationNodeAdjacencies sourceAdjacencies = (RelationNodeAdjacencies)source.getGraph().getAdjacencies((ArtifactId)source);
        RelationNodeAdjacencies destinationAdjacencies = (RelationNodeAdjacencies)destination.getGraph().getAdjacencies((ArtifactId)destination);
        if (sourceAdjacencies != null) {
            for (Relation sourceRel : sourceAdjacencies.getAll()) {
                if (!validRelationTypes.contains(sourceRel.getRelationType())) continue;
                Relation destinationRel = this.findRelationByLocalId(destinationAdjacencies, sourceRel.getOrcsData().getLocalId());
                Relation introduceRelation = this.relationFactory.introduce(branch, sourceRel.getOrcsData());
                if (destinationRel == null) continue;
                destinationRel.setOrcsData(introduceRelation.getOrcsData());
                destinationRel.setDirty();
            }
        }
        if (!(orderData = source.getOrderData()).isEmpty()) {
            destination.storeOrderData(OrderChange.Forced, source.getOrderData());
        }
    }

    @Override
    public void setApplicabilityId(Artifact aNode, RelationTypeId type, Artifact bNode, ApplicabilityId applicId) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        Relation relation = (Relation)result.getExactlyOne();
        relation.setApplicabilityId(applicId);
    }

    private Relation findRelationByLocalId(RelationNodeAdjacencies adjacencies, Integer id) {
        for (Relation rel : adjacencies.getAll()) {
            if (!id.equals(rel.getOrcsData().getLocalId())) continue;
            return rel;
        }
        return null;
    }

    private static enum OrderOp {
        ADD_TO_ORDER,
        REMOVE_FROM_ORDER;

    }
}

