/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OrcsTypesData;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.OrcsTopicEvents;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class CreateSystemBranches {
    private final OrcsApi orcsApi;
    private final EventAdmin eventAdmin;
    private final TransactionFactory txFactory;
    private final QueryBuilder query;
    private static String EDIT_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"*\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static final String JSON_ATTR_VALUE = "{ \"WCAFE\" : [{\"TypeId\" : 204509162766372, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 49}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 50, \"Max\" : 199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1}]}]}";

    public CreateSystemBranches(OrcsApi orcsApi, EventAdmin eventAdmin) {
        this.orcsApi = orcsApi;
        this.eventAdmin = eventAdmin;
        this.txFactory = orcsApi.getTransactionFactory();
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public void create(String typeModel) {
        this.orcsApi.getKeyValueOps().putByKey((Id)ApplicabilityToken.BASE, ApplicabilityToken.BASE.getName());
        this.populateSystemBranch();
        this.orcsApi.getBranchOps().createTopLevelBranch(CoreBranches.COMMON, (ArtifactId)SystemUser.OseeSystem);
        this.populateCommonBranch(typeModel);
    }

    private void populateSystemBranch() {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.SYSTEM_ROOT, (UserId)SystemUser.OseeSystem, "Add System Root branch artifacts");
        tx.createArtifact(CoreArtifactTokens.DefaultHierarchyRoot);
        tx.createArtifact(CoreArtifactTokens.UniversalGroupRoot);
        tx.commit();
    }

    private void populateCommonBranch(String typeModel) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Add Common branch artifacts");
        ArtifactReadable root = (ArtifactReadable)this.query.andIsHeirarchicalRootArtifact().getResults().getExactlyOne();
        ArtifactToken oseeConfig = this.query.andId((ArtifactId)CoreArtifactTokens.OseeConfiguration).getArtifactOrSentinal();
        if (oseeConfig.isInvalid()) {
            oseeConfig = tx.createArtifact((ArtifactId)root, CoreArtifactTokens.OseeConfiguration);
        }
        ArtifactToken userGroupsFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.UserGroups);
        ArtifactToken everyOne = tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Everyone);
        tx.setSoleAttributeValue((ArtifactId)everyOne, (AttributeTypeToken)CoreAttributeTypes.DefaultGroup, (Object)true);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAccessAdmin);
        tx.commit();
        oseeConfig = this.query.andId((ArtifactId)CoreArtifactTokens.OseeConfiguration).getArtifactOrSentinal();
        tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Add Common branch artifacts");
        this.orcsApi.getAdminOps().createUsers(tx, (Iterable)SystemUser.values());
        ArtifactToken globalPreferences = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.GlobalPreferences);
        tx.setSoleAttributeValue((ArtifactId)globalPreferences, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)JSON_ATTR_VALUE);
        tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.XViewerCustomization);
        ArtifactToken documentTemplateFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.DocumentTemplates);
        this.createWordTemplates(tx, (ArtifactId)documentTemplateFolder);
        this.createDataRights(tx, (ArtifactId)documentTemplateFolder);
        ArtifactId typesAccessFolder = this.createOrcsTypesArtifacts(typeModel, (ArtifactId)oseeConfig);
        this.addFrameworkAccessModel(tx, typesAccessFolder);
        tx.commit();
    }

    private void createWordTemplates(TransactionBuilder tx, ArtifactId documentTemplateFolder) {
        ArtifactToken templateArtWe = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplate, "WordEditTemplate");
        tx.setSoleAttributeValue((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)EDIT_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/Word Edit Template.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer SPECIALIZED_EDIT");
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.TisRenderer SPECIALIZED_EDIT");
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer MERGE");
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer MERGE_EDIT");
        ArtifactToken templateArtPrev = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplate, "PreviewAll");
        tx.setSoleAttributeValue((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_ARTIFACT");
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW");
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer DIFF");
        ArtifactToken templateArtPrevNoAttr = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplate, "PREVIEW_ALL_NO_ATTRIBUTES");
        tx.setSoleAttributeValue((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_NO_ATTRIBUTES.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_ALL_NO_ATTRIBUTES");
        tx.createAttribute((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer DIFF_NO_ATTRIBUTES");
        ArtifactToken templateArtPar = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplate, "PREVIEW_ALL_RECURSE");
        tx.setSoleAttributeValue((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)RECURSIVE_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_RECURSE.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_WITH_RECURSE");
        ArtifactToken templateArtParna = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplate, "PREVIEW_ALL_RECURSE_NO_ATTRIBUTES");
        tx.setSoleAttributeValue((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)RECURSIVE_NO_ATTR_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_WITH_RECURSE_NO_ATTRIBUTES");
    }

    private void createDataRights(TransactionBuilder tx, ArtifactId documentTemplateFolder) {
        ArtifactToken dataRightsArt = tx.createArtifact(documentTemplateFolder, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", this.getClass()));
    }

    private void addFrameworkAccessModel(TransactionBuilder tx, ArtifactId typesAccessFolder) {
        InputStream inputStream = OseeInf.getResourceAsStream((String)"access/OseeAccess_FrameworkAccess.osee", this.getClass());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream stream = new BufferedInputStream(inputStream);){
                ArtifactToken accessModel = tx.createArtifact(typesAccessFolder, CoreArtifactTokens.FrameworkAccessModel);
                tx.setSoleAttributeFromStream((ArtifactId)accessModel, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (InputStream)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private ArtifactId createOrcsTypesArtifacts(String typeModel, ArtifactId oseeConfig) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Add Types to Common Branch");
        ArtifactId typesFolder = (ArtifactId)this.query.andId((ArtifactId)CoreArtifactTokens.OseeTypesAndAccessFolder).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (typesFolder.isInvalid()) {
            typesFolder = tx.createArtifact(oseeConfig, CoreArtifactTokens.OseeTypesAndAccessFolder);
        }
        ArtifactToken types = tx.createArtifact(typesFolder, CoreArtifactTypes.OseeTypeDefinition, "OSEE Types");
        tx.setSoleAttributeValue((ArtifactId)types, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)true);
        tx.setSoleAttributeFromString((ArtifactId)types, (AttributeTypeToken)CoreAttributeTypes.UriGeneralStringData, typeModel);
        tx.commit();
        tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Add OseeTypeDef Tuples to Common Branch");
        for (ArtifactReadable artifact : this.query.andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.OseeTypeDefinition}).getResults()) {
            tx.addTuple2(CoreTupleTypes.OseeTypeDef, (Object)OrcsTypesData.OSEE_TYPE_VERSION, (Object)((AttributeId)artifact.getAttributes((AttributeTypeId)CoreAttributeTypes.UriGeneralStringData).iterator().next()));
        }
        tx.commit();
        Event event = new Event(OrcsTopicEvents.DBINIT_IMPORT_TYPES, null);
        this.eventAdmin.postEvent(event);
        return typesFolder;
    }
}

