/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.orcsScriptDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OsOperator implements Enumerator
{
    EQUAL(0, "EQUAL", "="),
    NOT_EQUAL(1, "NOT_EQUAL", "!="),
    LESS_THAN(2, "LESS_THAN", "<"),
    LESS_THAN_EQ(3, "LESS_THAN_EQ", "<="),
    GREATER_THAN(4, "GREATER_THAN", ">"),
    GREATER_THAN_EQ(5, "GREATER_THAN_EQ", ">=");

    public static final int EQUAL_VALUE = 0;
    public static final int NOT_EQUAL_VALUE = 1;
    public static final int LESS_THAN_VALUE = 2;
    public static final int LESS_THAN_EQ_VALUE = 3;
    public static final int GREATER_THAN_VALUE = 4;
    public static final int GREATER_THAN_EQ_VALUE = 5;
    private static final OsOperator[] VALUES_ARRAY;
    public static final List<OsOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OsOperator[]{EQUAL, NOT_EQUAL, LESS_THAN, LESS_THAN_EQ, GREATER_THAN, GREATER_THAN_EQ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OsOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OsOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OsOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OsOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OsOperator get(int value) {
        switch (value) {
            case 0: {
                return EQUAL;
            }
            case 1: {
                return NOT_EQUAL;
            }
            case 2: {
                return LESS_THAN;
            }
            case 3: {
                return LESS_THAN_EQ;
            }
            case 4: {
                return GREATER_THAN;
            }
            case 5: {
                return GREATER_THAN_EQ;
            }
        }
        return null;
    }

    private OsOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

