/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.formatting;

import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.orcs.script.dsl.services.OrcsScriptDslGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfigBasedStream;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.util.Pair;

public class OrcsScriptDslFormatter
extends AbstractDeclarativeFormatter
implements IIndentationInformation {
    public String getIndentString() {
        return "   ";
    }

    protected void configureFormatting(FormattingConfig cfg) {
        OrcsScriptDslGrammarAccess grmr = (OrcsScriptDslGrammarAccess)this.getGrammarAccess();
        cfg.setAutoLinewrap(120);
        cfg.setLinewrap(0, 1, 2).before((EObject)grmr.getSL_COMMENTRule());
        cfg.setLinewrap(2, 2, 2).before((EObject)grmr.getML_COMMENTRule());
        cfg.setLinewrap(0, 1, 1).after((EObject)grmr.getML_COMMENTRule());
        for (Keyword keyword : grmr.findKeywords(new String[]{";"})) {
            cfg.setNoSpace().before((EObject)keyword);
        }
        for (Keyword keyword : grmr.findKeywords(new String[]{"."})) {
            cfg.setNoSpace().before((EObject)keyword);
            cfg.setNoSpace().after((EObject)keyword);
        }
        for (Keyword keyword : grmr.findKeywords(new String[]{".."})) {
            cfg.setNoSpace().before((EObject)keyword);
            cfg.setNoSpace().after((EObject)keyword);
        }
        for (Keyword keyword : grmr.findKeywords(new String[]{","})) {
            cfg.setNoSpace().before((EObject)keyword);
            cfg.setSpace(" ").after((EObject)keyword);
        }
        for (Pair pair : grmr.findKeywordPairs("(", ")")) {
            cfg.setNoSpace().after((EObject)pair.getFirst());
            cfg.setNoSpace().before((EObject)pair.getSecond());
        }
        for (Pair pair : grmr.findKeywordPairs("[", "]")) {
            cfg.setNoSpace().after((EObject)pair.getFirst());
            cfg.setNoSpace().before((EObject)pair.getSecond());
        }
        OrcsScriptDslGrammarAccess.ScriptVersionElements version = grmr.getScriptVersionAccess();
        cfg.setLinewrap(0, 1, 2).before((EObject)version.getGroup());
        cfg.setLinewrap(1).after((EObject)version.getGroup());
        OrcsScriptDslGrammarAccess.OsTemplateLiteralElements template = grmr.getOsTemplateLiteralAccess();
        cfg.setNoSpace().after((EObject)template.getLeftCurlyBracketLeftCurlyBracketKeyword_1());
        cfg.setNoSpace().before((EObject)template.getRightCurlyBracketRightCurlyBracketKeyword_3());
        OrcsScriptDslGrammarAccess.OsVariableDeclarationElements variable = grmr.getOsVariableDeclarationAccess();
        cfg.setLinewrap(0, 1, 2).before((EObject)variable.getVarKeyword_1());
        cfg.setLinewrap(1, 1, 2).after((EObject)variable.getSemicolonKeyword_4());
        OrcsScriptDslGrammarAccess.OsQueryExpressionElements query = grmr.getOsQueryExpressionAccess();
        cfg.setLinewrap(1).before((EObject)query.getNameStartKeyword_1_0());
        OrcsScriptDslGrammarAccess.OsQueryStatementElements stmt = grmr.getOsQueryStatementAccess();
        cfg.setLinewrap(2).after((EObject)stmt.getSemicolonKeyword_1());
        OrcsScriptDslGrammarAccess.OsFindClauseElements find = grmr.getOsFindClauseAccess();
        cfg.setLinewrap(1).before((EObject)find.getGroup());
        cfg.setLinewrap(1).after((EObject)find.getGroup());
        OrcsScriptDslGrammarAccess.OsFollowClauseElements follow = grmr.getOsFollowClauseAccess();
        cfg.setLinewrap(1).before((EObject)follow.getGroup());
        cfg.setLinewrap(1).after((EObject)follow.getGroup());
        OrcsScriptDslGrammarAccess.OsCollectClauseElements collect = grmr.getOsCollectClauseAccess();
        cfg.setLinewrap(1).before((EObject)collect.getNameCollectKeyword_0_0());
        cfg.setLinewrap(1).after((EObject)collect.getGroup());
        OrcsScriptDslGrammarAccess.OsCollectObjectExpressionElements collectObj = grmr.getOsCollectObjectExpressionAccess();
        cfg.setLinewrap().after((EObject)collectObj.getLeftCurlyBracketKeyword_3());
        cfg.setIndentationIncrement().before((EObject)collectObj.getGroup_4_1());
        cfg.setIndentationDecrement().after((EObject)collectObj.getGroup_4_1());
        cfg.setLinewrap().before((EObject)collectObj.getRightCurlyBracketKeyword_5());
        OrcsScriptDslGrammarAccess.OsCollectAllFieldsExpressionElements allFields = grmr.getOsCollectAllFieldsExpressionAccess();
        cfg.setNoLinewrap().before((EObject)allFields.getNameAsteriskKeyword_1_0());
        cfg.setNoLinewrap().after((EObject)allFields.getNameAsteriskKeyword_1_0());
    }

    public ITokenStream createFormatterStream(String indent, ITokenStream out, boolean preserveWhitespaces) {
        return new MyTokenStream(out, indent, this.getConfig(), (IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern>)this.createMatcher(), this.getHiddenTokenHelper(), preserveWhitespaces);
    }

    private class MyTokenStream
    extends FormattingConfigBasedStream {
        private EObject previous;

        public MyTokenStream(ITokenStream out, String indentation, FormattingConfig cfg, IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> matcher, IHiddenTokenHelper hiddenTokenHelper, boolean preserveSpaces) {
            super(out, indentation, cfg, matcher, hiddenTokenHelper, preserveSpaces);
            this.previous = null;
        }

        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            this.previous = grammarElement;
            super.writeSemantic(grammarElement, value);
        }

        public void writeHidden(EObject grammarElement, String value) throws IOException {
            String newValue = value;
            if (grammarElement instanceof TerminalRule) {
                if ("SL_COMMENT".equals(((TerminalRule)grammarElement).getName()) && this.previous instanceof Keyword && "{".toString().equals(((Keyword)this.previous).getValue())) {
                    newValue = String.valueOf(OrcsScriptDslFormatter.this.getIndentString()) + value;
                }
                if ("ML_COMMENT".equals(((TerminalRule)grammarElement).getName())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.getLineSeparator());
                    sb.append(this.getLineSeparator());
                    int i = 0;
                    while (i < this.indentationLevel) {
                        sb.append(OrcsScriptDslFormatter.this.getIndentString());
                        ++i;
                    }
                    if (this.previous instanceof Keyword && "{".toString().equals(((Keyword)this.previous).getValue())) {
                        sb.append(OrcsScriptDslFormatter.this.getIndentString());
                    }
                    sb.append(value).append(this.getLineSeparator());
                    newValue = sb.toString();
                }
            }
            super.writeHidden(grammarElement, newValue);
        }

        public void flush() throws IOException {
            super.flush();
        }
    }
}

