/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.fields;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;
import org.eclipse.osee.orcs.script.dsl.OsCollectType;
import org.eclipse.osee.orcs.script.dsl.OsFieldEnum;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBranchQueryStatement;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectAllFieldsExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectClause;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectFieldExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsCollectObjectExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsFollowStatement;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsObjectQuery;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsQuery;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTxQueryStatement;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class OsFieldResolverImpl
implements IFieldResolver {
    @Override
    public OsCollectType getCollectType(EObject object) {
        OsCollectType toReturn = null;
        OsCollectObjectExpression expression = null;
        expression = object instanceof OsCollectObjectExpression ? (OsCollectObjectExpression)object : (OsCollectObjectExpression)EcoreUtil2.getContainerOfType((EObject)object, OsCollectObjectExpression.class);
        if (expression != null) {
            String typeId = expression.getName();
            toReturn = OsCollectType.fromString(typeId);
        }
        return toReturn;
    }

    @Override
    public Set<? extends IFieldResolver.OsField> getAllowedFields(EObject object) {
        OsCollectType type = this.getCollectType(object);
        Set<Object> toReturn = type != null ? this.getAllowedFieldsByType(object, type) : Collections.emptySet();
        return toReturn;
    }

    private Set<? extends IFieldResolver.OsField> getAllowedFieldsByType(EObject object, OsCollectType type) {
        Set toReturn;
        if (type != null) {
            EObject eContainer;
            EObject container1;
            OsFieldEnum.Family family = null;
            if (OsCollectType.TXS == type && (container1 = object.eContainer()) != null && (eContainer = container1.eContainer()) instanceof OsCollectObjectExpression) {
                String containerType = ((OsCollectObjectExpression)eContainer).getName();
                if ("artifacts".equals(containerType)) {
                    family = OsFieldEnum.Family.ARTIFACT_TX;
                } else if ("attributes".equals(containerType)) {
                    family = OsFieldEnum.Family.ATTRIBUTE_TX;
                } else if ("relations".equals(containerType)) {
                    family = OsFieldEnum.Family.RELATION_TX;
                }
            }
            if (family == null) {
                family = this.getFamily(type);
            }
            toReturn = OsFieldEnum.getFieldsFor(family);
        } else {
            toReturn = Collections.emptySet();
        }
        return toReturn;
    }

    private OsFieldEnum.Family getFamily(OsCollectType type) {
        OsFieldEnum.Family toReturn;
        switch (type) {
            case BRANCHES: {
                toReturn = OsFieldEnum.Family.BRANCH;
                break;
            }
            case TXS: {
                toReturn = OsFieldEnum.Family.TX;
                break;
            }
            case ARTIFACTS: {
                toReturn = OsFieldEnum.Family.ARTIFACT;
                break;
            }
            case ATTRIBUTES: {
                toReturn = OsFieldEnum.Family.ATTRIBUTE;
                break;
            }
            case RELATIONS: {
                toReturn = OsFieldEnum.Family.RELATION;
                break;
            }
            default: {
                toReturn = OsFieldEnum.Family.UNDEFINED;
            }
        }
        return toReturn;
    }

    private EObject getCollectContainer(EObject object) {
        EObject parent = object.eContainer();
        if (parent != null) {
            OsCollectObjectExpression expression = (OsCollectObjectExpression)EcoreUtil2.getContainerOfType((EObject)parent, OsCollectObjectExpression.class);
            if (expression == null) {
                EObject container = EcoreUtil2.getContainerOfType((EObject)parent, OsQuery.class);
                if (container == null && (container = EcoreUtil2.getContainerOfType((EObject)parent, OsObjectQuery.class)) == null) {
                    container = EcoreUtil2.getContainerOfType((EObject)parent, OsFollowStatement.class);
                }
                parent = container;
            } else {
                parent = expression;
            }
        }
        return parent;
    }

    @Override
    public Set<OsCollectType> getAllowedCollectTypes(EObject object) {
        TreeSet<OsCollectType> toReturn = new TreeSet<OsCollectType>();
        if (object instanceof OsCollectClause) {
            EObject container = this.getCollectContainer(object);
            if (container instanceof OsBranchQueryStatement) {
                toReturn.add(OsCollectType.BRANCHES);
            } else if (container instanceof OsTxQueryStatement) {
                toReturn.add(OsCollectType.TXS);
            } else {
                toReturn.add(OsCollectType.ARTIFACTS);
            }
        }
        return toReturn;
    }

    @Override
    public Set<? extends IFieldResolver.OsField> getDeclaredFields(EObject object) {
        String collectName;
        OsCollectType type;
        LinkedHashSet<? extends IFieldResolver.OsField> toReturn = new LinkedHashSet<IFieldResolver.OsField>();
        OsCollectObjectExpression container = (OsCollectObjectExpression)EcoreUtil2.getContainerOfType((EObject)object, OsCollectObjectExpression.class);
        if (container != null && (type = OsCollectType.fromString(collectName = container.getName())) != null) {
            Set<? extends IFieldResolver.OsField> allowed = this.getAllowedFieldsByType(object, type);
            HashMap<String, IFieldResolver.OsField> fieldMap = new HashMap<String, IFieldResolver.OsField>();
            for (IFieldResolver.OsField osField : allowed) {
                fieldMap.put(osField.getLiteral(), osField);
            }
            for (OsCollectExpression osCollectExpression : container.getExpressions()) {
                if (osCollectExpression instanceof OsCollectAllFieldsExpression) {
                    toReturn.addAll(allowed);
                    continue;
                }
                if (!(osCollectExpression instanceof OsCollectObjectExpression) && !(osCollectExpression instanceof OsCollectFieldExpression)) continue;
                String fieldName = osCollectExpression.getName();
                IFieldResolver.OsField field = (IFieldResolver.OsField)fieldMap.get(fieldName);
                if (field == null) {
                    field = OsFieldEnum.newField(fieldName);
                }
                toReturn.add(field);
            }
        }
        return toReturn;
    }

    @Override
    public Set<? extends IFieldResolver.OsField> getRemainingAllowedFields(EObject object) {
        Set<? extends IFieldResolver.OsField> allowedFields = this.getAllowedFields(object);
        TreeSet declaredFields = Sets.newTreeSet(OsFieldEnum.getComparator());
        declaredFields.addAll(this.getDeclaredFields(object));
        return Sets.difference(allowedFields, (Set)declaredFields);
    }

    @Override
    public Set<? extends IFieldResolver.OsField> getNotAllowedDeclaredFields(EObject object) {
        Set<? extends IFieldResolver.OsField> allowedFields = this.getAllowedFields(object);
        Set<? extends IFieldResolver.OsField> declaredFields = this.getDeclaredFields(object);
        return Sets.difference(declaredFields, allowedFields);
    }
}

