/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.conversion;

import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class StringValueConverter
extends AbstractValueConverter<String> {
    public String toString(String value) {
        if (value == null) {
            throw new ValueConverterException("STRING-value may not be null.", null, null);
        }
        String converted = Strings.convertToJavaString((String)value, (boolean)false);
        return OrcsScriptUtil.quote(converted);
    }

    public String toValue(String rawValue, INode node) throws ValueConverterException {
        if (rawValue == null) {
            return null;
        }
        try {
            String value = OrcsScriptUtil.unquote(rawValue);
            return this.convertFromJavaString(value, false);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    private String convertFromJavaString(String javaString, boolean useUnicode) {
        char[] convtBuf;
        char[] in = javaString.toCharArray();
        int off = 0;
        int len = javaString.length();
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                aChar = in[off++];
                if (useUnicode && aChar == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                } else if (aChar == 98) {
                    aChar = 8;
                } else if (aChar == 34) {
                    aChar = 34;
                } else if (aChar == 39) {
                    aChar = 39;
                } else if (aChar == 92) {
                    aChar = 92;
                } else {
                    out[outLen++] = 92;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }
}

