/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientArtifact;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthTypes;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class ClientStorage {
    private final Log logger;
    private final OrcsApi orcsApi;
    private final BranchId storageBranch;

    public ClientStorage(Log logger, OrcsApi orcsApi, BranchId storageBranch) {
        this.logger = logger;
        this.orcsApi = orcsApi;
        this.storageBranch = storageBranch;
    }

    private BranchId getBranch() {
        return this.storageBranch;
    }

    private QueryBuilder newQuery() {
        return this.orcsApi.getQueryFactory().fromBranch(this.getBranch());
    }

    private TransactionBuilder newTransaction(OseePrincipal principal, String comment) {
        UserToken author = principal == null ? SystemUser.OseeSystem : UserId.valueOf((Long)((Long)principal.getGuid()));
        TransactionFactory transactionFactory = this.orcsApi.getTransactionFactory();
        return transactionFactory.createTransaction(this.getBranch(), (UserId)author, comment);
    }

    public ResultSet<ArtifactReadable> getClientByApplicationId(ArtifactId applicationId) {
        return this.newQuery().andId(applicationId).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientGuid(String guid) {
        return this.newQuery().andGuid(guid).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientId(ArtifactId id) {
        return this.newQuery().andId(id).getResults();
    }

    public boolean exists(Long id) {
        return this.newQuery().andUuid(id.longValue()).exists();
    }

    public ArtifactId insert(OseePrincipal principal, OAuthClient data) {
        TransactionBuilder tx = this.newTransaction(principal, "Create OAuth Client");
        ArtifactToken artId = tx.createArtifact(OAuthTypes.OAuthClient, data.getApplicationName(), Long.valueOf(data.getClientUuid()));
        this.txSetClient(tx, (ArtifactId)artId, data);
        tx.commit();
        return artId;
    }

    public void update(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((Long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Update OAuth Client");
        tx.setName(artId, data.getApplicationName());
        this.txSetClient(tx, artId, data);
        tx.commit();
    }

    private void txSetClient(TransactionBuilder tx, ArtifactId artId, OAuthClient data) {
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)CoreAttributeTypes.Description, data.getApplicationDescription());
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)OAuthTypes.OAuthClientWebsiteUri, data.getApplicationWebUri());
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)OAuthTypes.OAuthClientLogoUri, data.getApplicationLogoUri());
        tx.setSoleAttributeValue(artId, (AttributeTypeToken)OAuthTypes.OAuthClientIsConfidential, (Object)data.isConfidential());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedAudience, (Collection)data.getRegisteredAudiences());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedGrantType, (Collection)data.getAllowedGrantTypes());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedRedirectUri, (Collection)data.getRedirectUris());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthTypes.OAuthClientAuthorizedScope, (Collection)data.getRegisteredScopes());
        ByteSource supplier = data.getApplicationLogoSupplier();
        if (supplier != null) {
            try {
                tx.setSoleAttributeValue(artId, (AttributeTypeToken)CoreAttributeTypes.ImageContent, (Object)supplier.openStream());
            }
            catch (Exception ex) {
                throw new OseeCoreException((Throwable)ex, "Error reading logo data for [%s]", new Object[]{artId});
            }
        }
        Map props = data.getProperties();
        String json = JsonUtil.toJson((Object)props);
        tx.setSoleAttributeValue(artId, (AttributeTypeToken)OAuthTypes.OAuthClientProperties, (Object)json);
    }

    public void delete(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((Long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Delete OAuth Client");
        tx.deleteArtifact(artId);
        tx.commit();
    }

    private ResultSet<ArtifactReadable> getOAuthTypesDefinition() {
        return this.newQuery().andUuid(OAuthTypes.OAUTH_TYPES.getUuid().longValue()).andTypeEquals(new ArtifactTypeId[]{OAuthTypes.OAUTH_TYPES.getArtifactType()}).getResults();
    }

    public ArtifactId storeTypes(ByteSource resource) {
        TransactionBuilder tx = this.newTransaction(null, "Initialize OAuth Type Definitions");
        ArtifactToken artifactId = tx.createArtifact(OAuthTypes.OAUTH_TYPES);
        InputStream stream = null;
        try {
            try {
                stream = resource.openStream();
                tx.setSoleAttributeFromStream((ArtifactId)artifactId, (AttributeTypeToken)CoreAttributeTypes.UriGeneralStringData, stream);
            }
            catch (IOException ex) {
                throw new OseeCoreException((Throwable)ex);
            }
        }
        finally {
            Lib.close((AutoCloseable)stream);
        }
        tx.commit();
        this.orcsApi.getOrcsTypes().invalidateAll();
        return artifactId;
    }

    public boolean typesExist() {
        boolean result = false;
        try {
            result = !this.getOAuthTypesDefinition().isEmpty();
        }
        catch (OseeCoreException ex) {
            this.logger.warn((Throwable)ex, "Error checking for OAuth Types", new Object[0]);
        }
        return result;
    }

    public OAuthClient newClient(ArtifactReadable artifact, OAuthClientCredential credential) {
        return new ClientArtifact(artifact, credential);
    }
}

