/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import org.eclipse.osee.account.admin.Subscription;
import org.eclipse.osee.account.rest.model.SubscriptionGroupId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdentity;
import org.eclipse.osee.framework.jdk.core.util.EncryptUtility;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public final class SubscriptionUtil {
    private static final String SUBSCRIPTION_SECRET = "lRL2uka3CwLL88Q1";

    public static String toEncodedUuid(ArtifactId accountId, String accountDisplayName, SubscriptionGroupId groupId, String subscriptionName) {
        String rawData = String.format("%s:%s:%s:%s", accountId.getUuid(), accountDisplayName, groupId, subscriptionName);
        return EncryptUtility.encrypt((String)rawData, (String)SUBSCRIPTION_SECRET);
    }

    public static Subscription fromEncodedUuid(String subscriptionUuid, ActiveDelegate delegate) {
        String decrypted = EncryptUtility.decrypt((String)subscriptionUuid, (String)SUBSCRIPTION_SECRET);
        String[] data = decrypted.split(":");
        int index = 0;
        int accountId = Integer.parseInt(data[index++]);
        ArtifactId artId = ArtifactId.valueOf((int)accountId);
        String accountDisplayName = data[index++];
        int groupId = Integer.parseInt(data[index++]);
        SubscriptionGroupId subscriptionId = new SubscriptionGroupId(Long.valueOf(groupId));
        String subscriptionName = data[index++];
        return new DelegatingActiveSubscriptionImpl(subscriptionUuid, artId, accountDisplayName, subscriptionId, subscriptionName, delegate);
    }

    public static Subscription fromData(ArtifactId accountId, String accountDisplayName, SubscriptionGroupId groupId, String subscriptionName, boolean isActive) {
        String encodedUuid = SubscriptionUtil.toEncodedUuid(accountId, accountDisplayName, groupId, subscriptionName);
        return new SubscriptionImpl(encodedUuid, accountId, accountDisplayName, groupId, subscriptionName, isActive, null, null);
    }

    public static Subscription fromArtifactData(ArtifactReadable account, ArtifactReadable subscription, boolean isActive) {
        String accountName = account.getName();
        SubscriptionGroupId subcriptionId = new SubscriptionGroupId(subscription.getId());
        String subscriptionName = subscription.getName();
        return SubscriptionUtil.fromData((ArtifactId)account, accountName, subcriptionId, subscriptionName, isActive);
    }

    public static interface ActiveDelegate {
        public boolean isActive(ArtifactId var1, SubscriptionGroupId var2);
    }

    private static final class DelegatingActiveSubscriptionImpl
    extends SubscriptionImpl {
        private final ActiveDelegate provider;

        private DelegatingActiveSubscriptionImpl(String encodedUuid, ArtifactId accountId, String accountDisplayName, SubscriptionGroupId groupId, String subscriptionName, ActiveDelegate provider) {
            super(encodedUuid, accountId, accountDisplayName, groupId, subscriptionName, false);
            this.provider = provider;
        }

        @Override
        public boolean isActive() {
            return this.provider.isActive(this.getAccountId(), this.getGroupId());
        }
    }

    private static class SubscriptionImpl
    extends NamedIdentity<String>
    implements Subscription {
        private final ArtifactId accountId;
        private final String accountDisplayName;
        private final SubscriptionGroupId groupId;
        private final boolean active;

        private SubscriptionImpl(String encodedUuid, ArtifactId accountId, String accountDisplayName, SubscriptionGroupId groupId, String subscriptionName, boolean active) {
            super((Object)encodedUuid, subscriptionName);
            this.accountId = accountId;
            this.accountDisplayName = accountDisplayName;
            this.groupId = groupId;
            this.active = active;
        }

        public ArtifactId getAccountId() {
            return this.accountId;
        }

        public String getAccountName() {
            return this.accountDisplayName;
        }

        public SubscriptionGroupId getGroupId() {
            return this.groupId;
        }

        public boolean isActive() {
            return this.active;
        }

        public String toString() {
            return "SubscriptionImpl [accountId=" + this.accountId + ", accountDisplayName=" + this.accountDisplayName + ", groupId=" + this.groupId + ", active=" + this.isActive() + "]";
        }

        public Long getId() {
            return null;
        }

        /* synthetic */ SubscriptionImpl(String string, ArtifactId artifactId, String string2, SubscriptionGroupId subscriptionGroupId, String string3, boolean bl, SubscriptionImpl subscriptionImpl, SubscriptionImpl subscriptionImpl2) {
            this(string, artifactId, string2, subscriptionGroupId, string3, bl);
        }
    }
}

