/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.disposition.model.CopySetParamOption;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.report.FindReruns;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class DispoSetCopier {
    private final DispoConnector connector;
    private final List<DispoAnnotationData> needsRerun = new ArrayList<DispoAnnotationData>();
    String batchRunList = "";

    public DispoSetCopier(DispoConnector connector) {
        this.connector = connector;
    }

    public List<DispoItem> copyAllDispositions(Map<String, Set<DispoItemData>> nameToDestItems, Collection<DispoItem> sourceItems, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report) {
        ArrayList<DispoItem> modifiedItems = new ArrayList<DispoItem>();
        for (DispoItem sourceItem : sourceItems) {
            DispoItemData destItem = this.getCorrespondingDestItem(nameToDestItems, sourceItem);
            if (destItem != null) {
                if (!destItem.getStatus().equals("PASS")) {
                    DispoItemData newItem = this.createNewItemWithCopiedAnnotations(destItem, sourceItem, isCoverageCopy, reruns, report);
                    if (newItem == null) continue;
                    modifiedItems.add((DispoItem)newItem);
                    if (newItem.getGuid().equals(sourceItem.getGuid())) continue;
                    List destAnnotationsList = destItem.getAnnotationsList();
                    String message = String.format("Had %s Dispositions now has %s", destAnnotationsList.size(), newItem.getAnnotationsList().size());
                    report.addEntry(destItem.getName(), message, DispoSummarySeverity.UPDATE);
                    continue;
                }
                if (Strings.isValid((String)destItem.getGuid()) || sourceItem.getStatus().equals("PASS")) continue;
                destItem.setGuid((String)sourceItem.getGuid());
                modifiedItems.add((DispoItem)destItem);
                continue;
            }
            report.addEntry(sourceItem.getName(), "No matching item found in the Destination Set", DispoSummarySeverity.WARNING);
        }
        return modifiedItems;
    }

    private DispoItemData getCorrespondingDestItem(Map<String, Set<DispoItemData>> nameToDestItems, DispoItem sourceItem) {
        DispoItemData destItem = null;
        String name = sourceItem.getName();
        Set<DispoItemData> itemsWithSameName = nameToDestItems.get(name);
        if (itemsWithSameName != null) {
            if (itemsWithSameName.size() == 1) {
                destItem = itemsWithSameName.iterator().next();
            } else {
                for (DispoItemData itemWithSameName : itemsWithSameName) {
                    if (!itemWithSameName.getMethodNumber().equals(sourceItem.getMethodNumber()) || !itemWithSameName.getFileNumber().equals(sourceItem.getFileNumber())) continue;
                    destItem = itemWithSameName;
                }
            }
        }
        return destItem;
    }

    private DispoItemData createNewItemWithCopiedAnnotations(DispoItemData destItem, DispoItem sourceItem, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report) {
        DispoItemData toReturn = null;
        boolean isSameDiscrepancies = this.matchAllDiscrepancies(destItem, sourceItem);
        if (!isSameDiscrepancies) {
            report.addEntry(destItem.getName(), String.format("Tried to copy from item id: [%s] but discrepancies were not the same", sourceItem.getGuid()), DispoSummarySeverity.WARNING);
        }
        toReturn = this.buildNewItem(destItem, sourceItem, isCoverageCopy, reruns, report, isSameDiscrepancies);
        return toReturn;
    }

    private DispoItemData buildNewItem(DispoItemData destItem, DispoItem sourceItem, boolean isCoverageCopy, HashMap<String, String> reruns, OperationReport report, boolean isSameDiscrepancies) {
        boolean isChangesMade = false;
        DispoItemData newItem = this.initNewItem(destItem, sourceItem);
        List newAnnotations = newItem.getAnnotationsList();
        List sourceAnnotations = sourceItem.getAnnotationsList();
        Set<String> destDefaultAnntationLocations = this.getDefaultAnnotations(newItem);
        Map<String, Integer> nonDefaultAnnotationLocations = this.getNonDefaultAnnotations(newItem);
        List<String> destDiscrepanciesTextOnly = this.discrepanciesTextOnly(destItem.getDiscrepanciesList());
        for (DispoAnnotationData sourceAnnotation : sourceAnnotations) {
            int nextIndex;
            String sourceLocation = sourceAnnotation.getLocationRefs();
            if (DispoUtil.isDefaultAnotation(sourceAnnotation) || !Strings.isValid((String)sourceAnnotation.getResolutionType())) {
                if (destDefaultAnntationLocations.contains(sourceLocation)) continue;
                if (!nonDefaultAnnotationLocations.containsKey(sourceLocation)) {
                    newItem.setNeedsRerun(true);
                    this.needsRerun.add(sourceAnnotation);
                }
                report.addEntry(destItem.getName(), String.format("Did not copy annotations for location(s) [%s] because they are default annotations", sourceAnnotation.getLocationRefs()), DispoSummarySeverity.IGNORE);
                continue;
            }
            if (destDefaultAnntationLocations.contains(sourceLocation)) {
                report.addEntry(destItem.getName(), String.format("Did not copy annotations for location(s) [%s] because the destination item already has a default annotations at these locations", sourceAnnotation.getLocationRefs()), DispoSummarySeverity.IGNORE);
                continue;
            }
            if (newAnnotations.toString().contains(sourceAnnotation.getGuid())) {
                report.addEntry(destItem.getName(), String.format("Did not copy annotations for location(s) [%s] because the destination item already has this Annotation [%s]", sourceAnnotation.getLocationRefs(), sourceAnnotation.getGuid()), DispoSummarySeverity.IGNORE);
                continue;
            }
            if (!isSameDiscrepancies || !this.isCoveredDiscrepanciesExistInDest(destDiscrepanciesTextOnly, sourceItem, sourceAnnotation, report)) continue;
            DispoAnnotationData newAnnotation = sourceAnnotation;
            if (destDefaultAnntationLocations.contains(sourceLocation)) {
                String locationRefs = sourceAnnotation.getLocationRefs();
                Integer locationRefAsInt = Integer.valueOf(locationRefs);
                if (locationRefAsInt > 0) {
                    newAnnotation.setLocationRefs(String.valueOf(locationRefAsInt * -1));
                }
                report.addEntry(destItem.getName(), String.format("The annotation was copied over but is no longer needed: [%s]", locationRefs), DispoSummarySeverity.WARNING);
            }
            this.connector.connectAnnotation(newAnnotation, newItem.getDiscrepanciesList());
            isChangesMade = true;
            if (nonDefaultAnnotationLocations.containsKey(sourceLocation)) {
                nextIndex = nonDefaultAnnotationLocations.get(sourceLocation);
                newAnnotation.setIndex(nextIndex);
                newAnnotations.set(nextIndex, newAnnotation);
                continue;
            }
            nextIndex = newAnnotations.size();
            newAnnotation.setIndex(nextIndex);
            newAnnotations.add(nextIndex, newAnnotation);
        }
        if (isChangesMade) {
            newItem.setAnnotationsList(newAnnotations);
            String newStatus = this.connector.getItemStatus((DispoItem)newItem);
            newItem.setStatus(newStatus);
        } else if (!isCoverageCopy) {
            newItem = destItem;
            newItem.setGuid((String)sourceItem.getGuid());
        } else if (newItem.getNeedsRerun() != null && newItem.getNeedsRerun().booleanValue()) {
            report.addEntry(destItem.getName(), "Needs Rerun", DispoSummarySeverity.UPDATE);
            if (reruns != null) {
                HashMap<String, String> tmpList = new FindReruns().createList(this.needsRerun);
                for (Map.Entry<String, String> entry : tmpList.entrySet()) {
                    reruns.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            report.addEntry(destItem.getName(), "Nothing to copy", DispoSummarySeverity.IGNORE);
            newItem = null;
        }
        return newItem;
    }

    private boolean isCoveredDiscrepanciesExistInDest(List<String> destDescrepanciesTextOnly, DispoItem sourceItem, DispoAnnotationData annotation, OperationReport report) {
        List idsOfCoveredDiscrepancies = annotation.getIdsOfCoveredDiscrepancies();
        Map sourceDiscrepancies = sourceItem.getDiscrepanciesList();
        for (String id : idsOfCoveredDiscrepancies) {
            Discrepancy coveredDiscrepancy = (Discrepancy)sourceDiscrepancies.get(id);
            if (coveredDiscrepancy != null && destDescrepanciesTextOnly.contains(coveredDiscrepancy.getText())) continue;
            return false;
        }
        return true;
    }

    private List<String> discrepanciesTextOnly(Map<String, Discrepancy> discrepancies) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            toReturn.add(discrepancy.getText());
        }
        return toReturn;
    }

    private DispoItemData initNewItem(DispoItemData destItem, DispoItem sourceItem) {
        DispoItemData newItem = new DispoItemData();
        newItem.setDiscrepanciesList(destItem.getDiscrepanciesList());
        List newList = destItem.getAnnotationsList();
        newItem.setAnnotationsList(newList);
        if (Strings.isValid((String)destItem.getGuid())) {
            newItem.setGuid(destItem.getGuid());
        } else {
            newItem.setGuid((String)sourceItem.getGuid());
        }
        newItem.setName(destItem.getName());
        return newItem;
    }

    private Map<String, Integer> getNonDefaultAnnotations(DispoItemData item) {
        HashMap<String, Integer> nonDefaultAnnotationLocations = new HashMap<String, Integer>();
        ArrayList annotations = item.getAnnotationsList();
        if (annotations == null) {
            annotations = new ArrayList();
        }
        for (DispoAnnotationData annotation : annotations) {
            if (annotation.getIsDefault()) continue;
            nonDefaultAnnotationLocations.put(annotation.getLocationRefs(), annotation.getIndex());
        }
        return nonDefaultAnnotationLocations;
    }

    private Set<String> getDefaultAnnotations(DispoItemData item) {
        HashSet<String> defaultAnnotationLocations = new HashSet<String>();
        ArrayList annotations = item.getAnnotationsList();
        if (annotations == null) {
            annotations = new ArrayList();
        }
        for (DispoAnnotationData annotation : annotations) {
            if (!DispoUtil.isDefaultAnotation(annotation)) continue;
            defaultAnnotationLocations.add(annotation.getLocationRefs());
        }
        return defaultAnnotationLocations;
    }

    private boolean matchAllDiscrepancies(DispoItemData destItem, DispoItem sourceItem) {
        Map<String, String> destLocationToText = this.generateLocationToTextMap((DispoItem)destItem);
        boolean toReturn = true;
        Map sourceDiscrepancies = sourceItem.getDiscrepanciesList();
        for (String key : sourceDiscrepancies.keySet()) {
            Discrepancy sourceDiscrepancy = (Discrepancy)sourceDiscrepancies.get(key);
            String sourceLocation = sourceDiscrepancy.getLocation();
            String destDicrepancyText = destLocationToText.get(sourceLocation);
            if (destDicrepancyText == null) {
                toReturn = false;
                break;
            }
            if (sourceDiscrepancy.getText().equals(destDicrepancyText)) continue;
            toReturn = false;
            break;
        }
        return toReturn;
    }

    private Map<String, String> generateLocationToTextMap(DispoItem item) {
        HashMap<String, String> locationToText = new HashMap<String, String>();
        Map discrepancies = item.getDiscrepanciesList();
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = (Discrepancy)discrepancies.get(key);
            locationToText.put(discrepancy.getLocation(), discrepancy.getText());
        }
        return locationToText;
    }

    public void copyCategories(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newCategory;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (destItem == null) continue;
            String currentCategory = destItem.getCategory();
            String sourceCategory = sourceItem.getCategory();
            if (!Strings.isValid((String)sourceCategory)) continue;
            switch (option) {
                case OVERRIDE: {
                    newCategory = sourceCategory;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (!Strings.isValid((String)currentCategory)) {
                        newCategory = sourceCategory;
                        break;
                    }
                    newCategory = currentCategory;
                    break;
                }
                case MERGE: {
                    if (!Strings.isValid((String)currentCategory)) {
                        newCategory = sourceCategory;
                        break;
                    }
                    newCategory = String.valueOf(currentCategory) + "::" + sourceCategory;
                    break;
                }
                default: {
                    newCategory = currentCategory;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setCategory(newCategory);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setCategory(newCategory);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }

    public void copyAssignee(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newAssignee;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (destItem == null) continue;
            String currentAssignee = destItem.getAssignee();
            String sourceAssignee = sourceItem.getAssignee();
            if (sourceAssignee.equalsIgnoreCase("UNASSIGNED")) continue;
            switch (option) {
                case OVERRIDE: {
                    newAssignee = sourceAssignee;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (currentAssignee.equalsIgnoreCase("UNASSIGNED")) {
                        newAssignee = sourceAssignee;
                        break;
                    }
                    newAssignee = currentAssignee;
                    break;
                }
                default: {
                    newAssignee = currentAssignee;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setAssignee(newAssignee);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setAssignee(newAssignee);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }

    public void copyNotes(Map<String, Set<DispoItemData>> destinationItems, Collection<DispoItem> sourceItems, Map<String, DispoItem> toEdit, CopySetParamOption option) {
        for (DispoItem sourceItem : sourceItems) {
            String newItemNotes;
            DispoItemData destItem = this.getCorrespondingDestItem(destinationItems, sourceItem);
            if (destItem == null) continue;
            String currentItemNotes = destItem.getItemNotes();
            String sourceItemNotes = sourceItem.getItemNotes();
            if (!Strings.isValid((String)sourceItemNotes)) continue;
            switch (option) {
                case OVERRIDE: {
                    newItemNotes = sourceItemNotes;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (!Strings.isValid((String)currentItemNotes)) {
                        newItemNotes = sourceItemNotes;
                        break;
                    }
                    newItemNotes = currentItemNotes;
                    break;
                }
                case MERGE: {
                    if (!Strings.isValid((String)currentItemNotes)) {
                        newItemNotes = sourceItemNotes;
                        break;
                    }
                    newItemNotes = String.valueOf(currentItemNotes) + "::" + sourceItemNotes;
                    break;
                }
                default: {
                    newItemNotes = currentItemNotes;
                }
            }
            DispoItem matchingToEdit = toEdit.get(sourceItem.getName());
            if (matchingToEdit != null) {
                ((DispoItemData)matchingToEdit).setItemNotes(newItemNotes);
                continue;
            }
            DispoItemData newToEdit = new DispoItemData();
            newToEdit.setGuid((String)destItem.getGuid());
            newToEdit.setName(destItem.getName());
            newToEdit.setItemNotes(newItemNotes);
            toEdit.put(newToEdit.getName(), (DispoItem)newToEdit);
        }
    }
}

