/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.TmoImporter;
import org.eclipse.osee.disposition.rest.internal.importer.TmzImporter;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.LisFileParser;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.logger.Log;

public class DispoImporterFactory {
    private final DispoDataFactory dataFactory;
    private final ExecutorAdmin executor;
    private final Log logger;
    private final DispoApiConfiguration config;

    public DispoImporterFactory(DispoDataFactory dataFactory, ExecutorAdmin executor, DispoApiConfiguration config, Log logger) {
        this.dataFactory = dataFactory;
        this.executor = executor;
        this.logger = logger;
        this.config = config;
    }

    public DispoImporterApi createImporter(ImportFormat format, DispoConnector connector) {
        switch (format) {
            case TMO: {
                return new TmoImporter(this.dataFactory, this.executor, this.logger);
            }
            case TMZ: {
                return new TmzImporter(this.logger, this.dataFactory);
            }
            case LIS: {
                return new LisFileParser(this.logger, this.dataFactory, this.config, connector);
            }
        }
        throw new OseeArgumentException("Unsupported format type: [%s]", new Object[]{format});
    }

    public static enum ImportFormat {
        TMO,
        TMZ,
        LIS;

    }
}

