/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.DispoConfig;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoStorageMetadata;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.internal.DispoConfigArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoItemArtifact;
import org.eclipse.osee.disposition.rest.internal.DispoSetArtifact;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageUtil;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class OrcsStorageImpl
implements Storage {
    private final Log logger;
    private final OrcsApi orcsApi;
    public static final IOseeBranch dispoParent = IOseeBranch.create((long)5781701693103907161L, (String)"Dispo Parent");

    public OrcsStorageImpl(Log logger, OrcsApi orcsApi) {
        this.logger = logger;
        this.orcsApi = orcsApi;
    }

    private QueryFactory getQuery() {
        return this.orcsApi.getQueryFactory();
    }

    private TransactionFactory getTxFactory() {
        return this.orcsApi.getTransactionFactory();
    }

    private OrcsBranch getBranchFactory() {
        return this.orcsApi.getBranchOps();
    }

    private void reloadTypes() {
        this.orcsApi.getOrcsTypes().invalidateAll();
    }

    @Override
    public boolean typesExist() {
        try {
            return ((ArtifactReadable)this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)DispoConstants.DISPO_ARTIFACT).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).isValid();
        }
        catch (OseeCoreException ex) {
            this.logger.warn((Throwable)ex, "Error checking for Dispo Types", new Object[0]);
            return false;
        }
    }

    @Override
    public void storeTypes(IResource resource) {
        TransactionBuilder tx = this.getTxFactory().createTransaction((BranchId)CoreBranches.COMMON, (UserId)SystemUser.OseeSystem, "Initialize Dispo Types");
        ArtifactToken artifactId = tx.createArtifact(DispoConstants.DISPO_ARTIFACT);
        InputStream stream = null;
        try {
            stream = resource.getContent();
            tx.setSoleAttributeFromStream((ArtifactId)artifactId, (AttributeTypeToken)CoreAttributeTypes.UriGeneralStringData, stream);
        }
        finally {
            Lib.close((AutoCloseable)stream);
        }
        tx.commit();
        this.reloadTypes();
    }

    @Override
    public UserId findUser() {
        return SystemUser.OseeSystem;
    }

    @Override
    public UserId findUser(String userId) {
        return UserId.valueOf((String)userId);
    }

    @Override
    public boolean isUniqueProgramName(String name) {
        return ((BranchQuery)this.getQuery().branchQuery().andNameEquals(name)).getResults().isEmpty();
    }

    @Override
    public boolean isUniqueSetName(BranchId branch, String name) {
        ResultSet results = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispositionSet}).andNameEquals(name).getResults();
        return results.isEmpty();
    }

    @Override
    public boolean isUniqueItemName(BranchId branch, String setId, String name) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId);
        ResultSet results = this.getQuery().fromBranch(branch).andRelatedTo(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)setArt).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispositionableItem}).andNameEquals(name).getResults();
        return results.isEmpty();
    }

    @Override
    public IOseeBranch findDispoProgramIdByName(String branchName) {
        List<IOseeBranch> dispoPrograms = this.getDispoBranches();
        IOseeBranch branchId = null;
        String allItems = "";
        int count = 0;
        for (IOseeBranch branch : dispoPrograms) {
            if (!branch.getName().equals(branchName)) continue;
            allItems = String.valueOf(allItems) + branch.getIdString() + '\n';
            ++count;
            branchId = branch;
        }
        if (count > 1) {
            throw new OseeCoreException("Multiple items found - total [%s]\n%s", new Object[]{count, allItems});
        }
        if (count < 1) {
            throw new OseeCoreException("No item found", new Object[0]);
        }
        return branchId;
    }

    @Override
    public String findDispoSetIdByName(BranchId branchId, String setName) {
        List<DispoSet> dispoSets = this.findDispoSets(branchId, "codeCoverage");
        for (DispoSet set : dispoSets) {
            if (!set.getName().equals(setName)) continue;
            return (String)set.getGuid();
        }
        return null;
    }

    @Override
    public List<DispoSet> findDispoSets(BranchId branch, String type) {
        ResultSet results = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispositionSet}).getResults();
        ArrayList<DispoSet> toReturn = new ArrayList<DispoSet>();
        for (ArtifactReadable art : results) {
            DispoSetArtifact dispoSetArt = new DispoSetArtifact(art);
            if (!dispoSetArt.getDispoType().equals(type)) continue;
            toReturn.add(dispoSetArt);
        }
        return toReturn;
    }

    @Override
    public DispoSet findDispoSetsById(BranchId branch, String setId) {
        ArtifactReadable result = this.findDispoArtifact(branch, setId);
        return new DispoSetArtifact(result);
    }

    private ArtifactReadable findDispoArtifact(BranchId branch, String artId) {
        return (ArtifactReadable)this.getQuery().fromBranch(branch).andUuid(Long.valueOf(artId).longValue()).getResults().getExactlyOne();
    }

    @Override
    public List<DispoItem> findDispoItems(BranchId branch, String setId, boolean isDetailed) {
        ArtifactReadable setArt = this.findDispoArtifact(branch, setId);
        ArrayList<DispoItem> toReturn = new ArrayList<DispoItem>();
        for (ArtifactReadable art : setArt.getChildren()) {
            DispoItemArtifact dispoItemArtifact = new DispoItemArtifact(art);
            dispoItemArtifact.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItemArtifact);
        }
        return toReturn;
    }

    @Override
    public Long createDispoProgram(UserId author, String name) {
        IOseeBranch branch = IOseeBranch.create((String)name);
        this.getBranchFactory().createWorkingBranch(branch, (ArtifactId)author, dispoParent, ArtifactId.SENTINEL);
        return branch.getId();
    }

    @Override
    public Long createDispoSet(UserId author, BranchId branch, DispoSet descriptor) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Create Dispo Set");
        ArtifactToken creatdArtId = tx.createArtifact(DispoConstants.DispositionSet, descriptor.getName());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoImportPath, (Object)descriptor.getImportPath());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoImportState, (Object)descriptor.getImportState());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoConfig, (Object)descriptor.getDispoType());
        tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoNotesJson, (Object)JsonUtil.toJson((Object)descriptor.getNotesList()));
        if (descriptor.getCiSet() == null) {
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoCiSet, (Object)"NOCI");
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoRerunList, (Object)"NOCI");
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoTime, (Object)new Date());
        } else {
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoCiSet, (Object)descriptor.getCiSet());
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoRerunList, (Object)descriptor.getRerunList());
            tx.setSoleAttributeValue((ArtifactId)creatdArtId, (AttributeTypeToken)DispoConstants.DispoTime, (Object)descriptor.getTime());
        }
        tx.commit();
        return creatdArtId.getUuid();
    }

    @Override
    public boolean deleteDispoSet(UserId author, BranchId branch, String setId) {
        return this.deleteDispoEntityArtifact(author, branch, setId, DispoConstants.DispositionSet);
    }

    @Override
    public boolean deleteDispoItem(UserId author, BranchId branch, String itemId) {
        return this.deleteDispoEntityArtifact(author, branch, itemId, DispoConstants.DispositionableItem);
    }

    private boolean deleteDispoEntityArtifact(UserId author, BranchId branch, String entityId, ArtifactTypeToken type) {
        boolean toReturn = false;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, entityId);
        if (dispoArtifact != null) {
            TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Delete Dispo Artifact");
            tx.deleteArtifact((ArtifactId)dispoArtifact);
            tx.commit();
            toReturn = true;
        }
        return toReturn;
    }

    @Override
    public void updateDispoSet(UserId author, BranchId branch, String setId, DispoSet newData) {
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId);
        DispoSetArtifact origSetAs = new DispoSetArtifact(dispoSet);
        String name = newData.getName();
        String importPath = newData.getImportPath();
        String ciSet = newData.getCiSet();
        String rerunList = newData.getRerunList();
        Date time = newData.getTime();
        List notesList = new LinkedList();
        if (newData.getNotesList() != null) {
            notesList = newData.getNotesList();
        }
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Update Dispo Set");
        if (name != null && !name.equals(origSetAs.getName())) {
            tx.setName((ArtifactId)dispoSet, name);
        }
        if (importPath != null && !importPath.equals(origSetAs.getImportPath())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoImportPath, importPath);
        }
        if (notesList != null && !notesList.equals(origSetAs.getNotesList())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoNotesJson, JsonUtil.toJson(origSetAs.getNotesList()));
        }
        if (ciSet != null && !ciSet.equals(origSetAs.getCiSet())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoCiSet, ciSet);
        }
        if (rerunList != null && !rerunList.equals(origSetAs.getRerunList())) {
            tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoRerunList, rerunList);
        }
        if (time != null && !time.equals(origSetAs.getTime())) {
            tx.setSoleAttributeValue((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoTime, (Object)time);
        }
        tx.commit();
    }

    @Override
    public void createDispoItems(UserId author, BranchId branch, DispoSet parentSet, List<DispoItem> data) {
        ArtifactReadable parentSetArt = this.findDispoArtifact(branch, (String)parentSet.getGuid());
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Create Dispoable Item");
        for (DispoItem item : data) {
            ArtifactToken createdItem = tx.createArtifact(DispoConstants.DispositionableItem, item.getName());
            if (item.getCreationDate() == null) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoDateCreated, (Object)new Date());
            } else {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoDateCreated, (Object)item.getCreationDate());
            }
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemLastUpdated, (Object)item.getLastUpdate());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemStatus, (Object)item.getStatus());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemTotalPoints, (Object)item.getTotalPoints());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemNeedsRerun, (Object)item.getNeedsRerun());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemAborted, (Object)item.getAborted());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoDiscrepanciesJson, (Object)JsonUtil.toJson((Object)item.getDiscrepanciesList()));
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoAnnotationsJson, (Object)JsonUtil.toJson((Object)item.getAnnotationsList()));
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemVersion, (Object)item.getVersion());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemAssignee, (Object)item.getAssignee());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemMachine, (Object)item.getMachine());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemCategory, (Object)item.getCategory());
            tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemElapsedTime, (Object)item.getElapsedTime());
            if (Strings.isValid((String)item.getFileNumber())) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemFileNumber, (Object)item.getFileNumber());
            }
            if (Strings.isValid((String)item.getMethodNumber())) {
                tx.setSoleAttributeValue((ArtifactId)createdItem, (AttributeTypeToken)DispoConstants.DispoItemMethodNumber, (Object)item.getMethodNumber());
            }
            tx.relate((ArtifactId)parentSetArt, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)createdItem);
        }
        tx.commit();
    }

    private void updateSingleItem(ArtifactReadable currentItemArt, DispoItem newItemData, TransactionBuilder tx, boolean resetRerunFlag, DispoStorageMetadata metadata) {
        Date lastUpdate = newItemData.getLastUpdate();
        String name = newItemData.getName();
        Map newDiscrepancies = newItemData.getDiscrepanciesList();
        List newAnnotations = newItemData.getAnnotationsList();
        String status = newItemData.getStatus();
        String assignee = newItemData.getAssignee();
        String totalPoints = newItemData.getTotalPoints();
        String machine = newItemData.getMachine();
        String category = newItemData.getCategory();
        String elapsedTime = newItemData.getElapsedTime();
        Boolean aborted = newItemData.getAborted();
        String itemNotes = newItemData.getItemNotes();
        String fileNumber = newItemData.getFileNumber();
        String methodNumber = newItemData.getMethodNumber();
        String team = newItemData.getTeam();
        Boolean needsRerun = resetRerunFlag ? Boolean.valueOf(false) : newItemData.getNeedsRerun();
        DispoItemArtifact origItem = new DispoItemArtifact(currentItemArt);
        if (name != null && !name.equals(origItem.getName())) {
            tx.setName((ArtifactId)currentItemArt, name);
        }
        if (newDiscrepancies != null && !newDiscrepancies.equals(origItem.getDiscrepanciesList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoDiscrepanciesJson, JsonUtil.toJson((Object)newDiscrepancies));
        }
        if (newAnnotations != null && !newAnnotations.equals(origItem.getAnnotationsList())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoAnnotationsJson, JsonUtil.toJson((Object)newAnnotations));
        }
        if (assignee != null && !assignee.equals(origItem.getAssignee())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemAssignee, assignee);
        }
        if (status != null && !status.equals(origItem.getStatus())) {
            metadata.addIdOfUpdatedItem((String)newItemData.getGuid());
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemStatus, status);
        }
        if (lastUpdate != null && !lastUpdate.equals(origItem.getLastUpdate())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemLastUpdated, (Object)lastUpdate);
        }
        if (needsRerun != null && !needsRerun.equals(origItem.getNeedsRerun())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemNeedsRerun, (Object)needsRerun);
        }
        if (totalPoints != null && !totalPoints.equals(origItem.getTotalPoints())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemTotalPoints, totalPoints);
        }
        if (machine != null && !machine.equals(origItem.getMachine())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemMachine, machine);
        }
        if (category != null && !category.equals(origItem.getCategory())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemCategory, category);
        }
        if (elapsedTime != null && !elapsedTime.equals(origItem.getElapsedTime())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemElapsedTime, elapsedTime);
        }
        if (aborted != null && !aborted.equals(origItem.getAborted())) {
            tx.setSoleAttributeValue((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemAborted, (Object)aborted);
        }
        if (itemNotes != null && !itemNotes.equals(origItem.getItemNotes())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemNotes, itemNotes);
        }
        if (fileNumber != null && !fileNumber.equals(origItem.getFileNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemFileNumber, fileNumber);
        }
        if (methodNumber != null && !methodNumber.equals(origItem.getMethodNumber())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemMethodNumber, methodNumber);
        }
        if (team != null && !team.equals(origItem.getTeam())) {
            tx.setSoleAttributeFromString((ArtifactId)currentItemArt, (AttributeTypeToken)DispoConstants.DispoItemTeam, team);
        }
    }

    @Override
    public void updateDispoItem(UserId author, BranchId branch, String dispoItemId, DispoItem data, DispoStorageMetadata metadata) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Update Dispo Item");
        ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, dispoItemId);
        this.updateSingleItem(dispoItemArt, data, tx, false, metadata);
        tx.commit();
    }

    @Override
    public void updateDispoItems(UserId author, BranchId branch, Collection<DispoItem> data, boolean resetRerunFlag, String operation, DispoStorageMetadata metadata) {
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, operation);
        boolean isCommitNeeded = false;
        for (DispoItem newItem : data) {
            String itemId = (String)newItem.getGuid();
            if (!Strings.isValid((String)itemId)) continue;
            isCommitNeeded = true;
            ArtifactReadable dispoItemArt = this.findDispoArtifact(branch, (String)newItem.getGuid());
            this.updateSingleItem(dispoItemArt, newItem, tx, resetRerunFlag, metadata);
        }
        if (isCommitNeeded) {
            tx.commit();
        }
    }

    @Override
    public List<IOseeBranch> getDispoBranches() {
        ArrayList<IOseeBranch> dispoBranchesNormalized = new ArrayList<IOseeBranch>();
        ResultSet dispoBranches = ((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsOfType(new BranchType[]{BranchType.WORKING})).andIsChildOf((BranchId)dispoParent)).getResultsAsId();
        for (IOseeBranch branch : dispoBranches) {
            IOseeBranch newName = IOseeBranch.create((BranchId)branch, (String)branch.getName().replaceFirst("\\(DISPO\\)", ""));
            dispoBranchesNormalized.add(newName);
        }
        return dispoBranchesNormalized;
    }

    @Override
    public List<String> getCheckedReruns(HashMap<String, DispoItem> items, String setId) {
        ArrayList<String> reruns = new ArrayList<String>();
        ArrayList<DispoItem> dispoItems = new ArrayList<DispoItem>(items.values());
        for (DispoItem item : dispoItems) {
            if (!item.getNeedsRerun().booleanValue()) continue;
            reruns.add(item.getName());
        }
        return reruns;
    }

    @Override
    public Collection<DispoItem> findDispoItemByAnnoationText(BranchId branch, String setId, String keyword, boolean isDetailed) {
        ArtifactReadable dispoSetArt = this.findDispoArtifact(branch, setId);
        HashSet<DispoItem> toReturn = new HashSet<DispoItem>();
        ResultSet dispoArtifacts = this.getQuery().fromBranch(branch).andTypeEquals(new ArtifactTypeId[]{DispoConstants.DispositionableItem}).andRelatedTo(CoreRelationTypes.Default_Hierarchical__Parent, (ArtifactId)dispoSetArt).and((AttributeTypeId)DispoConstants.DispoAnnotationsJson, keyword, QueryOption.CONTAINS_MATCH_OPTIONS).getResults();
        for (ArtifactReadable art : dispoArtifacts) {
            DispoItemArtifact dispoItem = new DispoItemArtifact(art);
            dispoItem.setIsIncludeDetails(isDetailed);
            toReturn.add(dispoItem);
        }
        return toReturn;
    }

    @Override
    public DispoItem findDispoItemById(BranchId branch, String itemId) {
        DispoItemArtifact toReturn = null;
        ArtifactReadable dispoArtifact = this.findDispoArtifact(branch, itemId);
        if (dispoArtifact.isValid()) {
            toReturn = new DispoItemArtifact(dispoArtifact);
        }
        return toReturn;
    }

    @Override
    public String findDispoItemIdByName(BranchId branchId, String setId, String itemName) {
        List<DispoItem> dispoItems = this.findDispoItems(branchId, setId, false);
        for (DispoItem item : dispoItems) {
            if (!item.getName().equals(itemName)) continue;
            return (String)item.getGuid();
        }
        return null;
    }

    @Override
    public DispoConfig findDispoConfig(BranchId branch) {
        ArtifactReadable config = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Program Config").getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (config.isInvalid()) {
            return DispoUtil.getDefaultConfig();
        }
        return DispoUtil.configArtToConfigData(new DispoConfigArtifact(config));
    }

    @Override
    public String createDispoReport(BranchId branch, UserId author, String contents, String operationTitle) {
        String toReturn = "";
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Update Report: " + operationTitle);
        ArtifactReadable reportArt = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report").getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (reportArt.isInvalid()) {
            TransactionBuilder txToCreate = this.getTxFactory().createTransaction(branch, author, "Add Operation Report Art");
            txToCreate.createArtifact(CoreArtifactTypes.GeneralData, "Dispo_Report");
            txToCreate.commit();
            reportArt = (ArtifactReadable)this.getQuery().fromBranch(branch).andNameEquals("Dispo_Report").getResults().getExactlyOne();
        }
        tx.setSoleAttributeFromString((ArtifactId)reportArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, contents);
        TransactionToken commit = tx.commit();
        if (commit.isValid()) {
            ArtifactReadable newRerpotArt = (ArtifactReadable)this.getQuery().fromBranch(branch).fromTransaction((TransactionId)commit).andId((ArtifactId)reportArt).getResults().getExactlyOne();
            AttributeReadable contentsAsAttribute = (AttributeReadable)newRerpotArt.getAttributes((AttributeTypeId)CoreAttributeTypes.GeneralStringData).getExactlyOne();
            toReturn = String.format("/orcs/branch/%s/artifact/%s/attribute/%s/version/%s", branch, newRerpotArt.getGuid(), contentsAsAttribute.getId(), commit.getId());
        }
        return toReturn;
    }

    @Override
    public Map<String, ArtifactReadable> getCoverageUnits(BranchId branchId, Long artifactUuid) {
        ArtifactReadable coveragePackage = (ArtifactReadable)this.getQuery().fromBranch(branchId).andUuid(artifactUuid.longValue()).getResults().getExactlyOne();
        List descendants = coveragePackage.getDescendants();
        return this.getChildrenRecurse(descendants);
    }

    private Map<String, ArtifactReadable> getChildrenRecurse(List<ArtifactReadable> descendants) {
        HashMap<String, ArtifactReadable> toReturn = new HashMap<String, ArtifactReadable>();
        for (ArtifactReadable descendant : descendants) {
            if (descendant.getAttributeValues((AttributeTypeToken)CoverageUtil.CoverageItem).isEmpty()) continue;
            ArtifactReadable parent = descendant.getParent();
            String fullName = String.format("%s.%s", parent.getName(), descendant.getName());
            toReturn.put(fullName, descendant);
        }
        return toReturn;
    }

    @Override
    public void updateOperationSummary(UserId author, BranchId branch, String setId, OperationReport summary) {
        OperationReport newReport = DispoUtil.cleanOperationReport(summary);
        ArtifactReadable dispoSet = this.findDispoArtifact(branch, setId);
        TransactionBuilder tx = this.getTxFactory().createTransaction(branch, author, "Update Dispo Operation Report");
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoImportState, newReport.getStatus().getName());
        tx.setSoleAttributeFromString((ArtifactId)dispoSet, (AttributeTypeToken)DispoConstants.DispoOperationSummary, DispoUtil.operationReportToString(newReport));
        tx.commit();
    }

    @Override
    public Long getDispoItemParentSet(BranchId branch, String itemId) {
        ArtifactReadable artifact = this.findDispoArtifact(branch, itemId);
        return artifact.getParent().getUuid();
    }

    @Override
    public HashMap<ArtifactReadable, BranchId> getCiSet(CiSetData setData) {
        HashMap<ArtifactReadable, BranchId> set = new HashMap<ArtifactReadable, BranchId>();
        BranchId branch = BranchId.valueOf((String)setData.getBranchId());
        List<ArtifactReadable> arts = this.findDispoSet(branch, ArtifactId.valueOf((String)setData.getDispoSetId()));
        for (ArtifactReadable art : arts) {
            set.put(art, branch);
        }
        return set;
    }

    @Override
    public String getDispoItemId(BranchId branch, String setId, String item) {
        ArtifactReadable DispoSet2 = (ArtifactReadable)this.getQuery().fromBranch(branch).andId(ArtifactId.valueOf((String)setId)).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (DispoSet2.isInvalid()) {
            return "";
        }
        for (ArtifactReadable child : DispoSet2.getChildren()) {
            if (!child.getName().equals(item)) continue;
            return child.getIdString();
        }
        return "";
    }

    @Override
    public List<CiSetData> getAllCiSets() {
        ArrayList<CiSetData> setData = new ArrayList<CiSetData>();
        List<Branch> dispoBranches = this.findDispoBranches();
        for (BranchId branchId : dispoBranches) {
            for (ArtifactReadable dispoSet : this.findAllCiSets(branchId)) {
                String ciSet = (String)dispoSet.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoCiSet, (Object)"");
                if (ciSet.isEmpty()) continue;
                CiSetData set = new CiSetData();
                set.setBranchId(branchId.getIdString());
                set.setDispoSetId(dispoSet.getIdString());
                set.setCiSetName(ciSet);
                setData.add(set);
            }
        }
        return setData;
    }

    private List<ArtifactReadable> findDispoSet(BranchId branch, ArtifactId setId) {
        return this.getQuery().fromBranch(branch).andId(setId).getResults().getList();
    }

    private List<Branch> findDispoBranches() {
        Branch dispoParent = (Branch)((BranchQuery)this.getQuery().branchQuery().andNameEquals("Dispo Parent")).getResults().getOneOrDefault((Object)Branch.SENTINEL);
        return ((BranchQuery)((BranchQuery)((BranchQuery)this.getQuery().branchQuery().andIsChildOf((BranchId)dispoParent)).excludeArchived()).excludeDeleted()).getResults().getList();
    }

    private List<ArtifactReadable> findAllCiSets(BranchId branch) {
        return this.getQuery().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{DispoConstants.DispositionSet}).andExists(new AttributeTypeId[]{DispoConstants.DispoCiSet}).getResults().getList();
    }

    @Override
    public UserId findUserByName(String name) {
        ArtifactToken userArtId = this.getQuery().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andNameEquals(name).asArtifactTokenOrSentinel();
        UserId user = UserId.valueOf((ArtifactId)userArtId);
        if (user.isInvalid()) {
            user = this.findUser();
        }
        return user;
    }
}

