/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class DispoItemArtifact
extends BaseIdentity<String>
implements DispoItem {
    private final ArtifactReadable artifact;
    private Boolean isIncludeDetails;

    public DispoItemArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public void setIsIncludeDetails(Boolean isIncludeDetails) {
        this.isIncludeDetails = isIncludeDetails;
    }

    public Boolean getIsIncludeDetails() {
        return this.isIncludeDetails;
    }

    public Map<String, Discrepancy> getDiscrepanciesList() {
        String discrepanciesJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoDiscrepanciesJson, "{}");
        return DispoUtil.jsonStringToDiscrepanciesMap(discrepanciesJson);
    }

    public List<DispoAnnotationData> getAnnotationsList() {
        String annotationsList = this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoAnnotationsJson, "[]");
        return DispoUtil.jsonStringToList(annotationsList, DispoAnnotationData.class);
    }

    public String toString() {
        return this.getName();
    }

    public String getAssignee() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemAssignee, "");
    }

    public Date getCreationDate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoDateCreated);
    }

    public Date getLastUpdate() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoItemLastUpdated);
    }

    public String getStatus() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemStatus);
    }

    public String getVersion() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemVersion);
    }

    public Boolean getNeedsRerun() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoItemNeedsRerun, (Object)false);
    }

    public String getTotalPoints() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemTotalPoints, "0");
    }

    public String getMachine() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemMachine, "n/a");
    }

    public String getCategory() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemCategory, "");
    }

    public String getElapsedTime() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemElapsedTime, "0.0");
    }

    public Boolean getAborted() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoItemAborted, (Object)false);
    }

    public String getItemNotes() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemNotes, "");
    }

    public String getMethodNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemMethodNumber, "");
    }

    public String getFileNumber() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemFileNumber, "");
    }

    public Boolean getNeedsReview() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoItemNeedsReview, (Object)false);
    }

    public String getTeam() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoItemTeam, "");
    }
}

