/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;

public final class PurgeRelationTypeDatabaseTxCallable
extends AbstractDatastoreTxCallable<Void> {
    private static final String RETRIEVE_GAMMAS_OF_REL_LINK_TXS = "SELECT rel_link.gamma_id FROM osee_relation_link rel_link WHERE rel_link.rel_link_type_id = ?";
    private static final String DELETE_BY_GAMMAS = "DELETE FROM %s WHERE gamma_id = ?";
    private static final String DELETE_FROM_CONFLICT_TABLE_SOURCE_SIDE = "DELETE FROM osee_conflict WHERE source_gamma_id = ?";
    private static final String DELETE_FROM_CONFLICT_TABLE_DEST_SIDE = "DELETE FROM osee_conflict WHERE dest_gamma_id = ?";
    private final Collection<? extends IRelationType> typesToPurge;

    public PurgeRelationTypeDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, Collection<? extends IRelationType> typesToPurge) {
        super(logger, session, jdbcClient);
        this.typesToPurge = typesToPurge;
    }

    @Override
    protected Void handleTxWork(JdbcConnection connection) {
        List<Object[]> gammaIds = this.retrieveGammaIds(connection, this.typesToPurge);
        this.processDeletes(connection, gammaIds);
        return null;
    }

    private List<Object[]> retrieveGammaIds(JdbcConnection connection, Collection<? extends IRelationType> types) {
        ArrayList<Object[]> gammas = new ArrayList<Object[]>(50000);
        try (JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);){
            for (IRelationType iRelationType : types) {
                chStmt.runPreparedQuery(RETRIEVE_GAMMAS_OF_REL_LINK_TXS, new Object[]{iRelationType});
                while (chStmt.next()) {
                    gammas.add(new Long[]{chStmt.getLong("gamma_id")});
                }
            }
        }
        return gammas;
    }

    private void processDeletes(JdbcConnection connection, List<Object[]> gammas) {
        this.getJdbcClient().runBatchUpdate(connection, String.format(DELETE_BY_GAMMAS, "osee_txs"), gammas);
        this.getJdbcClient().runBatchUpdate(connection, String.format(DELETE_BY_GAMMAS, "osee_txs_archived"), gammas);
        this.getJdbcClient().runBatchUpdate(connection, String.format(DELETE_BY_GAMMAS, "osee_relation_link"), gammas);
        this.getJdbcClient().runBatchUpdate(connection, String.format(DELETE_FROM_CONFLICT_TABLE_SOURCE_SIDE, new Object[0]), gammas);
        this.getJdbcClient().runBatchUpdate(connection, String.format(DELETE_FROM_CONFLICT_TABLE_DEST_SIDE, new Object[0]), gammas);
    }
}

