/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal;

import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.callable.FetchDatastoreInfoCallable;
import org.eclipse.osee.orcs.db.internal.callable.MigrateDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.resource.ResourceConstants;
import org.eclipse.osee.orcs.db.internal.util.DynamicSchemaResourceProvider;

public class AdminModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final IdentityManager identityService;
    private final SystemPreferences preferences;
    private final OrcsTypesDataStore typesDataStore;

    public AdminModule(Log logger, JdbcClient jdbcClient, IdentityManager identityService, SystemPreferences preferences, OrcsTypesDataStore typesDataStore) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.identityService = identityService;
        this.preferences = preferences;
        this.typesDataStore = typesDataStore;
    }

    public DataStoreAdmin createDataStoreAdmin() {
        return new DataStoreAdmin(){

            public void createDataStore() {
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                JdbcMigrationOptions options = new JdbcMigrationOptions(true, true);
                Conditions.checkExpressionFailOnTrue((boolean)AdminModule.this.jdbcClient.getConfig().isProduction(), (String)"Error - attempting to initialize a production datastore.", (Object[])new Object[0]);
                AdminModule.this.jdbcClient.migrate(options, (Iterable)schemaProvider.get());
                String attributeDataPath = ResourceConstants.getAttributeDataPath(AdminModule.this.preferences);
                AdminModule.this.logger.info("Deleting application server binary data [%s]...", new Object[]{attributeDataPath});
                Lib.deleteDir((File)new File(attributeDataPath));
                AdminModule.this.preferences.putValue("osee.db.guid", GUID.create());
                this.addDefaultPermissions();
                AdminModule.this.identityService.invalidateIds();
            }

            private void addDefaultPermissions() {
                LinkedList<Object[]> data = new LinkedList<Object[]>();
                PermissionEnum[] permissionEnumArray = PermissionEnum.values();
                int n = permissionEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PermissionEnum permission = permissionEnumArray[n2];
                    data.add(new Object[]{permission.getPermId(), permission.getName()});
                    ++n2;
                }
                AdminModule.this.jdbcClient.runBatchUpdate("INSERT INTO OSEE_PERMISSION (PERMISSION_ID, PERMISSION_NAME) VALUES (?,?)", data);
            }

            public Callable<DataStoreInfo> migrateDataStore(OrcsSession session) {
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                JdbcMigrationOptions options = new JdbcMigrationOptions(false, false);
                return new MigrateDatastoreCallable(session, AdminModule.this.logger, AdminModule.this.jdbcClient, AdminModule.this.preferences, schemaProvider, options);
            }

            public Callable<DataStoreInfo> getDataStoreInfo(OrcsSession session) {
                DynamicSchemaResourceProvider schemaProvider = new DynamicSchemaResourceProvider(AdminModule.this.logger);
                return new FetchDatastoreInfoCallable(AdminModule.this.logger, AdminModule.this.jdbcClient, schemaProvider, AdminModule.this.preferences);
            }

            public boolean isDataStoreInitialized() {
                try {
                    IResource resource;
                    String systemUuid;
                    boolean initialized = AdminModule.this.typesDataStore.isTypesResourcesValid();
                    if (initialized && Strings.isValid((String)(systemUuid = AdminModule.this.preferences.getSystemUuid())) && (resource = AdminModule.this.typesDataStore.getOrcsTypesLoader(null)) != null) {
                        initialized = true;
                    }
                    return initialized;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public JdbcClient getJdbcClient() {
                return AdminModule.this.jdbcClient;
            }
        };
    }
}

