/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class JdbcConstants {
    private static final String EMBEDDED_JDBC_SERVER_CLASSNAME = "org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlJdbcServer";
    public static final String NAMESPACE = "jdbc";
    public static final String CLIENT_NAMESPACE = JdbcConstants.qualify("client");
    public static final String SERVER_NAMESPACE = JdbcConstants.qualify("server");
    private static final String POOL_NAMESPACE = JdbcConstants.qualifyClient("connection.pool");
    public static final String DB_USERNAME_KEY = "user";
    public static final String DB_PASSWORD_KEY = "password";
    public static final int JDBC__MAX_VARCHAR_LENGTH = 4000;
    public static final int JDBC__MAX_FETCH_SIZE = 10000;
    public static final int JDBC__MAX_TX_ROW_COUNT = 47662;
    public static final int DEFAULT_JDBC__CONNECTION_POOL_SIZE = 10;
    public static final String JDBC__IS_PRODUCTION_DB = JdbcConstants.qualifyClient("is.production");
    public static final String JDBC__CONNECTION_DRIVER = JdbcConstants.qualifyClient("driver");
    public static final String JDBC__CONNECTION_URI = JdbcConstants.qualifyClient("db.uri");
    public static final String JDBC__CONNECTION_APPEND_PROPS_TO_URI = JdbcConstants.qualifyClient("db.append.props.to.uri");
    public static final String JDBC__CONNECTION_USERNAME = JdbcConstants.qualifyClient("db.username");
    public static final String JDBC__CONNECTION_PASSWORD = JdbcConstants.qualifyClient("db.password");
    public static final String JDBC_POOL__ENABLED = JdbcConstants.qualifyPool("enabled");
    public static final String JDBC_POOL__CONFIG_FILE_URI = JdbcConstants.qualifyPool("config.file.uri");
    public static final String JDBC_POOL__PREPARED_STATEMENTS_ALLOWED = JdbcConstants.qualifyPool("prepared.statements.allowed");
    public static final String JDBC_POOL__VALIDATION_QUERY_TIMEOUT_SECS = JdbcConstants.qualifyPool("validation.query.timeout.secs");
    public static final String JDBC_POOL__MAX_ACTIVE_CONNECTIONS = JdbcConstants.qualifyPool("max.active.connections");
    public static final String JDBC_POOL__MAX_IDLE_CONNECTIONS = JdbcConstants.qualifyPool("max.idle.connections");
    public static final String JDBC_POOL__MIN_IDLE_CONNECTIONS = JdbcConstants.qualifyPool("min.idle.connections");
    public static final String JDBC_POOL__MAX_WAIT_CONNECTIONS = JdbcConstants.qualifyPool("max.wait.for.connections");
    public static final String JDBC_POOL__WHEN_EXHAUSTED_ACTION = JdbcConstants.qualifyPool("exhausted.action");
    public static final String JDBC_POOL__TEST_ON_BORROW = JdbcConstants.qualifyPool("test.on.barrow");
    public static final String JDBC_POOL__TEST_ON_RETURN = JdbcConstants.qualifyPool("test.on.return");
    public static final String JDBC_POOL__TEST_WHILE_IDLE = JdbcConstants.qualifyPool("test.on.idle");
    public static final String JDBC_POOL__NUM_TESTS_PER_EVICTION_RUN = JdbcConstants.qualifyPool("number.of.test.per.eviction.run");
    public static final String JDBC_POOL__TIME_BETWEEN_EVICTION_RUNS_MILLIS = JdbcConstants.qualifyPool("time.between.eviction.runs.millis");
    public static final String JDBC_POOL__MIN_EVICTABLE_IDLE_TIME_MILLIS = JdbcConstants.qualifyPool("min.evictable.idle.timeout.millis");
    public static final String JDBC_POOL__SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = JdbcConstants.qualifyPool("soft.min.evictable.timeout.millis");
    public static final String JDBC_POOL__LIFO = JdbcConstants.qualifyPool("lifo");
    public static final String JDBC_POOL__MAX_TOTAL_PREPARED_STATEMENTS = JdbcConstants.qualifyPool("max.total.prepared.statements");
    public static final String JDBC_POOL__MAX_ACTIVE_PREPARED_STATEMENTS = JdbcConstants.qualifyPool("max.active.prepared.statements");
    public static final String JDBC_POOL__MAX_IDLE_PREPARED_STATEMENTS = JdbcConstants.qualifyPool("max.idle.prepared.statements");
    public static final String JDBC_POOL__MIN_IDLE_PREPARED_STATEMENTS = JdbcConstants.qualifyPool("min.idle.prepared.statements");
    public static final String JDBC_POOL__MAX_WAIT_PREPARED_STATEMENTS = JdbcConstants.qualifyPool("max.wait.for.prepared.statements");
    public static final String JDBC_POOL__LOG_ABANDONED = JdbcConstants.qualifyPool("abandoned.logging.enabled");
    public static final String JDBC_POOL__REMOVE_ABANDONED = JdbcConstants.qualifyPool("abandoned.removal.enabled");
    public static final String JDBC_POOL__REMOVE_ABANDONED_TIMEOUT = JdbcConstants.qualifyPool("abandoned.removal.timeout.secs");
    public static final boolean DEFAULT_JDBC__IS_PRODUCTION_DB = false;
    public static final String DEFAULT_JDBC__CONNECTION_DRIVER = null;
    public static final String DEFAULT_JDBC__CONNECTION_URI = null;
    public static final boolean DEFAULT_JDBC__CONNECTION_APPEND_PROPS_TO_URI = false;
    public static final String DEFAULT_JDBC__CONNECTION_USERNAME = null;
    public static final String DEFAULT_JDBC__CONNECTION_PASSWORD = "";
    public static final boolean DEFAULT_JDBC_POOL__ENABLED = true;
    public static final String DEFAULT_JDBC_POOL__CONFIG_FILE_URI = null;
    public static final String DEFAULT_JDBC_POOL__CONNECTION_DRIVER = "org.apache.commons.dbcp.PoolingDriver";
    public static final String DEFAUT_JDBC_POOL__CONNECTION_ID = "jdbc:apache:commons:dbcp:";
    public static final boolean DEFAULT_JDBC_POOL__PREPARED_STATEMENTS_ALLOWED = false;
    public static final int DEFAULT_JDBC_POOL__VALIDATION_QUERY_TIMEOUT_SECS = 10;
    public static final int DEFAULT_JDBC_POOL__MAX_ACTIVE_CONNECTIONS = 10;
    public static final int DEFAULT_JDBC_POOL__MAX_IDLE_CONNECTIONS = 10;
    public static final int DEFAULT_JDBC_POOL__MIN_IDLE_CONNECTIONS = 0;
    public static final long DEFAULT_JDBC_POOL__MAX_WAIT_CONNECTIONS = -1L;
    public static final PoolExhaustedAction DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION = PoolExhaustedAction.WHEN_EXHAUSTED_FAIL;
    public static final boolean DEFAULT_JDBC_POOL__TEST_ON_BORROW = false;
    public static final boolean DEFAULT_JDBC_POOL__TEST_ON_RETURN = false;
    public static final boolean DEFAULT_JDBC_POOL__TEST_WHILE_IDLE = true;
    public static final int DEFAULT_JDBC_POOL__NUM_TESTS_PER_EVICTION_RUN = 1;
    public static final long DEFAULT_JDBC_POOL__TIME_BETWEEN_EVICTION_RUNS_MILLIS = 5000L;
    public static final long DEFAULT_JDBC_POOL__MIN_EVICTABLE_IDLE_TIME_MILLIS = 60000L;
    public static final long DEFAULT_JDBC_POOL__SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1L;
    public static final boolean DEFAULT_JDBC_POOL__LIFO = true;
    public static final int DEFAULT_JDBC_POOL__MAX_TOTAL_PREPARED_STATEMENTS = 20;
    public static final int DEFAULT_JDBC_POOL__MAX_ACTIVE_PREPARED_STATEMENTS = 20;
    public static final int DEFAULT_JDBC_POOL__MAX_IDLE_PREPARED_STATEMENTS = 20;
    public static final int DEFAULT_JDBC_POOL__MIN_IDLE_PREPARED_STATEMENTS = 0;
    public static final long DEFAULT_JDBC_POOL__MAX_WAIT_PREPARED_STATEMENTS = -1L;
    public static final boolean DEFAULT_JDBC_POOL__LOG_ABANDONED = false;
    public static final boolean DEFAULT_JDBC_POOL__REMOVE_ABANDONED = false;
    public static final int DEFAULT_JDBC_POOL__REMOVE_ABANDONED_TIMEOUT = 300;
    public static final String JDBC_SERVER__LOCAL_CONNECTIONS = "127.0.0.1";
    public static final String JDBC_SERVER__REMOTE_CONNECTIONS = "0.0.0.0";
    public static final String JDBC_SERVER__IMPL_CLASSNAME = JdbcConstants.qualifyServer("impl.classname");
    public static final String JDBC_SERVER__ACCEPT_REMOTE_CONNECTIONS = JdbcConstants.qualifyServer("accept.remote.connections");
    public static final String JDBC_SERVER__HOST = JdbcConstants.qualifyServer("host");
    public static final String JDBC_SERVER__PORT = JdbcConstants.qualifyServer("port");
    public static final String JDBC_SERVER__DB_DATA_PATH = JdbcConstants.qualifyServer("db.data.path");
    public static final String JDBC_SERVER__USE_RANDOM_PORT = JdbcConstants.qualifyServer("use.random.path");
    public static final String JDBC_SERVER__ALIVE_WAIT_TIMEOUT_MILLIS = JdbcConstants.qualifyServer("alive.wait.timeout.millis");
    public static final String JDBC_SERVER__START_UP_WAIT_TIMEOUT_MILLIS = JdbcConstants.qualifyServer("startup.wait.timeout.millis");
    public static final String JDBC_SERVER__USERNAME = JdbcConstants.qualifyServer("username");
    public static final String JDBC_SERVER__PASSWORD = JdbcConstants.qualifyServer("password");
    public static final String DEFAULT_JDBC_SERVER__IMPL_CLASSNAME = "org.eclipse.osee.jdbc.internal.dbsupport.hsql.HsqlJdbcServer";
    public static final boolean DEFAULT_JDBC_SERVER__ACCEPT_REMOTE_CONNECTIONS = true;
    public static final String DEFAULT_JDBC_SERVER__HOST = null;
    public static final int DEFAULT_JDBC_SERVER__PORT = -1;
    public static final String DEFAULT_JDBC_SERVER__DB_DATA_PATH = null;
    public static final boolean DEFAULT_JDBC_SERVER__USE_RANDOM_PORT = false;
    public static final long DEFAULT_JDBC_SERVER__ALIVE_WAIT_TIMEOUT_MILLIS = 15000L;
    public static final long DEFAULT_JDBC_SERVER__START_UP_WAIT_TIMEOUT_MILLIS = 15000L;
    public static final String DEFAULT_JDBC_SERVER__USERNAME = null;
    public static final String DEFAULT_JDBC_SERVER__PASSWORD = null;
    public static final String JDBC_SERVICE__CONFIGS = JdbcConstants.qualify("service");
    public static final String JDBC_SERVICE__ID = "service.id";
    public static final String JDBC_SERVICE__OSGI_BINDING = "osgi.binding";

    private JdbcConstants() {
    }

    private static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }

    private static String qualifyPool(String value) {
        return String.format("%s.%s", POOL_NAMESPACE, value);
    }

    private static String qualifyClient(String value) {
        return String.format("%s.%s", CLIENT_NAMESPACE, value);
    }

    private static String qualifyServer(String value) {
        return String.format("%s.%s", SERVER_NAMESPACE, value);
    }

    public static enum JdbcDriverType {
        oracle_thin("oracle.jdbc.OracleDriver", "jdbc:oracle:thin", "%s:@%s:%s:%s"),
        postgresql("org.postgresql.Driver", "jdbc:postgresql", "%s://%s:%s/%s"),
        mysql("com.mysql.jdbc.Driver", "jdbc:mysql", "%s://%s:%s/%s"),
        hsql("org.hsqldb.jdbc.JDBCDriver", "jdbc:hsqldb:hsql", "%s://%s:%s/%s");

        private String driver;
        private String prefix;
        private String uriFormat;

        private JdbcDriverType(String driver, String prefix, String uriFormat) {
            this.driver = driver;
            this.prefix = prefix;
            this.uriFormat = uriFormat;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUriFormat() {
            return this.uriFormat;
        }

        public static JdbcDriverType fromUri(String uri) {
            JdbcDriverType toReturn = null;
            if (Strings.isValid((String)uri)) {
                JdbcDriverType[] jdbcDriverTypeArray = JdbcDriverType.values();
                int n = jdbcDriverTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JdbcDriverType type = jdbcDriverTypeArray[n2];
                    if (uri.startsWith(type.getPrefix())) {
                        toReturn = type;
                        break;
                    }
                    ++n2;
                }
            }
            return toReturn;
        }
    }

    public static enum PoolExhaustedAction {
        WHEN_EXHAUSTED_FAIL(0),
        WHEN_EXHAUSTED_BLOCK(1),
        WHEN_EXHAUSTED_GROW(2);

        byte byteValue;

        private PoolExhaustedAction(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte asByteValue() {
            return this.byteValue;
        }

        public static PoolExhaustedAction fromByte(byte value) {
            PoolExhaustedAction toReturn = DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION;
            PoolExhaustedAction[] poolExhaustedActionArray = PoolExhaustedAction.values();
            int n = poolExhaustedActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PoolExhaustedAction action = poolExhaustedActionArray[n2];
                if (action.asByteValue() == value) {
                    toReturn = action;
                    break;
                }
                ++n2;
            }
            return toReturn;
        }

        public static PoolExhaustedAction fromString(String value) {
            PoolExhaustedAction toReturn = DEFAULT_JDBC_POOL__WHEN_EXHAUSTED_ACTION;
            PoolExhaustedAction[] poolExhaustedActionArray = PoolExhaustedAction.values();
            int n = poolExhaustedActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PoolExhaustedAction action = poolExhaustedActionArray[n2];
                if (action.name().equals(value)) {
                    toReturn = action;
                    break;
                }
                ++n2;
            }
            return toReturn;
        }
    }
}

