/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.PostProcessor;

public class FileInfoLogger
implements PostProcessor {
    private static final Log LOG = LogFactory.getLog(FileInfoLogger.class);
    private static int loc = 0;
    private static int files = 0;
    private String messagePattern = "{1}: {2} LOC, total: {3} LOC in {4} files";
    private int logLevel = 2;

    public void afterClose(FileHandle handle) {
    }

    public void beforeWriteAndClose(FileHandle handle) {
        block13: {
            BufferedReader reader = new BufferedReader(new StringReader(handle.getBuffer().toString()));
            int lines = 0;
            try {
                if (this.messagePattern.contains("{2}") || this.messagePattern.contains("{3}")) {
                    while (reader.readLine() != null) {
                        ++lines;
                    }
                    loc += lines;
                }
                ++files;
                switch (this.logLevel) {
                    case 2: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)this.getLogMessage(handle, lines));
                        }
                        break;
                    }
                    case 1: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)this.getLogMessage(handle, lines));
                        }
                        break;
                    }
                    case 0: {
                        if (!LOG.isTraceEnabled()) break;
                        LOG.trace((Object)this.getLogMessage(handle, lines));
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug((Object)(String.valueOf(handle.getAbsolutePath()) + ": " + e.getMessage()));
            }
        }
    }

    private String getLogMessage(FileHandle handle, int lines) {
        return MessageFormat.format(this.messagePattern, handle.getAbsolutePath(), handle.getAbsolutePath(), lines, loc, files);
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }
}

