/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.predicate;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IRelationType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;

public class PredicateHandlerUtil {
    public static Collection<AttributeTypeId> getAttributeTypes(Collection<String> types) {
        LinkedHashSet<AttributeTypeId> attrTypes = new LinkedHashSet<AttributeTypeId>();
        for (String value : types) {
            long uuid = PredicateHandlerUtil.parseUuid(value);
            if (uuid == -1L) continue;
            attrTypes.add(AttributeTypeId.valueOf((Long)uuid));
        }
        return attrTypes;
    }

    public static Collection<ArtifactTypeToken> getArtifactTypeTokens(Collection<String> types) {
        LinkedHashSet<ArtifactTypeToken> artTypes = new LinkedHashSet<ArtifactTypeToken>();
        for (String value : types) {
            long uuid = PredicateHandlerUtil.parseUuid(value);
            if (uuid == -1L) continue;
            artTypes.add(ArtifactTypeToken.valueOf((long)uuid, (String)"SearchArtifactType", (ArtifactTypeToken[])new ArtifactTypeToken[0]));
        }
        return artTypes;
    }

    public static Collection<IRelationType> getIRelationTypes(Collection<String> rels) {
        LinkedHashSet<IRelationType> types = new LinkedHashSet<IRelationType>();
        for (String value : rels) {
            long longUuid = PredicateHandlerUtil.parseUuid(value);
            if (longUuid == -1L) continue;
            types.add((IRelationType)RelationTypeToken.create((long)longUuid, (String)"SearchRelationType"));
        }
        return types;
    }

    public static Collection<RelationTypeSide> getRelationTypeSides(Collection<String> rels) {
        LinkedHashSet<RelationTypeSide> relSides = new LinkedHashSet<RelationTypeSide>();
        for (String value : rels) {
            long longUuid;
            char sideChar = value.charAt(0);
            String uuid = value.substring(1);
            RelationSide side = RelationSide.SIDE_A;
            if (sideChar == 'B') {
                side = RelationSide.SIDE_B;
            }
            if ((longUuid = PredicateHandlerUtil.parseUuid(uuid)) == -1L) continue;
            relSides.add(RelationTypeSide.create((RelationSide)side, (long)longUuid, (String)"SearchRelationTypeSide"));
        }
        return relSides;
    }

    private static long parseUuid(String uuid) {
        if (uuid.matches("-?\\d+")) {
            return Long.parseLong(uuid);
        }
        return -1L;
    }
}

